/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.api.users.dev.LoginCookieUtils;
import com.google.appengine.repackaged.org.apache.commons.httpclient.Cookie;
import com.google.appengine.tools.remoteapi.AppEngineClient;
import com.google.appengine.tools.remoteapi.HostedAppEngineClient;
import com.google.appengine.tools.remoteapi.HostedClientLogin;
import com.google.appengine.tools.remoteapi.RemoteApiDelegate;
import com.google.appengine.tools.remoteapi.RemoteApiOptions;
import com.google.appengine.tools.remoteapi.RemoteRpc;
import com.google.appengine.tools.remoteapi.StandaloneAppEngineClient;
import com.google.appengine.tools.remoteapi.StandaloneClientLogin;
import com.google.appengine.tools.remoteapi.ThreadLocalDelegate;
import com.google.appengine.tools.remoteapi.ToolEnvironment;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RemoteApiInstaller {
    private static final Pattern PAIR_REGEXP = Pattern.compile("([a-z0-9_-]+): +'?([:~.a-z0-9_-]+)'?");
    private static ConsoleHandler remoteMethodHandler;
    private InstallerState installerState;

    private static synchronized StreamHandler getStreamHandler() {
        if (remoteMethodHandler == null) {
            remoteMethodHandler = new ConsoleHandler();
            remoteMethodHandler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return record.getMessage() + "\n";
                }
            });
            remoteMethodHandler.setLevel(Level.FINE);
        }
        return remoteMethodHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(RemoteApiOptions options) throws IOException {
        if ((options = options.copy()).getHostname() == null) {
            throw new IllegalArgumentException("server not set in options");
        }
        if (options.getUserEmail() == null) {
            throw new IllegalArgumentException("credentials not set in options");
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            RemoteApiDelegate remoteApiDelegate;
            if (this.installerState != null) {
                throw new IllegalStateException("remote API is already installed");
            }
            ApiProxy.Delegate originalDelegate = ApiProxy.getDelegate();
            ApiProxy.Environment originalEnv = ApiProxy.getCurrentEnvironment();
            AppEngineClient installedClient = this.login(options);
            if (originalDelegate instanceof ThreadLocalDelegate) {
                ThreadLocalDelegate installedDelegate = (ThreadLocalDelegate)originalDelegate;
                ApiProxy.Delegate globalDelegate = installedDelegate.getGlobalDelegate();
                remoteApiDelegate = this.createDelegate(options, installedClient, globalDelegate);
                if (installedDelegate.getDelegateForThread() != null) {
                    throw new IllegalStateException("remote API is already installed");
                }
                installedDelegate.setDelegateForThread(remoteApiDelegate);
            } else {
                remoteApiDelegate = this.createDelegate(options, installedClient, (ApiProxy.Delegate<ApiProxy.Environment>)originalDelegate);
                ApiProxy.setDelegate(new ThreadLocalDelegate<ApiProxy.Environment>(originalDelegate, remoteApiDelegate));
            }
            ApiProxy.Environment installedEnv = null;
            if (originalEnv == null) {
                installedEnv = this.createEnv(options, installedClient);
                ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)installedEnv);
            }
            this.installerState = new InstallerState(originalEnv, installedClient, remoteApiDelegate, installedEnv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.installerState == null) {
                throw new IllegalArgumentException("remote API is already uninstalled");
            }
            if (this.installerState.installedEnv != null && this.installerState.installedEnv != ApiProxy.getCurrentEnvironment()) {
                throw new IllegalStateException("Can't uninstall because the current environment has been modified.");
            }
            ApiProxy.Delegate currentDelegate = ApiProxy.getDelegate();
            if (!(currentDelegate instanceof ThreadLocalDelegate)) {
                throw new IllegalStateException("Can't uninstall because the current delegate has been modified.");
            }
            ThreadLocalDelegate tld = (ThreadLocalDelegate)currentDelegate;
            if (tld.getDelegateForThread() == null) {
                throw new IllegalArgumentException("remote API is already uninstalled");
            }
            tld.clearThreadDelegate();
            if (this.installerState.installedEnv != null) {
                ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)this.installerState.savedEnv);
            }
            this.installerState.remoteApiDelegate.shutdown();
            this.installerState = null;
        }
    }

    public String serializeCredentials() {
        return this.installerState.installedClient.serializeCredentials();
    }

    public void logMethodCalls() {
        Logger logger = Logger.getLogger(RemoteApiDelegate.class.getName());
        logger.setLevel(Level.FINE);
        if (!Arrays.asList(logger.getHandlers()).contains(RemoteApiInstaller.getStreamHandler())) {
            logger.addHandler(RemoteApiInstaller.getStreamHandler());
        }
    }

    public void resetRpcCount() {
        this.installerState.remoteApiDelegate.resetRpcCount();
    }

    public int getRpcCount() {
        return this.installerState.remoteApiDelegate.getRpcCount();
    }

    protected AppEngineClient login(RemoteApiOptions options) throws IOException {
        return this.loginImpl(options);
    }

    protected RemoteApiDelegate createDelegate(RemoteApiOptions options, AppEngineClient client, ApiProxy.Delegate<ApiProxy.Environment> originalDelegate) {
        return RemoteApiDelegate.newInstance(new RemoteRpc(client), options, originalDelegate);
    }

    protected ApiProxy.Environment createEnv(RemoteApiOptions options, AppEngineClient client) {
        return new ToolEnvironment(client.getAppId(), options.getUserEmail());
    }

    private AppEngineClient loginImpl(RemoteApiOptions options) throws IOException {
        List<Cookie> authCookies = !this.authenticationRequiresCookies(options) ? Collections.emptyList() : (options.getCredentialsToReuse() != null ? RemoteApiInstaller.parseSerializedCredentials(options.getUserEmail(), options.getHostname(), options.getCredentialsToReuse()) : (options.getHostname().equals("localhost") ? Collections.singletonList(RemoteApiInstaller.makeDevAppServerCookie(options.getHostname(), options.getUserEmail())) : (ApiProxy.getCurrentEnvironment() != null ? new HostedClientLogin().login(options.getHostname(), options.getUserEmail(), options.getPassword()) : new StandaloneClientLogin().login(options.getHostname(), options.getUserEmail(), options.getPassword()))));
        String appId = this.getAppIdFromServer(authCookies, options);
        return this.createAppEngineClient(options, authCookies, appId);
    }

    boolean authenticationRequiresCookies(RemoteApiOptions options) {
        return true;
    }

    AppEngineClient createAppEngineClient(RemoteApiOptions options, List<Cookie> authCookies, String appId) {
        if (ApiProxy.getCurrentEnvironment() != null) {
            return new HostedAppEngineClient(options, authCookies, appId);
        }
        return new StandaloneAppEngineClient(options, authCookies, appId);
    }

    public static Cookie makeDevAppServerCookie(String hostname, String email) {
        String cookieValue = email + ":true:" + LoginCookieUtils.encodeEmailAsUserId(email);
        Cookie cookie = new Cookie(hostname, "dev_appserver_login", cookieValue);
        cookie.setPath("/");
        return cookie;
    }

    String getAppIdFromServer(List<Cookie> authCookies, RemoteApiOptions options) throws IOException {
        AppEngineClient tempClient = this.createAppEngineClient(options, authCookies, null);
        AppEngineClient.Response response = tempClient.get(options.getRemoteApiPath());
        int status = response.getStatusCode();
        if (status != 200) {
            throw new IOException("can't get appId from remote api; status code = " + status);
        }
        String body = response.getBodyAsString();
        Map<String, String> props = RemoteApiInstaller.parseYamlMap(body);
        String appId = props.get("app_id");
        if (appId == null) {
            throw new IOException("unexpected response from remote api: " + body);
        }
        return appId;
    }

    static Map<String, String> parseYamlMap(String input) {
        String[] pairs;
        HashMap<String, String> result = new HashMap<String, String>();
        if (!(input = input.trim()).startsWith("{") || !input.endsWith("}")) {
            return Collections.emptyMap();
        }
        input = input.substring(1, input.length() - 1);
        for (String pair : pairs = input.split(", +")) {
            Matcher matcher = PAIR_REGEXP.matcher(pair);
            if (!matcher.matches()) continue;
            result.put(matcher.group(1), matcher.group(2));
        }
        return result;
    }

    static List<Cookie> parseSerializedCredentials(String expectedEmail, String expectedHost, String serializedCredentials) throws IOException {
        Map<String, List<String>> props = RemoteApiInstaller.parseProperties(serializedCredentials);
        RemoteApiInstaller.checkOneProperty(props, "email");
        RemoteApiInstaller.checkOneProperty(props, "host");
        String email = props.get("email").get(0);
        if (!expectedEmail.equals(email)) {
            throw new IOException("credentials don't match current user email");
        }
        String host = props.get("host").get(0);
        if (!expectedHost.equals(host)) {
            throw new IOException("credentials don't match current host");
        }
        ArrayList<Cookie> result = new ArrayList<Cookie>();
        for (String line : props.get("cookie")) {
            result.add(RemoteApiInstaller.parseCookie(line, host));
        }
        return result;
    }

    private static Cookie parseCookie(String line, String host) throws IOException {
        int firstEqual = line.indexOf(61);
        if (firstEqual < 1) {
            throw new IOException("invalid cookie in credentials");
        }
        String key = line.substring(0, firstEqual);
        String value = line.substring(firstEqual + 1);
        Cookie cookie = new Cookie(host, key, value);
        cookie.setPath("/");
        return cookie;
    }

    private static void checkOneProperty(Map<String, List<String>> props, String key) throws IOException {
        if (props.get(key).size() != 1) {
            String message = "invalid credential file (should have one property named '" + key + "')";
            throw new IOException(message);
        }
    }

    private static Map<String, List<String>> parseProperties(String serializedCredentials) {
        HashMap<String, List<String>> props = new HashMap<String, List<String>>();
        for (String line : serializedCredentials.split("\n")) {
            if ((line = line.trim()).startsWith("#") || !line.contains("=")) continue;
            int firstEqual = line.indexOf(61);
            String key = line.substring(0, firstEqual);
            String value = line.substring(firstEqual + 1);
            ArrayList<String> values = (ArrayList<String>)props.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                props.put(key, values);
            }
            values.add(value);
        }
        return props;
    }

    private static class InstallerState {
        private final ApiProxy.Environment savedEnv;
        private final AppEngineClient installedClient;
        private final RemoteApiDelegate remoteApiDelegate;
        private final ApiProxy.Environment installedEnv;

        InstallerState(ApiProxy.Environment savedEnv, AppEngineClient installedClient, RemoteApiDelegate remoteApiDelegate, ApiProxy.Environment installedEnv) {
            this.savedEnv = savedEnv;
            this.installedClient = installedClient;
            this.remoteApiDelegate = remoteApiDelegate;
            this.installedEnv = installedEnv;
        }
    }
}

