/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

public class RemoteApiOptions {
    private String hostname;
    private int port;
    private String userEmail;
    private String password;
    private String credentialsToReuse;
    private String remoteApiPath = "/remote_api";
    private int maxConcurrentRequests = 5;
    private int datastoreQueryFetchSize = 500;
    private int maxHttpResponseSize = 0x2100000;

    public RemoteApiOptions() {
    }

    RemoteApiOptions(RemoteApiOptions original) {
        this.hostname = original.hostname;
        this.port = original.port;
        this.userEmail = original.userEmail;
        this.password = original.password;
        this.credentialsToReuse = original.credentialsToReuse;
        this.remoteApiPath = original.remoteApiPath;
        this.maxConcurrentRequests = original.maxConcurrentRequests;
        this.datastoreQueryFetchSize = original.datastoreQueryFetchSize;
        this.maxHttpResponseSize = original.maxHttpResponseSize;
    }

    public RemoteApiOptions server(String newHostname, int newPort) {
        this.hostname = newHostname;
        this.port = newPort;
        return this;
    }

    public RemoteApiOptions credentials(String newUserEMail, String newPassword) {
        this.userEmail = newUserEMail;
        this.password = newPassword;
        this.credentialsToReuse = null;
        return this;
    }

    public RemoteApiOptions reuseCredentials(String newUserEmail, String serializedCredentials) {
        this.userEmail = newUserEmail;
        this.password = null;
        this.credentialsToReuse = serializedCredentials;
        return this;
    }

    public RemoteApiOptions remoteApiPath(String newPath) {
        this.remoteApiPath = newPath;
        return this;
    }

    public RemoteApiOptions maxConcurrentRequests(int newValue) {
        this.maxConcurrentRequests = newValue;
        return this;
    }

    public RemoteApiOptions datastoreQueryFetchSize(int newValue) {
        this.datastoreQueryFetchSize = newValue;
        return this;
    }

    public RemoteApiOptions maxHttpResponseSize(int newValue) {
        this.maxHttpResponseSize = newValue;
        return this;
    }

    public RemoteApiOptions copy() {
        return new RemoteApiOptions(this);
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCredentialsToReuse() {
        return this.credentialsToReuse;
    }

    public String getRemoteApiPath() {
        return this.remoteApiPath;
    }

    public int getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    public int getDatastoreQueryFetchSize() {
        return this.datastoreQueryFetchSize;
    }

    public int getMaxHttpResponseSize() {
        return this.maxHttpResponseSize;
    }
}

