/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api;

import com.google.apphosting.api.ApiProxy;
import java.util.concurrent.ThreadFactory;

public final class ThreadManager {
    private static final String REQUEST_THREAD_FACTORY_ATTR = "com.google.appengine.api.ThreadManager.REQUEST_THREAD_FACTORY";
    private static final String BACKGROUND_THREAD_FACTORY_ATTR = "com.google.appengine.api.ThreadManager.BACKGROUND_THREAD_FACTORY";

    public static ThreadFactory currentRequestThreadFactory() {
        return (ThreadFactory)ApiProxy.getCurrentEnvironment().getAttributes().get(REQUEST_THREAD_FACTORY_ATTR);
    }

    public static Thread createThreadForCurrentRequest(Runnable runnable) {
        return ThreadManager.currentRequestThreadFactory().newThread(runnable);
    }

    public static ThreadFactory backgroundThreadFactory() {
        return (ThreadFactory)ApiProxy.getCurrentEnvironment().getAttributes().get(BACKGROUND_THREAD_FACTORY_ATTR);
    }

    public static Thread createBackgroundThread(Runnable runnable) {
        return ThreadManager.backgroundThreadFactory().newThread(runnable);
    }
}

