/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import javax.jdo.JDOException;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.RollbackException;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.api.jpa.NucleusJPAHelper;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JPAEntityTransaction
implements EntityTransaction {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)NucleusJPAHelper.class.getClassLoader());
    ExecutionContext ec;

    public JPAEntityTransaction(ExecutionContext ec) {
        this.ec = ec;
    }

    public boolean isActive() {
        return this.ec.getTransaction().isActive();
    }

    public void begin() {
        this.assertNotActive();
        try {
            this.ec.getTransaction().begin();
        }
        catch (NucleusException ne) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(ne);
        }
    }

    public void commit() {
        this.assertActive();
        if (this.ec.getTransaction().getRollbackOnly()) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug((Object)LOCALISER.msg("015020"));
            }
            throw new RollbackException(LOCALISER.msg("015020"));
        }
        try {
            this.ec.getTransaction().commit();
        }
        catch (NucleusTransactionException nte) {
            Throwable cause = nte.getCause();
            PersistenceException pe = null;
            pe = cause instanceof JDOException ? NucleusJPAHelper.getJPAExceptionForJDOException((JDOException)cause) : NucleusJPAHelper.getJPAExceptionForNucleusException((NucleusException)cause);
            throw new RollbackException(LOCALISER.msg("015007"), (Throwable)pe);
        }
        catch (NucleusException ne) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(ne);
        }
    }

    public void rollback() {
        this.assertActive();
        try {
            this.ec.getTransaction().rollback();
        }
        catch (NucleusException ne) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(ne);
        }
    }

    public boolean getRollbackOnly() {
        this.assertActive();
        return this.ec.getTransaction().getRollbackOnly();
    }

    public void setRollbackOnly() {
        this.assertActive();
        this.ec.getTransaction().setRollbackOnly();
    }

    public void setOption(String option, int value) {
        this.ec.getTransaction().setOption(option, value);
    }

    public void setOption(String option, boolean value) {
        this.ec.getTransaction().setOption(option, value);
    }

    public void setOption(String option, String value) {
        this.ec.getTransaction().setOption(option, value);
    }

    protected void assertActive() {
        if (!this.ec.getTransaction().isActive()) {
            throw new IllegalStateException(LOCALISER.msg("015040"));
        }
    }

    protected void assertNotActive() {
        if (this.ec.getTransaction().isActive()) {
            throw new IllegalStateException(LOCALISER.msg("015032"));
        }
    }

    public void registerEventListener(TransactionEventListener listener) {
        this.ec.getTransaction().bindTransactionEventListener(listener);
    }

    public void deregisterEventListener(TransactionEventListener listener) {
        this.ec.getTransaction().removeTransactionEventListener(listener);
    }
}

