/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.compiler;

import java.util.Collection;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.query.JPQLQueryHelper;
import org.datanucleus.query.compiler.JPQLParser;
import org.datanucleus.query.compiler.JavaQueryCompiler;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.symbol.PropertySymbol;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.util.Imports;

public class JPQLCompiler
extends JavaQueryCompiler {
    public JPQLCompiler(MetaDataManager metaDataManager, ClassLoaderResolver clr, String from, Class candidateClass, Collection candidates, String filter, Imports imports, String ordering, String result, String grouping, String having, String params, String update) {
        super(metaDataManager, clr, from, candidateClass, candidates, filter, imports, ordering, result, grouping, having, params, null, update);
        this.from = from;
        this.caseSensitiveAliases = false;
    }

    public QueryCompilation compile(Map parameters, Map subqueryMap) {
        String resultExprId;
        this.parser = new JPQLParser(null, parameters);
        this.symtbl = new SymbolTable(this.clr);
        this.symtbl.setSymbolResolver(this);
        if (this.parentCompiler != null) {
            this.symtbl.setParentSymbolTable(this.parentCompiler.symtbl);
        }
        if (subqueryMap != null && !subqueryMap.isEmpty()) {
            for (String subqueryName : subqueryMap.keySet()) {
                PropertySymbol sym = new PropertySymbol(subqueryName);
                sym.setType(2);
                this.symtbl.addSymbol(sym);
            }
        }
        Expression[] exprFrom = this.compileFrom();
        this.compileCandidatesParametersVariables(parameters);
        Expression exprFilter = this.compileFilter();
        Expression[] exprOrdering = this.compileOrdering();
        Expression[] exprResult = this.compileResult();
        Expression[] exprGrouping = this.compileGrouping();
        Expression exprHaving = this.compileHaving();
        Expression[] exprUpdate = this.compileUpdate();
        if (exprResult != null && exprResult.length == 1 && exprResult[0] instanceof PrimaryExpression && (resultExprId = ((PrimaryExpression)exprResult[0]).getId()).equalsIgnoreCase(this.candidateAlias)) {
            exprResult = null;
        }
        QueryCompilation compilation = new QueryCompilation(this.candidateClass, this.candidateAlias, this.symtbl, exprResult, exprFrom, exprFilter, exprGrouping, exprHaving, exprOrdering, exprUpdate);
        compilation.setQueryLanguage(this.getLanguage());
        return compilation;
    }

    public boolean supportsImplicitVariables() {
        return false;
    }

    public boolean caseSensitiveSymbolNames() {
        return false;
    }

    public String getLanguage() {
        return "JPQL";
    }

    protected boolean isKeyword(String name) {
        return JPQLQueryHelper.isKeyword(name);
    }
}

