/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.agent.impl;

import com.google.appengine.tools.development.agent.impl.Agent;
import com.google.appengine.tools.development.agent.impl.BlackList;
import com.google.appengine.tools.development.agent.impl.Transformer;
import java.lang.instrument.Instrumentation;
import java.util.Set;
import java.util.WeakHashMap;

public class AgentImpl
implements Agent {
    static final String AGENT_RUNTIME = "com/google/appengine/tools/development/agent/runtime/Runtime";
    private static AgentImpl self = new AgentImpl();
    private WeakHashMap<ClassLoader, Object> appUrlClassLoaders = new WeakHashMap();

    public void run(Instrumentation instrumentation, boolean treatRestrictedClassListViolationsAsErrors) {
        instrumentation.addTransformer(new Transformer(treatRestrictedClassListViolationsAsErrors));
    }

    @Override
    public Set<String> getBlackList() {
        return BlackList.getBlackList();
    }

    @Override
    public void recordAppClassLoader(ClassLoader loader) {
        this.appUrlClassLoaders.put(loader, null);
    }

    public static AgentImpl getInstance() {
        return self;
    }

    public boolean isAppConstructedURLClassLoader(ClassLoader loader) {
        return this.appUrlClassLoaders.containsKey(loader);
    }
}

