/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.DevAppServerFactory;
import com.google.appengine.tools.info.SdkInfo;
import com.google.appengine.tools.info.UpdateCheck;
import com.google.appengine.tools.util.Action;
import com.google.appengine.tools.util.Logging;
import com.google.appengine.tools.util.Option;
import com.google.appengine.tools.util.Parser;
import java.awt.Toolkit;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class DevAppServerMain {
    private static String originalTimeZone;
    private final Action ACTION = new StartAction();
    private String server = SdkInfo.getDefaultServer();
    private String address = "127.0.0.1";
    private int port = 8080;
    private boolean disableUpdateCheck;
    private String generatedDirectory = null;
    private boolean disableRestrictedCheck = false;
    private final List<Option> PARSERS = Arrays.asList(new Option("h", "help", true){

        @Override
        public void apply() {
            DevAppServerMain.printHelp(System.err);
            System.exit(0);
        }
    }, new Option("s", "server", false){

        @Override
        public void apply() {
            DevAppServerMain.this.server = this.getValue();
        }
    }, new Option("a", "address", false){

        @Override
        public void apply() {
            DevAppServerMain.this.address = this.getValue();
        }
    }, new Option("p", "port", false){

        @Override
        public void apply() {
            DevAppServerMain.this.port = Integer.valueOf(this.getValue());
        }
    }, new Option(null, "sdk_root", false){

        @Override
        public void apply() {
            System.setProperty("appengine.sdk.root", this.getValue());
        }
    }, new Option(null, "disable_update_check", true){

        @Override
        public void apply() {
            DevAppServerMain.this.disableUpdateCheck = true;
        }
    }, new Option(null, "generated_dir", false){

        @Override
        public void apply() {
            DevAppServerMain.this.generatedDirectory = this.getValue();
        }
    }, new Option(null, "disable_restricted_check", true){

        @Override
        public void apply() {
            DevAppServerMain.this.disableRestrictedCheck = true;
        }
    });

    public static void main(String[] args) throws Exception {
        DevAppServerMain.recordTimeZone();
        Logging.initializeLogging();
        if (System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
            Toolkit.getDefaultToolkit();
        }
        new DevAppServerMain(args);
    }

    private static void recordTimeZone() {
        originalTimeZone = System.getProperty("user.timezone");
    }

    public DevAppServerMain(String[] args) throws Exception {
        Parser parser = new Parser();
        Parser.ParseResult result = parser.parseArgs(this.ACTION, this.PARSERS, args);
        result.applyArgs();
    }

    public static void printHelp(PrintStream out) {
        out.println("Usage: <dev-appserver> [options] <war directory>");
        out.println("");
        out.println("Options:");
        out.println(" --help, -h                 Show this help message and exit.");
        out.println(" --server=SERVER            The server to use to determine the latest");
        out.println("  -s SERVER                   SDK version.");
        out.println(" --address=ADDRESS          The address of the interface on the local machine");
        out.println("  -a ADDRESS                  to bind to (or 0.0.0.0 for all interfaces).");
        out.println(" --port=PORT                The port number to bind to on the local machine.");
        out.println("  -p PORT");
        out.println(" --sdk_root=root            Overrides where the SDK is located.");
        out.println(" --disable_update_check     Disable the check for newer SDK versions.");
        out.println(" --generated_dir=dir        Set the directory where generated files are created.");
    }

    public static void validateWarPath(File war) {
        if (!war.exists()) {
            System.out.println("Unable to find the webapp directory " + war);
            DevAppServerMain.printHelp(System.err);
            System.exit(1);
        } else if (!war.isDirectory()) {
            System.out.println("dev_appserver only accepts webapp directories, not war files.");
            DevAppServerMain.printHelp(System.err);
            System.exit(1);
        }
    }

    class StartAction
    extends Action {
        StartAction() {
            super("start");
        }

        @Override
        public void apply() {
            List<String> args = this.getArgs();
            if (args.size() != 1) {
                DevAppServerMain.printHelp(System.err);
                System.exit(1);
            }
            try {
                Properties properties;
                File appDir = new File(args.get(0)).getCanonicalFile();
                DevAppServerMain.validateWarPath(appDir);
                UpdateCheck updateCheck = new UpdateCheck(DevAppServerMain.this.server, appDir, true);
                if (updateCheck.allowedToCheckForUpdates() && !DevAppServerMain.this.disableUpdateCheck) {
                    updateCheck.maybePrintNagScreen(System.err);
                }
                updateCheck.checkJavaVersion(System.err);
                DevAppServer server = new DevAppServerFactory().createDevAppServer(appDir, DevAppServerMain.this.address, DevAppServerMain.this.port);
                Properties stringProperties = properties = System.getProperties();
                this.setTimeZone(stringProperties);
                this.setGeneratedDirectory(stringProperties);
                if (DevAppServerMain.this.disableRestrictedCheck) {
                    stringProperties.put("appengine.disableRestrictedCheck", "");
                }
                server.setServiceProperties(stringProperties);
                server.start();
                try {
                    while (true) {
                        Thread.sleep(3600000L);
                    }
                }
                catch (InterruptedException e) {
                    System.out.println("Shutting down.");
                    System.exit(0);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }

        private void setTimeZone(Map<String, String> serviceProperties) {
            String timeZone = serviceProperties.get("appengine.user.timezone");
            if (timeZone != null) {
                TimeZone.setDefault(TimeZone.getTimeZone(timeZone));
            } else {
                timeZone = originalTimeZone;
            }
            serviceProperties.put("appengine.user.timezone.impl", timeZone);
        }

        private void setGeneratedDirectory(Map<String, String> stringProperties) {
            if (DevAppServerMain.this.generatedDirectory != null) {
                File dir = new File(DevAppServerMain.this.generatedDirectory);
                String error = null;
                if (dir.exists()) {
                    if (!dir.isDirectory()) {
                        error = DevAppServerMain.this.generatedDirectory + " is not a directory.";
                    } else if (!dir.canWrite()) {
                        error = DevAppServerMain.this.generatedDirectory + " is not writable.";
                    }
                } else if (!dir.mkdirs()) {
                    error = "Could not make " + DevAppServerMain.this.generatedDirectory;
                }
                if (error != null) {
                    System.err.println(error);
                    System.exit(1);
                }
                stringProperties.put("appengine.generated.dir", DevAppServerMain.this.generatedDirectory);
            }
        }
    }
}

