/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import org.datanucleus.store.appengine.Ints;
import org.datanucleus.store.appengine.Longs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimitiveArrays {
    private PrimitiveArrays() {
    }

    public static short[] toShortArray(Collection<Short> collection) {
        int counter = 0;
        short[] array = new short[collection.size()];
        for (Short x : collection) {
            array[counter++] = x;
        }
        return array;
    }

    public static List<Short> asList(short[] backingArray) {
        return new ShortArray(backingArray);
    }

    private static <T> T checkNotNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    @Deprecated
    public static List<Integer> asList(int[] backingArray) {
        return Ints.asList(backingArray);
    }

    public static double[] toDoubleArray(Collection<Double> collection) {
        int counter = 0;
        double[] array = new double[collection.size()];
        for (Double x : collection) {
            array[counter++] = x;
        }
        return array;
    }

    public static List<Double> asList(double[] backingArray) {
        return new DoubleArray(backingArray);
    }

    public static float[] toFloatArray(Collection<Float> collection) {
        int counter = 0;
        float[] array = new float[collection.size()];
        for (Float x : collection) {
            array[counter++] = x.floatValue();
        }
        return array;
    }

    public static List<Float> asList(float[] backingArray) {
        return new FloatArray(backingArray);
    }

    @Deprecated
    public static List<Long> asList(long[] backingArray) {
        return Longs.asList(backingArray);
    }

    public static char[] toCharArray(Collection<Character> collection) {
        int counter = 0;
        char[] array = new char[collection.size()];
        for (Character x : collection) {
            array[counter++] = x.charValue();
        }
        return array;
    }

    public static List<Character> asList(char[] backingArray) {
        return new CharacterArray(backingArray);
    }

    public static boolean[] toBooleanArray(Collection<Boolean> collection) {
        int counter = 0;
        boolean[] array = new boolean[collection.size()];
        for (Boolean x : collection) {
            array[counter++] = x;
        }
        return array;
    }

    public static List<Boolean> asList(boolean[] backingArray) {
        return new BooleanArray(backingArray);
    }

    public static byte[] toByteArray(Collection<Byte> collection) {
        int counter = 0;
        byte[] array = new byte[collection.size()];
        for (Byte x : collection) {
            array[counter++] = x;
        }
        return array;
    }

    public static List<Byte> asList(byte[] backingArray) {
        return new ByteArray(backingArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByteArray
    extends PrimitiveArray<Byte> {
        final byte[] array;
        private static final long serialVersionUID = 0L;

        ByteArray(byte[] array) {
            this.array = (byte[])PrimitiveArrays.checkNotNull(array);
        }

        @Override
        public Byte get(int index) {
            return this.array[index];
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Byte set(int index, Byte element) {
            Byte oldValue = this.array[index];
            this.array[index] = element;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof ByteArray) {
                ByteArray otherByteArray = (ByteArray)o;
                return Arrays.equals(this.array, otherByteArray.array);
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        @Override
        public String toString() {
            return Arrays.toString(this.array);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanArray
    extends PrimitiveArray<Boolean> {
        final boolean[] array;
        private static final long serialVersionUID = 0L;

        BooleanArray(boolean[] array) {
            this.array = (boolean[])PrimitiveArrays.checkNotNull(array);
        }

        @Override
        public Boolean get(int index) {
            return this.array[index];
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Boolean set(int index, Boolean element) {
            Boolean oldValue = this.array[index];
            this.array[index] = element;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof BooleanArray) {
                BooleanArray otherBoolArray = (BooleanArray)o;
                return Arrays.equals(this.array, otherBoolArray.array);
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        @Override
        public String toString() {
            return Arrays.toString(this.array);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CharacterArray
    extends PrimitiveArray<Character> {
        final char[] array;
        private static final long serialVersionUID = 0L;

        CharacterArray(char[] array) {
            this.array = (char[])PrimitiveArrays.checkNotNull(array);
        }

        @Override
        public Character get(int index) {
            return Character.valueOf(this.array[index]);
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Character set(int index, Character element) {
            Character oldValue = Character.valueOf(this.array[index]);
            this.array[index] = element.charValue();
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof CharacterArray) {
                CharacterArray otherCharArray = (CharacterArray)o;
                return Arrays.equals(this.array, otherCharArray.array);
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        @Override
        public String toString() {
            return Arrays.toString(this.array);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FloatArray
    extends PrimitiveArray<Float> {
        final float[] array;
        private static final long serialVersionUID = 0L;

        FloatArray(float[] array) {
            this.array = (float[])PrimitiveArrays.checkNotNull(array);
        }

        @Override
        public Float get(int index) {
            return Float.valueOf(this.array[index]);
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Float set(int index, Float element) {
            Float oldValue = Float.valueOf(this.array[index]);
            this.array[index] = element.floatValue();
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof FloatArray) {
                FloatArray otherFloatArray = (FloatArray)o;
                return Arrays.equals(this.array, otherFloatArray.array);
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        @Override
        public String toString() {
            return Arrays.toString(this.array);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleArray
    extends PrimitiveArray<Double> {
        final double[] array;
        private static final long serialVersionUID = 0L;

        DoubleArray(double[] array) {
            this.array = (double[])PrimitiveArrays.checkNotNull(array);
        }

        @Override
        public Double get(int index) {
            return this.array[index];
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Double set(int index, Double element) {
            Double oldValue = this.array[index];
            this.array[index] = element;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof DoubleArray) {
                DoubleArray otherDoubleArray = (DoubleArray)o;
                return Arrays.equals(this.array, otherDoubleArray.array);
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        @Override
        public String toString() {
            return Arrays.toString(this.array);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShortArray
    extends PrimitiveArray<Short> {
        final short[] array;
        private static final long serialVersionUID = 0L;

        ShortArray(short[] array) {
            this.array = (short[])PrimitiveArrays.checkNotNull(array);
        }

        @Override
        public Short get(int index) {
            return this.array[index];
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Short set(int index, Short element) {
            Short oldValue = this.array[index];
            this.array[index] = element;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof ShortArray) {
                ShortArray otherShortArray = (ShortArray)o;
                return Arrays.equals(this.array, otherShortArray.array);
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        @Override
        public String toString() {
            return Arrays.toString(this.array);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class PrimitiveArray<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private PrimitiveArray() {
        }

        @Override
        public boolean contains(Object o) {
            return o != null && super.contains(o);
        }

        @Override
        public int indexOf(Object o) {
            return o == null ? -1 : super.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return o == null ? -1 : super.lastIndexOf(o);
        }
    }
}

