/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.AbstractHttpContent;
import com.google.api.client.http.HttpContent;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

final class GZipContent
extends AbstractHttpContent {
    private final HttpContent httpContent;
    private final String contentType;

    GZipContent(HttpContent httpContent, String contentType) {
        this.httpContent = httpContent;
        this.contentType = contentType;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        GZIPOutputStream zipper = new GZIPOutputStream(out);
        this.httpContent.writeTo(zipper);
        zipper.close();
    }

    @Override
    public String getEncoding() {
        return "gzip";
    }

    @Override
    public String getType() {
        return this.contentType;
    }

    @Override
    public boolean retrySupported() {
        return this.httpContent.retrySupported();
    }
}

