/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import jline.ConsoleReader;

public abstract class SqlConsole {
    static SqlConsole create() {
        if (SqlConsole.hasTerminal()) {
            try {
                return new JlineSqlConsole();
            }
            catch (IOException e) {
                System.err.println("Error initializing jline; Using Java stdin.");
            }
        }
        return new BufferedReaderConsole(new InputStreamReader(System.in));
    }

    public static SqlConsole create(Reader reader) {
        return new BufferedReaderConsole(reader);
    }

    static boolean hasTerminal() {
        return System.console() != null;
    }

    abstract String readLine(String var1) throws IOException;

    public abstract void out(String var1);

    static class BufferedReaderConsole
    extends SqlConsole {
        private final BufferedReader in;

        public BufferedReaderConsole(Reader reader) {
            this.in = new BufferedReader(reader);
        }

        @Override
        String readLine(String prompt) throws IOException {
            String line = this.in.readLine();
            if (line == null) {
                throw new EOFException();
            }
            if (line.isEmpty()) {
                line = null;
            }
            return line;
        }

        @Override
        public void out(String message) {
        }
    }

    static class JlineSqlConsole
    extends SqlConsole {
        private final ConsoleReader console = new ConsoleReader();

        private JlineSqlConsole() throws IOException {
        }

        @Override
        String readLine(String prompt) throws IOException {
            String line = this.console.readLine(prompt);
            if (line == null) {
                throw new EOFException("^D");
            }
            return line;
        }

        @Override
        public void out(String message) {
            System.err.println(message);
        }
    }
}

