/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc;

import com.google.cloud.sql.jdbc.Connection;
import com.google.cloud.sql.jdbc.ParameterMetadata;
import com.google.cloud.sql.jdbc.ResultSet;
import com.google.cloud.sql.jdbc.ResultSetMetaData;
import com.google.cloud.sql.jdbc.Statement;
import com.google.cloud.sql.jdbc.internal.BoundValue;
import com.google.cloud.sql.jdbc.internal.Charsets;
import com.google.cloud.sql.jdbc.internal.ClientSideBlob;
import com.google.cloud.sql.jdbc.internal.ClientSideClob;
import com.google.cloud.sql.jdbc.internal.ClientSideNClob;
import com.google.cloud.sql.jdbc.internal.Exceptions;
import com.google.cloud.sql.jdbc.internal.JdbcType;
import com.google.cloud.sql.jdbc.internal.SqlRpcOptions;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.protos.cloud.sql.Client;
import com.google.protos.cloud.sql.ExecRequest;
import com.google.protos.cloud.sql.ExecResponse;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PreparedStatement
extends Statement
implements java.sql.PreparedStatement {
    private static final int DEFAULT_COPY_BLOCK_SIZE = 4096;
    protected static final int DEFAULT_LOB_LENGTH = 4096;
    private final String sql;
    private final TreeMap<Integer, BoundValue> indexedBindParametersMap = Util.newTreeMap();
    private final Map<String, BoundValue> namedBindParametersMap = Util.newHashMap();
    private final List<List<Client.BindVariableProto>> batchBindParameters = Util.newArrayList();

    PreparedStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, Connection conn, Url url) {
        super(resultSetType, resultSetConcurrency, resultSetHoldability, conn, url);
        this.sql = sql;
        this.rpcOptions.setStatementType(ExecRequest.StatementType.PREPARED_STATEMENT);
    }

    @Override
    public void addBatch() throws SQLException {
        this.throwIfNotOpen();
        this.batchBindParameters.add(PreparedStatement.toBindParametersList(this.indexedBindParametersMap, this.namedBindParametersMap));
        this.indexedBindParametersMap.clear();
        this.namedBindParametersMap.clear();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.throwIfNotOpen();
        this.batchBindParameters.clear();
        super.clearBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.throwIfNotOpen();
        this.indexedBindParametersMap.clear();
        this.namedBindParametersMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.throwIfNotOpen();
        if (this.batchBindParameters.isEmpty()) {
            return EMPTY_ROWS_UPDATED;
        }
        try {
            int[] nArray = this.executeBatchImpl(Collections.<String>emptyList());
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.throwIfNotOpen();
        return this.executeImpl(this.sql);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.throwIfNotOpen();
        return this.executeQuery(this.sql);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.throwIfNotOpen();
        return this.executeUpdate(this.sql);
    }

    @Override
    protected ExecResponse executeSqlImpl(SqlRpcOptions options, String sql) throws SQLException {
        this.throwIfNotOpen();
        if (this.indexedBindParametersMap.isEmpty() && this.namedBindParametersMap.isEmpty()) {
            return this.getConnection().executeSql(options, sql);
        }
        return this.getConnection().executeSql(options, sql, PreparedStatement.toBindParametersList(this.indexedBindParametersMap, this.namedBindParametersMap));
    }

    @Override
    protected ExecResponse executeBatchSqlImpl(SqlRpcOptions options, List<String> batchSql) throws SQLException {
        this.throwIfNotOpen();
        return this.getConnection().executeBatchSql(options, this.sql, this.batchBindParameters);
    }

    private static List<Client.BindVariableProto> toBindParametersList(Map<Integer, BoundValue> indexedBindParametersMap, Map<String, BoundValue> namedBindParametersMap) throws SQLException {
        if (!indexedBindParametersMap.isEmpty() && !namedBindParametersMap.isEmpty()) {
            throw Exceptions.newInvalidParameterException("Only named or indexed bind parameters can be used, not both.");
        }
        if (!indexedBindParametersMap.isEmpty()) {
            return Util.toIndexedBindVariableProtos(indexedBindParametersMap);
        }
        return Util.toNamedBindVariableProtos(namedBindParametersMap);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.throwIfNotOpen();
        return null;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.throwIfNotOpen();
        return new ParameterMetadata(this.indexedBindParametersMap);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream is) throws SQLException {
        this.throwIfNotOpen();
        String data = new String(PreparedStatement.toByteArray(is, 4096L), Charsets.US_ASCII);
        this.bindParameter(parameterIndex, BoundValue.of(data, JdbcType.JDBC_TYPE_LONGVARCHAR));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream is, int length) throws SQLException {
        this.throwIfNotOpen();
        String data = new String(PreparedStatement.toByteArray(is, length), Charsets.US_ASCII);
        this.bindParameter(parameterIndex, BoundValue.of(data, JdbcType.JDBC_TYPE_LONGVARCHAR));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream is, long length) throws SQLException {
        this.throwIfNotOpen();
        String data = new String(PreparedStatement.toByteArray(is, length), Charsets.US_ASCII);
        this.bindParameter(parameterIndex, BoundValue.of(data, JdbcType.JDBC_TYPE_LONGVARCHAR));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal b) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterIndex, BoundValue.of(b, JdbcType.JDBC_TYPE_NUMERIC));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream is) throws SQLException {
        this.throwIfNotOpen();
        byte[] bytes = PreparedStatement.toByteArray(is, 4096L);
        this.bindParameter(parameterIndex, BoundValue.of(bytes, JdbcType.JDBC_TYPE_LONGVARBINARY));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream is, int length) throws SQLException {
        this.throwIfNotOpen();
        byte[] bytes = PreparedStatement.toByteArray(is, length);
        this.bindParameter(parameterIndex, BoundValue.of(bytes, JdbcType.JDBC_TYPE_LONGVARBINARY));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream is, long length) throws SQLException {
        this.throwIfNotOpen();
        byte[] bytes = PreparedStatement.toByteArray(is, length);
        this.bindParameter(parameterIndex, BoundValue.of(bytes, JdbcType.JDBC_TYPE_LONGVARBINARY));
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterIndex, BoundValue.of(x, JdbcType.JDBC_TYPE_BLOB));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setBlob(parameterIndex, inputStream, 4096L);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.throwIfNotOpen();
        ClientSideBlob blob = new ClientSideBlob(PreparedStatement.toByteArray(inputStream, (int)length));
        this.bindParameter(parameterIndex, BoundValue.of(blob, JdbcType.JDBC_TYPE_BLOB));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean b) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterIndex, BoundValue.of(b, JdbcType.JDBC_TYPE_BOOLEAN));
    }

    @Override
    public void setByte(int parameterIndex, byte b) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterIndex, BoundValue.of(b, JdbcType.JDBC_TYPE_TINYINT));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterIndex, BoundValue.of(x, JdbcType.JDBC_TYPE_VARBINARY));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.throwIfNotOpen();
        char[] data = PreparedStatement.toCharArray(reader, 4096L);
        this.bindParameter(parameterIndex, BoundValue.of(new String(data), JdbcType.JDBC_TYPE_LONGVARCHAR));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.throwIfNotOpen();
        char[] data = PreparedStatement.toCharArray(reader, length);
        this.bindParameter(parameterIndex, BoundValue.of(new String(data), JdbcType.JDBC_TYPE_LONGVARCHAR));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.throwIfNotOpen();
        char[] data = PreparedStatement.toCharArray(reader, length);
        this.bindParameter(parameterIndex, BoundValue.of(new String(data), JdbcType.JDBC_TYPE_LONGVARCHAR));
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterIndex, BoundValue.of(x, JdbcType.JDBC_TYPE_CLOB));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.throwIfNotOpen();
        this.setClob(parameterIndex, reader, 4096L);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.throwIfNotOpen();
        ClientSideClob clob = new ClientSideClob(PreparedStatement.toCharArray(reader, (int)length));
        this.bindParameter(parameterIndex, BoundValue.of(clob, JdbcType.JDBC_TYPE_CLOB));
    }

    @Override
    public void setDate(int parameterIndex, Date d) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterIndex, BoundValue.of(d, JdbcType.JDBC_TYPE_DATE));
    }

    @Override
    public void setDate(int parameterIndex, Date d, Calendar cal) throws SQLException {
        this.throwIfNotOpen();
        this.setDate(parameterIndex, Util.convertTime(d, cal, Calendar.getInstance()));
    }

    @Override
    public void setDouble(int parameterIndex, double d) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterIndex, BoundValue.of(d, JdbcType.JDBC_TYPE_DOUBLE));
    }

    @Override
    public void setFloat(int parameterIndex, float f) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterIndex, BoundValue.of(Float.valueOf(f), JdbcType.JDBC_TYPE_REAL));
    }

    @Override
    public void setInt(int parameterIndex, int i) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterIndex, BoundValue.of(i, JdbcType.JDBC_TYPE_INTEGER));
    }

    @Override
    public void setLong(int parameterIndex, long l) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterIndex, BoundValue.of(l, JdbcType.JDBC_TYPE_BIGINT));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.throwIfNotOpen();
        char[] data = PreparedStatement.toCharArray(reader, 4096L);
        this.bindParameter(parameterIndex, BoundValue.of(new String(data), JdbcType.JDBC_TYPE_LONGNVARCHAR));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.throwIfNotOpen();
        char[] data = PreparedStatement.toCharArray(reader, length);
        this.bindParameter(parameterIndex, BoundValue.of(new String(data), JdbcType.JDBC_TYPE_LONGNVARCHAR));
    }

    @Override
    public void setNClob(int parameterIndex, NClob x) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterIndex, BoundValue.of(x, JdbcType.JDBC_TYPE_NCLOB));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.throwIfNotOpen();
        this.setNClob(parameterIndex, reader, 4096L);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.throwIfNotOpen();
        ClientSideNClob clob = new ClientSideNClob(PreparedStatement.toCharArray(reader, (int)length));
        this.bindParameter(parameterIndex, BoundValue.of(clob, JdbcType.JDBC_TYPE_NCLOB));
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterIndex, BoundValue.of(value, JdbcType.JDBC_TYPE_NCHAR));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.throwIfNotOpen();
        this.setNull(parameterIndex, sqlType, null);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterIndex, BoundValue.nullValue(JdbcType.fromCode(sqlType)));
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.throwIfNotOpen();
        if (x == null) {
            this.setNull(parameterIndex, JdbcType.JDBC_TYPE_NULL.getCode());
            return;
        }
        Class<?> clazz = x.getClass();
        if (clazz == String.class) {
            this.setString(parameterIndex, (String)x);
        } else if (clazz == Boolean.class) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (clazz == Byte.class) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (clazz == Short.class) {
            this.setShort(parameterIndex, (Short)x);
        } else if (clazz == Integer.class) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (clazz == Long.class) {
            this.setLong(parameterIndex, (Long)x);
        } else if (clazz == Float.class) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (clazz == Double.class) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (clazz == byte[].class) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Array) {
            this.setArray(parameterIndex, (Array)x);
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
        } else if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
        } else if (x instanceof NClob) {
            this.setNClob(parameterIndex, (NClob)x);
        } else {
            if (x instanceof Struct) {
                throw Exceptions.newNotYetImplementedException();
            }
            if (x instanceof Ref) {
                this.setRef(parameterIndex, (Ref)x);
            } else if (x instanceof URL) {
                this.setURL(parameterIndex, (URL)x);
            } else if (x instanceof RowId) {
                this.setRowId(parameterIndex, (RowId)x);
            } else if (x instanceof RowId) {
                this.setRowId(parameterIndex, (RowId)x);
            } else if (x instanceof SQLXML) {
                this.setSQLXML(parameterIndex, (SQLXML)x);
            } else {
                throw Exceptions.newInvalidParameterException("setObject", x.getClass());
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.throwIfNotOpen();
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.throwIfNotOpen();
        switch (JdbcType.fromCode(targetSqlType)) {
            case JDBC_TYPE_ARRAY: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", Array.class);
                this.setArray(parameterIndex, (Array)x);
                break;
            }
            case JDBC_TYPE_BIGINT: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setLong(parameterIndex, PreparedStatement.boolAsNumber((Boolean)x).longValue());
                    break;
                }
                if (x instanceof Number) {
                    this.setLong(parameterIndex, ((Number)x).longValue());
                    break;
                }
                this.setLong(parameterIndex, Long.valueOf((String)x));
                break;
            }
            case JDBC_TYPE_BINARY: 
            case JDBC_TYPE_LONGVARBINARY: 
            case JDBC_TYPE_VARBINARY: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", String.class, byte[].class);
                Class<?> clazz = x.getClass();
                if (clazz == byte[].class) {
                    this.setBytes(parameterIndex, (byte[])x);
                    break;
                }
                this.setString(parameterIndex, (String)x);
                break;
            }
            case JDBC_TYPE_BIT: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                this.setInt(parameterIndex, PreparedStatement.toBoolean(x) ? 1 : 0);
                break;
            }
            case JDBC_TYPE_BLOB: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", Blob.class);
                this.setBlob(parameterIndex, (Blob)x);
                break;
            }
            case JDBC_TYPE_BOOLEAN: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                this.setBoolean(parameterIndex, PreparedStatement.toBoolean(x));
                break;
            }
            case JDBC_TYPE_CHAR: 
            case JDBC_TYPE_LONGVARCHAR: 
            case JDBC_TYPE_VARCHAR: 
            case JDBC_TYPE_NVARCHAR: 
            case JDBC_TYPE_LONGNVARCHAR: 
            case JDBC_TYPE_NCHAR: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", String.class, Number.class, Boolean.class, Date.class, Time.class, Timestamp.class);
                if (x instanceof Boolean) {
                    this.setString(parameterIndex, (Boolean)x != false ? "1" : "0");
                } else if (x instanceof BigDecimal) {
                    this.setString(parameterIndex, ((BigDecimal)x).toPlainString());
                }
                this.setString(parameterIndex, String.valueOf(x));
                break;
            }
            case JDBC_TYPE_CLOB: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", Clob.class);
                this.setClob(parameterIndex, (Clob)x);
                break;
            }
            case JDBC_TYPE_NCLOB: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", NClob.class);
                this.setNClob(parameterIndex, (NClob)x);
                break;
            }
            case JDBC_TYPE_DATALINK: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", URL.class);
                this.setURL(parameterIndex, (URL)x);
                break;
            }
            case JDBC_TYPE_DATE: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", Date.class, String.class, Timestamp.class);
                if (x instanceof Date) {
                    this.setDate(parameterIndex, (Date)x);
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setTimestamp(parameterIndex, (Timestamp)x);
                    break;
                }
                this.setString(parameterIndex, (String)x);
                break;
            }
            case JDBC_TYPE_DECIMAL: 
            case JDBC_TYPE_NUMERIC: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setBigDecimal(parameterIndex, (Boolean)x != false ? BigDecimal.ONE.setScale(scaleOrLength) : BigDecimal.ZERO.setScale(scaleOrLength));
                    break;
                }
                if (x instanceof Number) {
                    this.setBigDecimal(parameterIndex, Util.createBigDecimalWithScale(this.toBigDecimal((Number)x), scaleOrLength));
                    break;
                }
                this.setBigDecimal(parameterIndex, Util.createBigDecimalWithScale(new BigDecimal((String)x), scaleOrLength));
                break;
            }
            case JDBC_TYPE_DOUBLE: 
            case JDBC_TYPE_FLOAT: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setDouble(parameterIndex, PreparedStatement.boolAsNumber((Boolean)x).doubleValue());
                    break;
                }
                if (x instanceof Number) {
                    this.setDouble(parameterIndex, ((Number)x).doubleValue());
                    break;
                }
                this.setDouble(parameterIndex, Double.valueOf((String)x));
                break;
            }
            case JDBC_TYPE_INTEGER: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setInt(parameterIndex, PreparedStatement.boolAsNumber((Boolean)x).intValue());
                    break;
                }
                if (x instanceof Number) {
                    this.setInt(parameterIndex, ((Number)x).intValue());
                    break;
                }
                this.setInt(parameterIndex, Integer.valueOf((String)x));
                break;
            }
            case JDBC_TYPE_REAL: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setFloat(parameterIndex, PreparedStatement.boolAsNumber((Boolean)x).floatValue());
                    break;
                }
                if (x instanceof Number) {
                    this.setFloat(parameterIndex, ((Number)x).floatValue());
                    break;
                }
                this.setFloat(parameterIndex, Float.valueOf((String)x).floatValue());
                break;
            }
            case JDBC_TYPE_REF: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", Ref.class);
                this.setRef(parameterIndex, (Ref)x);
                break;
            }
            case JDBC_TYPE_ROWID: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", RowId.class);
                this.setRowId(parameterIndex, (RowId)x);
                break;
            }
            case JDBC_TYPE_SMALLINT: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setShort(parameterIndex, PreparedStatement.boolAsNumber((Boolean)x).shortValue());
                    break;
                }
                if (x instanceof Number) {
                    this.setShort(parameterIndex, ((Number)x).shortValue());
                    break;
                }
                this.setShort(parameterIndex, Short.valueOf((String)x));
                break;
            }
            case JDBC_TYPE_TINYINT: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setByte(parameterIndex, PreparedStatement.boolAsNumber((Boolean)x).byteValue());
                    break;
                }
                if (x instanceof Number) {
                    this.setByte(parameterIndex, ((Number)x).byteValue());
                    break;
                }
                this.setByte(parameterIndex, Byte.valueOf((String)x));
                break;
            }
            case JDBC_TYPE_SQLXML: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", SQLXML.class);
                this.setSQLXML(parameterIndex, (SQLXML)x);
                break;
            }
            case JDBC_TYPE_TIME: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", Time.class, String.class, Timestamp.class);
                if (x instanceof Time) {
                    this.setTime(parameterIndex, (Time)x);
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setTime(parameterIndex, new Time(((Timestamp)x).getTime()));
                    break;
                }
                this.setString(parameterIndex, (String)x);
                break;
            }
            case JDBC_TYPE_TIMESTAMP: {
                PreparedStatement.throwIfNotOfClass(x, "setObject", Date.class, String.class, Timestamp.class);
                if (x instanceof Date) {
                    this.setDate(parameterIndex, (Date)x);
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setTimestamp(parameterIndex, (Timestamp)x);
                    break;
                }
                this.setString(parameterIndex, (String)x);
                break;
            }
            case JDBC_TYPE_NULL: {
                this.setNull(parameterIndex, targetSqlType);
                break;
            }
            case JDBC_TYPE_JAVA_OBJECT: 
            case JDBC_TYPE_STRUCT: {
                throw Exceptions.newNotYetImplementedException();
            }
            case JDBC_TYPE_DISTINCT: 
            case JDBC_TYPE_OTHER: {
                throw Exceptions.newNotYetImplementedException();
            }
            default: {
                throw Exceptions.newInvalidParameterException("targetSqlType", targetSqlType);
            }
        }
        this.updateParameterType(parameterIndex, JdbcType.fromCode(targetSqlType));
    }

    protected BigDecimal toBigDecimal(Number x) {
        if (x instanceof BigDecimal) {
            return (BigDecimal)x;
        }
        if (x instanceof BigInteger) {
            return new BigDecimal((BigInteger)x);
        }
        if (x instanceof Byte) {
            return BigDecimal.valueOf(x.longValue());
        }
        if (x instanceof Double) {
            return BigDecimal.valueOf(x.doubleValue());
        }
        if (x instanceof Float) {
            return BigDecimal.valueOf(x.floatValue());
        }
        if (x instanceof Integer) {
            return BigDecimal.valueOf(x.longValue());
        }
        if (x instanceof Long) {
            return BigDecimal.valueOf(x.longValue());
        }
        if (x instanceof Short) {
            return BigDecimal.valueOf(x.longValue());
        }
        return BigDecimal.valueOf(x.doubleValue());
    }

    protected static void throwIfNotOfClass(Object x, String methodName, Class<?> ... classes) throws SQLException {
        Class<?> xClass = x.getClass();
        for (Class<?> clazz : classes) {
            if (!clazz.isAssignableFrom(xClass)) continue;
            return;
        }
        throw Exceptions.newInvalidParameterException(methodName, xClass);
    }

    protected static Number boolAsNumber(Boolean b) {
        return b != false ? 1 : 0;
    }

    protected static boolean toBoolean(Object x) {
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        if (x instanceof Number) {
            Number n = (Number)x;
            return n.byteValue() != 0;
        }
        String s = String.valueOf(x);
        if (s.length() == 1) {
            return s.charAt(0) != '0';
        }
        return Boolean.valueOf(s);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setShort(int parameterIndex, short s) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterIndex, BoundValue.of(s, JdbcType.JDBC_TYPE_SMALLINT));
    }

    @Override
    public void setString(int parameterIndex, String s) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterIndex, BoundValue.of(s, JdbcType.JDBC_TYPE_VARCHAR));
    }

    @Override
    public void setTime(int parameterIndex, Time t) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterIndex, BoundValue.of(t, JdbcType.JDBC_TYPE_TIME));
    }

    @Override
    public void setTime(int parameterIndex, Time t, Calendar cal) throws SQLException {
        this.throwIfNotOpen();
        this.setTime(parameterIndex, Util.convertTime(t, cal, Calendar.getInstance()));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp ts) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterIndex, BoundValue.of(ts, JdbcType.JDBC_TYPE_TIMESTAMP));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp ts, Calendar cal) throws SQLException {
        this.throwIfNotOpen();
        this.setTimestamp(parameterIndex, Util.convertTime(ts, cal, Calendar.getInstance()));
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw Exceptions.newNotSupportedException("setUnicodeStream has been deprecated");
    }

    void bindParameter(int parameterIndex, BoundValue typedValue) throws SQLException {
        this.indexedBindParametersMap.put(parameterIndex, typedValue);
    }

    private void updateParameterType(int parameterIndex, JdbcType dataType) {
        BoundValue old = this.indexedBindParametersMap.get(parameterIndex);
        Util.checkNotNull(old, "Unable to find parameter at index " + parameterIndex);
        this.indexedBindParametersMap.put(parameterIndex, BoundValue.withNewType(old, dataType));
    }

    void bindParameter(String parameterName, BoundValue typedValue) throws SQLException {
        this.namedBindParametersMap.put(parameterName, typedValue);
    }

    Map<Integer, BoundValue> getIndexedBindParametersMap() {
        return this.indexedBindParametersMap;
    }

    Map<String, BoundValue> getNamedBindParametersMap() {
        return this.namedBindParametersMap;
    }

    protected static byte[] toByteArray(InputStream in, long size) throws SQLException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            PreparedStatement.copy(in, out);
        }
        catch (IOException e) {
            throw Exceptions.newSqlException("Error reading InputStream", e);
        }
        return out.toByteArray();
    }

    private static void copy(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[4096];
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
        }
    }

    protected static char[] toCharArray(Reader r, long size) throws SQLException {
        Util.checkParameter(size <= Integer.MAX_VALUE, "size > {0}", Integer.MAX_VALUE);
        CharArrayWriter out = new CharArrayWriter((int)size);
        try {
            PreparedStatement.copy(r, out);
        }
        catch (IOException e) {
            throw Exceptions.newSqlException("Error reading InputStream", e);
        }
        return out.toCharArray();
    }

    private static void copy(Reader from, Writer to) throws IOException {
        int r;
        char[] buf = new char[4096];
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
        }
    }
}

