/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.search.SearchTerm;

public final class FlagTerm
extends SearchTerm {
    protected boolean set;
    protected Flags flags;

    public FlagTerm(Flags flags, boolean set) {
        this.set = set;
        this.flags = flags;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public boolean getTestSet() {
        return this.set;
    }

    @Override
    public boolean match(Message message) {
        try {
            Flags msgFlags = message.getFlags();
            if (this.set) {
                return msgFlags.contains(this.flags);
            }
            Flags.Flag[] system = this.flags.getSystemFlags();
            for (int i = 0; i < system.length; ++i) {
                Flags.Flag flag = system[i];
                if (!msgFlags.contains(flag)) continue;
                return false;
            }
            String[] user = this.flags.getUserFlags();
            for (int i = 0; i < user.length; ++i) {
                String flag = user[i];
                if (!msgFlags.contains(flag)) continue;
                return false;
            }
            return true;
        }
        catch (MessagingException e) {
            return false;
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FlagTerm)) {
            return false;
        }
        FlagTerm otherFlags = (FlagTerm)other;
        return otherFlags.set == this.set && otherFlags.flags.equals(this.flags);
    }

    public int hashCode() {
        return this.set ? this.flags.hashCode() : ~this.flags.hashCode();
    }
}

