/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging;

import java.util.Properties;
import java.util.logging.LogManager;
import org.apache.juli.logging.DirectJDKLog;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogConfigurationException;

public class LogFactory {
    public static final String FACTORY_PROPERTY = "com.google.appengine.repackaged.org.apache.commons.logging.LogFactory";
    public static final String FACTORY_DEFAULT = "com.google.appengine.repackaged.org.apache.commons.logging.impl.LogFactoryImpl";
    public static final String FACTORY_PROPERTIES = "commons-logging.properties";
    public static final String HASHTABLE_IMPLEMENTATION_PROPERTY = "com.google.appengine.repackaged.org.apache.commons.logging.LogFactory.HashtableImpl";
    private static LogFactory singleton = new LogFactory();
    Properties logConfig = new Properties();

    private LogFactory() {
    }

    void setLogConfig(Properties p) {
        this.logConfig = p;
    }

    public Log getInstance(String name) throws LogConfigurationException {
        return DirectJDKLog.getInstance(name);
    }

    public void release() {
        DirectJDKLog.release();
    }

    public Object getAttribute(String name) {
        return this.logConfig.get(name);
    }

    public String[] getAttributeNames() {
        String[] result = new String[this.logConfig.size()];
        return this.logConfig.keySet().toArray(result);
    }

    public void removeAttribute(String name) {
        this.logConfig.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.logConfig.put(name, value);
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public static LogFactory getFactory() throws LogConfigurationException {
        return singleton;
    }

    public static Log getLog(Class clazz) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String name) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(name);
    }

    public static void release(ClassLoader classLoader) {
        LogManager.getLogManager().reset();
    }

    public static void releaseAll() {
        singleton.release();
    }

    public static String objectId(Object o) {
        if (o == null) {
            return "null";
        }
        return o.getClass().getName() + "@" + System.identityHashCode(o);
    }
}

