/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineConfigException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class PagespeedYamlReader {
    private static final String FILENAME = "WEB-INF/pagespeed.yaml";
    private String appDir;

    public PagespeedYamlReader(String appDir) {
        if (appDir.length() > 0 && appDir.charAt(appDir.length() - 1) != File.separatorChar) {
            appDir = appDir + File.separatorChar;
        }
        this.appDir = appDir;
    }

    public String getFilename() {
        return this.appDir + FILENAME;
    }

    public String readPagespeedYaml() {
        if (new File(this.getFilename()).exists()) {
            try {
                return PagespeedYamlReader.readPagespeedYaml(new FileReader(this.getFilename()));
            }
            catch (FileNotFoundException ex) {
                throw new AppEngineConfigException("Cannot find file " + this.getFilename(), ex);
            }
        }
        return null;
    }

    public static String readPagespeedYaml(Reader yaml) {
        BufferedReader reader = new BufferedReader(yaml);
        String out = new String();
        try {
            String currentLine = reader.readLine();
            while (currentLine != null) {
                out = out + currentLine + "\n";
                currentLine = reader.readLine();
            }
        }
        catch (IOException ex) {
            throw new AppEngineConfigException("Cannot read pagespeed.yaml", ex);
        }
        return out;
    }
}

