/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer.asm;

import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.enhancer.ClassMethod;
import org.datanucleus.enhancer.DataNucleusEnhancer;
import org.datanucleus.enhancer.asm.ASMClassEnhancer;
import org.datanucleus.enhancer.asm.ASMUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.util.Localiser;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class JdoPropertySetterAdapter
extends MethodAdapter {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.enhancer.Localisation", (ClassLoader)ClassEnhancer.class.getClassLoader());
    protected ASMClassEnhancer enhancer;
    protected String methodName;
    protected String methodDescriptor;
    protected AbstractMemberMetaData mmd;
    protected MethodVisitor visitor = null;

    public JdoPropertySetterAdapter(MethodVisitor mv, ASMClassEnhancer enhancer, String methodName, String methodDesc, AbstractMemberMetaData mmd, ClassVisitor cv) {
        super(mv);
        this.enhancer = enhancer;
        this.methodName = methodName;
        this.methodDescriptor = methodDesc;
        this.mmd = mmd;
        int access = (mmd.isPublic() ? 1 : 0) | (mmd.isProtected() ? 4 : 0) | (mmd.isPrivate() ? 2 : 0) | (mmd.isAbstract() ? 1024 : 0);
        this.visitor = cv.visitMethod(access, "jdoSet" + mmd.getName(), methodDesc, null, null);
    }

    public void visitEnd() {
        this.visitor.visitEnd();
        if (DataNucleusEnhancer.LOGGER.isDebugEnabled()) {
            String msg = ClassMethod.getMethodAdditionMessage("jdoSet" + this.mmd.getName(), null, new Object[]{this.mmd.getType()}, new String[]{"val"});
            DataNucleusEnhancer.LOGGER.debug((Object)LOCALISER.msg("Enhancer.AddMethod", (Object)msg));
        }
        if (!this.mmd.isAbstract()) {
            JdoPropertySetterAdapter.generateSetXXXMethod(this.mv, this.mmd, this.enhancer.getASMClassName(), this.enhancer.getClassDescriptor());
        }
    }

    public static void generateSetXXXMethod(MethodVisitor mv, AbstractMemberMetaData mmd, String asmClassName, String asmClassDesc) {
        String[] argNames = new String[]{"objPC", "val"};
        String fieldTypeDesc = Type.getDescriptor((Class)mmd.getType());
        mv.visitCode();
        AbstractClassMetaData cmd = mmd.getAbstractClassMetaData();
        if ((mmd.getPersistenceFlags() & 8) == 8) {
            Label startLabel = new Label();
            mv.visitLabel(startLabel);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, asmClassName, "jdoStateManager", "L" + ASMClassEnhancer.ACN_StateManager + ";");
            Label l1 = new Label();
            mv.visitJumpInsn(199, l1);
            mv.visitVarInsn(25, 0);
            ASMUtils.addLoadForType(mv, mmd.getType(), 1);
            mv.visitMethodInsn(182, asmClassName, "jdoSet" + mmd.getName(), "(" + fieldTypeDesc + ")V");
            Label l3 = new Label();
            mv.visitJumpInsn(167, l3);
            mv.visitLabel(l1);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, asmClassName, "jdoStateManager", "L" + ASMClassEnhancer.ACN_StateManager + ";");
            mv.visitVarInsn(25, 0);
            ASMUtils.addBIPUSHToMethod(mv, mmd.getFieldId());
            if (cmd.getPersistenceCapableSuperclass() != null) {
                mv.visitFieldInsn(178, asmClassName, "jdoInheritedFieldCount", "I");
                mv.visitInsn(96);
            }
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, asmClassName, "jdoGet" + mmd.getName(), "()" + fieldTypeDesc);
            ASMUtils.addLoadForType(mv, mmd.getType(), 1);
            String methodName = "set" + ASMUtils.getTypeNameForJDOMethod(mmd.getType()) + "Field";
            String argTypeDesc = fieldTypeDesc;
            if (methodName.equals("setObjectField")) {
                argTypeDesc = ASMUtils.CD_Object;
            }
            mv.visitMethodInsn(185, ASMClassEnhancer.ACN_StateManager, methodName, "(L" + ASMClassEnhancer.ACN_Persistable + ";I" + argTypeDesc + argTypeDesc + ")V");
            mv.visitLabel(l3);
            if (cmd.isDetachable()) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, asmClassName, "jdoIsDetached", "()Z");
                Label l6 = new Label();
                mv.visitJumpInsn(153, l6);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, asmClassName, "jdoDetachedState", "[Ljava/lang/Object;");
                mv.visitInsn(6);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, "java/util/BitSet");
                ASMUtils.addBIPUSHToMethod(mv, mmd.getFieldId());
                if (cmd.getPersistenceCapableSuperclass() != null) {
                    mv.visitFieldInsn(178, asmClassName, "jdoInheritedFieldCount", "I");
                    mv.visitInsn(96);
                }
                mv.visitMethodInsn(182, "java/util/BitSet", "set", "(I)V");
                mv.visitLabel(l6);
            }
            mv.visitInsn(177);
            Label endLabel = new Label();
            mv.visitLabel(endLabel);
            mv.visitLocalVariable(argNames[0], asmClassDesc, null, startLabel, endLabel, 0);
            mv.visitLocalVariable(argNames[1], fieldTypeDesc, null, startLabel, endLabel, 1);
            mv.visitMaxs(5, 2);
        } else if ((mmd.getPersistenceFlags() & 4) == 4) {
            Label startLabel = new Label();
            mv.visitLabel(startLabel);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, asmClassName, "jdoFlags", "B");
            Label l1 = new Label();
            mv.visitJumpInsn(153, l1);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, asmClassName, "jdoStateManager", "L" + ASMClassEnhancer.ACN_StateManager + ";");
            mv.visitJumpInsn(198, l1);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, asmClassName, "jdoStateManager", "L" + ASMClassEnhancer.ACN_StateManager + ";");
            mv.visitVarInsn(25, 0);
            ASMUtils.addBIPUSHToMethod(mv, mmd.getFieldId());
            if (cmd.getPersistenceCapableSuperclass() != null) {
                mv.visitFieldInsn(178, asmClassName, "jdoInheritedFieldCount", "I");
                mv.visitInsn(96);
            }
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, asmClassName, "jdoGet" + mmd.getName(), "()" + fieldTypeDesc);
            ASMUtils.addLoadForType(mv, mmd.getType(), 1);
            String methodName = "set" + ASMUtils.getTypeNameForJDOMethod(mmd.getType()) + "Field";
            String argTypeDesc = fieldTypeDesc;
            if (methodName.equals("setObjectField")) {
                argTypeDesc = ASMUtils.CD_Object;
            }
            mv.visitMethodInsn(185, ASMClassEnhancer.ACN_StateManager, methodName, "(L" + ASMClassEnhancer.ACN_Persistable + ";I" + argTypeDesc + argTypeDesc + ")V");
            Label l3 = new Label();
            mv.visitJumpInsn(167, l3);
            mv.visitLabel(l1);
            mv.visitVarInsn(25, 0);
            ASMUtils.addLoadForType(mv, mmd.getType(), 1);
            mv.visitMethodInsn(182, asmClassName, "jdoSet" + mmd.getName(), "(" + fieldTypeDesc + ")V");
            if (cmd.isDetachable()) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, asmClassName, "jdoIsDetached", "()Z");
                mv.visitJumpInsn(153, l3);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, asmClassName, "jdoDetachedState", "[Ljava/lang/Object;");
                mv.visitInsn(6);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, "java/util/BitSet");
                ASMUtils.addBIPUSHToMethod(mv, mmd.getFieldId());
                if (cmd.getPersistenceCapableSuperclass() != null) {
                    mv.visitFieldInsn(178, asmClassName, "jdoInheritedFieldCount", "I");
                    mv.visitInsn(96);
                }
                mv.visitMethodInsn(182, "java/util/BitSet", "set", "(I)V");
            }
            mv.visitLabel(l3);
            mv.visitInsn(177);
            Label endLabel = new Label();
            mv.visitLabel(endLabel);
            mv.visitLocalVariable(argNames[0], asmClassDesc, null, startLabel, endLabel, 0);
            mv.visitLocalVariable(argNames[1], fieldTypeDesc, null, startLabel, endLabel, 1);
            mv.visitMaxs(5, 2);
        } else {
            Label startLabel = new Label();
            mv.visitLabel(startLabel);
            mv.visitVarInsn(25, 0);
            ASMUtils.addLoadForType(mv, mmd.getType(), 1);
            mv.visitMethodInsn(182, asmClassName, "jdoSet" + mmd.getName(), "(" + fieldTypeDesc + ")V");
            mv.visitInsn(177);
            Label endLabel = new Label();
            mv.visitLabel(endLabel);
            mv.visitLocalVariable(argNames[0], asmClassDesc, null, startLabel, endLabel, 0);
            mv.visitLocalVariable(argNames[1], fieldTypeDesc, null, startLabel, endLabel, 1);
            mv.visitMaxs(2, 2);
        }
        mv.visitEnd();
    }

    public AnnotationVisitor visitAnnotation(String arg0, boolean arg1) {
        return this.mv.visitAnnotation(arg0, arg1);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return this.visitor.visitAnnotationDefault();
    }

    public void visitAttribute(Attribute arg0) {
        this.visitor.visitAttribute(arg0);
    }

    public void visitCode() {
        this.visitor.visitCode();
    }

    public void visitFieldInsn(int arg0, String arg1, String arg2, String arg3) {
        this.visitor.visitFieldInsn(arg0, arg1, arg2, arg3);
    }

    public void visitFrame(int arg0, int arg1, Object[] arg2, int arg3, Object[] arg4) {
        this.visitor.visitFrame(arg0, arg1, arg2, arg3, arg4);
    }

    public void visitIincInsn(int arg0, int arg1) {
        this.visitor.visitIincInsn(arg0, arg1);
    }

    public void visitInsn(int arg0) {
        this.visitor.visitInsn(arg0);
    }

    public void visitIntInsn(int arg0, int arg1) {
        this.visitor.visitIntInsn(arg0, arg1);
    }

    public void visitJumpInsn(int arg0, Label arg1) {
        this.visitor.visitJumpInsn(arg0, arg1);
    }

    public void visitLabel(Label arg0) {
        this.visitor.visitLabel(arg0);
    }

    public void visitLdcInsn(Object arg0) {
        this.visitor.visitLdcInsn(arg0);
    }

    public void visitLineNumber(int arg0, Label arg1) {
        this.visitor.visitLineNumber(arg0, arg1);
    }

    public void visitLocalVariable(String arg0, String arg1, String arg2, Label arg3, Label arg4, int arg5) {
        this.visitor.visitLocalVariable(arg0, arg1, arg2, arg3, arg4, arg5);
    }

    public void visitLookupSwitchInsn(Label arg0, int[] arg1, Label[] arg2) {
        this.visitor.visitLookupSwitchInsn(arg0, arg1, arg2);
    }

    public void visitMaxs(int arg0, int arg1) {
        this.visitor.visitMaxs(arg0, arg1);
    }

    public void visitMethodInsn(int arg0, String arg1, String arg2, String arg3) {
        this.visitor.visitMethodInsn(arg0, arg1, arg2, arg3);
    }

    public void visitMultiANewArrayInsn(String arg0, int arg1) {
        this.visitor.visitMultiANewArrayInsn(arg0, arg1);
    }

    public AnnotationVisitor visitParameterAnnotation(int arg0, String arg1, boolean arg2) {
        return this.visitor.visitParameterAnnotation(arg0, arg1, arg2);
    }

    public void visitTableSwitchInsn(int arg0, int arg1, Label arg2, Label[] arg3) {
        this.visitor.visitTableSwitchInsn(arg0, arg1, arg2, arg3);
    }

    public void visitTryCatchBlock(Label arg0, Label arg1, Label arg2, String arg3) {
        this.visitor.visitTryCatchBlock(arg0, arg1, arg2, arg3);
    }

    public void visitTypeInsn(int arg0, String arg1) {
        this.visitor.visitTypeInsn(arg0, arg1);
    }

    public void visitVarInsn(int arg0, int arg1) {
        this.visitor.visitVarInsn(arg0, arg1);
    }
}

