/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.servlet;

import com.google.appengine.api.backends.dev.LocalServerController;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServersServlet
extends HttpServlet {
    private static final String AH_ADMIN_BACKENDS_PATH = "/_ah/admin/backends";
    private static final Logger logger = Logger.getLogger(ServersServlet.class.getName());
    private static final String APPLICATION_NAME = "applicationName";
    private static final String BACKEND_NAME = "backendName";
    private static final String BACKEND_STATE_INFO = "backendStateInfo";
    private static final String INSTANCE_STATE_INFO = "instanceStateInfo";
    private static final String ACTION_STOP_BACKEND = "action:stopbackend";
    private static final String ACTION_START_BACKEND = "action:startbackend";

    private LocalServerController getServerController() {
        Object backendController = ApiProxy.getCurrentEnvironment().getAttributes().get("com.google.appengine.dev.backend_controller");
        return backendController != null ? (LocalServerController)backendController : null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        req.setAttribute(APPLICATION_NAME, (Object)ApiProxy.getCurrentEnvironment().getAppId());
        LocalServerController serverController = this.getServerController();
        if (serverController != null) {
            TreeMap backendStateInfo = serverController.getBackendState(req.getServerName());
            req.setAttribute(BACKEND_STATE_INFO, (Object)backendStateInfo);
            String selectedBackendName = req.getParameter(BACKEND_NAME);
            if (selectedBackendName != null && backendStateInfo != null) {
                logger.finest("adding information for backend " + selectedBackendName);
                req.setAttribute(BACKEND_NAME, (Object)selectedBackendName);
                req.setAttribute(INSTANCE_STATE_INFO, (Object)((LocalServerController.BackendStateInfo)backendStateInfo.get(selectedBackendName)).getInstanceStates());
            }
        }
        try {
            this.getServletContext().getRequestDispatcher("/_ah/adminConsole?subsection=backends").forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (ServletException e) {
            throw new RuntimeException("Could not forward request", e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        final LocalServerController backendController = this.getServerController();
        final String selectedBackendName = req.getParameter(BACKEND_NAME);
        if (req.getParameter(ACTION_STOP_BACKEND) != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        backendController.stopBackend(selectedBackendName);
                    }
                    catch (Exception e) {
                        logger.severe("Got error when stopping backend: " + selectedBackendName);
                    }
                    return null;
                }
            });
            resp.sendRedirect(AH_ADMIN_BACKENDS_PATH);
        } else if (req.getParameter(ACTION_START_BACKEND) != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        backendController.startBackend(selectedBackendName);
                    }
                    catch (Exception e) {
                        logger.severe("Got error when starting backend: " + selectedBackendName);
                    }
                    return null;
                }
            });
            resp.sendRedirect(AH_ADMIN_BACKENDS_PATH);
        } else {
            resp.sendError(404);
        }
    }
}

