/**********************************************************************
Copyright (c) 2002 Kelly Grizzle (TJDO) and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
2002 Mike Martin (TJDO)
2003 Andy Jefferson - coding standards
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;

import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

/**
 * Representation of a BooleanBit column literal in a Query.
 *
 * @version $Revision: 1.6 $
 **/
public class BooleanBitColumnLiteral extends BooleanLiteral
{
    /**
     * Constructor.
     * @param qs the QueryExpression
     * @param mapping the mapping associated to this expression
     * @param value the literal value
     */
    public BooleanBitColumnLiteral(QueryExpression qs, JavaTypeMapping mapping, boolean value)
    {
        super(qs, mapping, value);
    }

    /**
     * Return the String value for TRUE in the database.  This should be
     * overriden by subclasses for special cases of booleans.
     * 
     * @return  The String value for TRUE in the database.
     */
    protected String getBooleanTrueValue()
    {
        return Integer.toString(1);
    }

    /**
     * Return the String value for FALSE in the database.  This should be
     * overriden by subclasses for special cases of booleans.
     * 
     * @return  The String value for FALSE in the database.
     */
    protected String getBooleanFalseValue()
    {
        return Integer.toString(0);
    }
}
