/**********************************************************************
Copyright (c) 2002 Mike Martin (TJDO) and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
2003 Andy Jefferson - coding standards
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;

import java.sql.Timestamp;

import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

/**
 * Representation of an SQLTimestamp literal in a Query.
 *
 * @version $Revision: 1.5 $
 **/
public class SqlTimestampLiteral extends SqlTemporalExpression implements Literal
{
    private final Timestamp value;

    /** Raw value that this literal represents. */
    Object rawValue;

    /**
     * Creates a java.sql.Timestamp literal
     * @param qs the QueryExpression
     * @param mapping the mapping
     * @param value the java.sql.Timestamp value
     */ 
    public SqlTimestampLiteral(QueryExpression qs, JavaTypeMapping mapping, Timestamp value)
    {
        super(qs);
        this.mapping = mapping;
        this.value = value;
        st.appendParameter(mapping, value);
    }

    public String toString()
    {
        return super.toString() + " = " + value.toString();
    }

    public Object getValue()
    {
        return value;
    }

    /**
     * Method to save a "raw" value that this literal represents.
     * This value differs from the literal value since that is of the same type as this literal.
     * @param val The raw value
     */
    public void setRawValue(Object val)
    {
        this.rawValue = val;
    }

    /**
     * Accessor for the "raw" value that this literal represents.
     * This value differs from the literal value since that is of the same type as this literal.
     * @return The raw value
     */
    public Object getRawValue()
    {
        return rawValue;
    }
}
