/**********************************************************************
Copyright (c) 2005 Erik Bengtson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;

/**
 * Interface that allows performing algebra operations over sets
 * @version $Revision: 1.1 $
 */
public interface ExpressionLogicSetAdapter
{
    /**
     * Generates a expression that represents the cartesian product of two sets: <code>X</code> and <code>Y</code>.
     * Actually, <code>X</code> is not generated to the expression.
     * @param Y right hand set
     * @return the cartesion product expression. if the cartesian product expression is "X x Y", the returned expression
     * is " x Y". Note that the left hand set was not introduced to the expression
     **/
    String cartersianProduct(LogicSetExpression Y);
}

