/**********************************************************************
Copyright (c) 2003 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.mapped.mapping;

import java.sql.Time;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.SqlTemporalExpression;
import org.datanucleus.store.mapped.expression.SqlTimeLiteral;

/**
 * SCO Mapping for an SQLTime type.
 */
public class SqlTimeMapping extends SingleFieldMapping
{
    private static java.sql.Time mappingSampleValue = new java.sql.Time(new java.util.Date().getTime());

    public Object getSampleValue(ClassLoaderResolver clr)
    {
        return mappingSampleValue;
    }

    public Class getJavaType()
    {
        return java.sql.Time.class;
    }

    /**
     * Method to return the default length of this type in the datastore.
     * java.sql.Time requires 8 characters ("hh:mm:ss")
     * @param index The index position
     * @return The default length
     */
    public int getDefaultLength(int index)
    {
        return 8;
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value)
    {
        return new SqlTimeLiteral(qs, this, (Time)value);
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te)
    {
        return new SqlTemporalExpression(qs, this, te);
    }
}