/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.compiler;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Stack;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.compiler.Lexer;
import org.datanucleus.query.compiler.Parser;
import org.datanucleus.query.node.Node;
import org.datanucleus.query.node.NodeType;
import org.datanucleus.query.node.ParameterNode;
import org.datanucleus.store.query.QueryCompilerSyntaxException;
import org.datanucleus.store.query.QueryInvalidParametersException;

public class JPQLParser
implements Parser {
    private Lexer p;
    private Stack<Node> stack = new Stack();
    private static String paramPrefixes = ":?";
    private ParameterType paramType = null;
    private Map parameterValues;
    int parameterPosition = 0;

    public JPQLParser(Map options, Map params) {
        this.parameterValues = params;
    }

    public Node parse(String expression) {
        this.p = new Lexer(expression, paramPrefixes, false);
        this.stack = new Stack();
        Node result = this.processExpression();
        if (this.p.ci.getIndex() != this.p.ci.getEndIndex()) {
            String unparsed = this.p.getInput().substring(this.p.ci.getIndex());
            throw new QueryCompilerSyntaxException("Portion of expression could not be parsed: " + unparsed);
        }
        return result;
    }

    public Node parseVariable(String expression) {
        this.p = new Lexer(expression, paramPrefixes, false);
        this.stack = new Stack();
        if (!this.processIdentifier()) {
            throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
        }
        if (!this.processIdentifier()) {
            throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
        }
        Node nodeVariable = this.stack.pop();
        Node nodeType = this.stack.pop();
        nodeType.appendChildNode(nodeVariable);
        return nodeType;
    }

    public Node[] parseFrom(String expression) {
        this.p = new Lexer(expression, paramPrefixes, false);
        this.stack = new Stack();
        return this.processFromExpression();
    }

    public Node[] parseUpdate(String expression) {
        this.p = new Lexer(expression, paramPrefixes, false);
        this.stack = new Stack();
        return this.parseTupple(expression);
    }

    public Node[] parseOrder(String expression) {
        this.p = new Lexer(expression, paramPrefixes, false);
        this.stack = new Stack();
        return this.processOrderExpression();
    }

    public Node[] parseResult(String expression) {
        this.p = new Lexer(expression, paramPrefixes, false);
        this.stack = new Stack();
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            this.processExpression();
            Node node = this.stack.pop();
            String alias = this.p.parseIdentifier();
            if (alias != null && alias.equalsIgnoreCase("AS")) {
                alias = this.p.parseIdentifier();
            }
            if (alias != null) {
                Node aliasNode = new Node(NodeType.NAME, alias.toLowerCase());
                node.appendChildNode(aliasNode);
            }
            nodes.add(node);
        } while (this.p.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    public Node[] parseTupple(String expression) {
        this.p = new Lexer(expression, paramPrefixes, false);
        this.stack = new Stack();
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            this.processExpression();
            Node node = this.stack.pop();
            nodes.add(node);
        } while (this.p.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    public Node[][] parseVariables(String expression) {
        this.p = new Lexer(expression, paramPrefixes, false);
        ArrayList<Node[]> nodes = new ArrayList<Node[]>();
        do {
            this.processPrimary();
            if (this.stack.isEmpty()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
            }
            if (!this.processIdentifier()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
            }
            Node nodeVariable = this.stack.pop();
            Node nodeType = this.stack.pop();
            nodes.add(new Node[]{nodeType, nodeVariable});
        } while (this.p.parseString(";"));
        return (Node[][])nodes.toArray((T[])new Node[nodes.size()][2]);
    }

    public Node[][] parseParameters(String expression) {
        this.p = new Lexer(expression, paramPrefixes, false);
        ArrayList<Node[]> nodes = new ArrayList<Node[]>();
        do {
            this.processPrimary();
            if (this.stack.isEmpty()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
            }
            if (!this.processIdentifier()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
            }
            Node nodeVariable = this.stack.pop();
            Node nodeType = this.stack.pop();
            nodes.add(new Node[]{nodeType, nodeVariable});
        } while (this.p.parseString(","));
        return (Node[][])nodes.toArray((T[])new Node[nodes.size()][2]);
    }

    private Node[] processFromExpression() {
        String candidateClassName = null;
        String candidateAlias = null;
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            if (this.p.peekStringIgnoreCase("IN(") || this.p.peekStringIgnoreCase("IN ")) {
                Node joinedNode;
                this.p.parseStringIgnoreCase("IN");
                if (!this.p.parseChar('(')) {
                    throw new QueryCompilerSyntaxException("Expected: '(' but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
                }
                String name = this.p.parseIdentifier();
                Node parentNode = joinedNode = new Node(NodeType.IDENTIFIER, name);
                while (this.p.nextIsDot()) {
                    this.p.parseChar('.');
                    String subName = this.p.parseIdentifier();
                    Node subNode = new Node(NodeType.IDENTIFIER, subName);
                    parentNode.appendChildNode(subNode);
                    parentNode = subNode;
                }
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("Expected: ')' but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
                }
                this.p.parseStringIgnoreCase("AS");
                String alias = this.p.parseIdentifier();
                Node classNode = new Node(NodeType.CLASS, candidateClassName);
                Node classAliasNode = new Node(NodeType.NAME, candidateAlias);
                classNode.insertChildNode(classAliasNode);
                this.stack.push(classNode);
                Node joinNode = new Node(NodeType.OPERATOR, "JOIN_INNER");
                joinNode.appendChildNode(joinedNode);
                Node joinAliasNode = new Node(NodeType.NAME, alias);
                joinNode.appendChildNode(joinAliasNode);
                classNode.appendChildNode(joinNode);
                this.processFromJoinExpression();
                nodes.add(classNode);
                continue;
            }
            this.processExpression();
            Node id = this.stack.pop();
            StringBuilder className = new StringBuilder(id.getNodeValue().toString());
            while (id.getChildNodes().size() > 0) {
                id = id.getFirstChild();
                className.append(".").append(id.getNodeValue().toString());
            }
            String alias = this.p.parseIdentifier();
            if (alias != null && alias.equalsIgnoreCase("AS")) {
                alias = this.p.parseIdentifier();
            }
            if (candidateClassName == null) {
                candidateClassName = className.toString();
                candidateAlias = alias;
            }
            Node classNode = new Node(NodeType.CLASS, className.toString());
            Node aliasNode = new Node(NodeType.NAME, alias);
            classNode.insertChildNode(aliasNode);
            this.stack.push(classNode);
            this.processFromJoinExpression();
            nodes.add(classNode);
        } while (this.p.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    private void processFromJoinExpression() {
        Node candidateNode = this.stack.pop();
        boolean moreJoins = true;
        while (moreJoins) {
            boolean leftJoin = false;
            boolean innerJoin = false;
            if (this.p.parseStringIgnoreCase("INNER ")) {
                innerJoin = true;
            } else if (this.p.parseStringIgnoreCase("LEFT ")) {
                this.p.parseStringIgnoreCase("OUTER");
                leftJoin = true;
            }
            if (this.p.parseStringIgnoreCase("JOIN ")) {
                Node joinedNode;
                if (!innerJoin && !leftJoin) {
                    innerJoin = true;
                }
                boolean fetch = false;
                if (this.p.parseStringIgnoreCase("FETCH")) {
                    fetch = true;
                }
                String id = this.p.parseIdentifier();
                Node parentNode = joinedNode = new Node(NodeType.IDENTIFIER, id);
                while (this.p.nextIsDot()) {
                    this.p.parseChar('.');
                    Node subNode = new Node(NodeType.IDENTIFIER, this.p.parseName());
                    parentNode.appendChildNode(subNode);
                    parentNode = subNode;
                }
                this.p.parseStringIgnoreCase("AS ");
                String alias = this.p.parseName();
                String joinType = "JOIN_INNER";
                if (innerJoin) {
                    joinType = fetch ? "JOIN_INNER_FETCH" : "JOIN_INNER";
                } else if (leftJoin) {
                    joinType = fetch ? "JOIN_OUTER_FETCH" : "JOIN_OUTER";
                }
                Node joinNode = new Node(NodeType.OPERATOR, joinType);
                joinNode.appendChildNode(joinedNode);
                Node joinedAliasNode = new Node(NodeType.NAME, alias);
                joinNode.appendChildNode(joinedAliasNode);
                candidateNode.appendChildNode(joinNode);
                continue;
            }
            if (innerJoin || leftJoin) {
                throw new NucleusUserException("Expected JOIN after INNER/LEFT keyword at" + this.p.remaining());
            }
            moreJoins = false;
        }
        this.stack.push(candidateNode);
    }

    private Node[] processOrderExpression() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            Node expr;
            this.processExpression();
            if (this.p.parseStringIgnoreCase("asc")) {
                expr = new Node(NodeType.OPERATOR, "ascending");
                this.stack.push(expr);
            } else if (this.p.parseStringIgnoreCase("desc")) {
                expr = new Node(NodeType.OPERATOR, "descending");
                this.stack.push(expr);
            } else {
                expr = new Node(NodeType.OPERATOR, "ascending");
                this.stack.push(expr);
            }
            expr = new Node(NodeType.OPERATOR, "order");
            expr.insertChildNode(this.stack.pop());
            if (!this.stack.empty()) {
                expr.insertChildNode(this.stack.pop());
            }
            nodes.add(expr);
        } while (this.p.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    private Node processExpression() {
        this.processOrExpression();
        return this.stack.peek();
    }

    private void processOrExpression() {
        this.processAndExpression();
        while (this.p.parseStringIgnoreCase("OR ")) {
            this.processAndExpression();
            Node expr = new Node(NodeType.OPERATOR, "||");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processAndExpression() {
        this.processRelationalExpression();
        while (this.p.parseStringIgnoreCase("AND ")) {
            this.processRelationalExpression();
            Node expr = new Node(NodeType.OPERATOR, "&&");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processRelationalExpression() {
        this.processAdditiveExpression();
        while (true) {
            Node expr;
            Node betweenNode;
            Node rightNode;
            Node leftNode;
            Node lowerNode;
            Node inputNode;
            Node expr2;
            Node left;
            Node right;
            if (this.p.parseString("=")) {
                Node primNode;
                this.processAdditiveExpression();
                right = this.stack.pop();
                left = this.stack.pop();
                if (right.getNodeType() == NodeType.TYPE) {
                    primNode = right.getFirstChild();
                    expr2 = new Node(NodeType.OPERATOR, "instanceof");
                    expr2.appendChildNode(primNode);
                    expr2.appendChildNode(left);
                    this.stack.push(expr2);
                    continue;
                }
                if (left.getNodeType() == NodeType.TYPE) {
                    primNode = left.getFirstChild();
                    expr2 = new Node(NodeType.OPERATOR, "instanceof");
                    expr2.appendChildNode(primNode);
                    expr2.appendChildNode(right);
                    this.stack.push(expr2);
                    continue;
                }
                Node expr3 = new Node(NodeType.OPERATOR, "==");
                expr3.insertChildNode(right);
                expr3.insertChildNode(left);
                this.stack.push(expr3);
                continue;
            }
            if (this.p.parseString("<>")) {
                Node notNode;
                Node primNode;
                this.processAdditiveExpression();
                right = this.stack.pop();
                left = this.stack.pop();
                if (right.getNodeType() == NodeType.TYPE) {
                    primNode = right.getFirstChild();
                    expr2 = new Node(NodeType.OPERATOR, "instanceof");
                    expr2.appendChildNode(primNode);
                    expr2.appendChildNode(left);
                    notNode = new Node(NodeType.OPERATOR, "!");
                    notNode.appendChildNode(expr2);
                    this.stack.push(notNode);
                    continue;
                }
                if (left.getNodeType() == NodeType.TYPE) {
                    primNode = left.getFirstChild();
                    expr2 = new Node(NodeType.OPERATOR, "instanceof");
                    expr2.appendChildNode(primNode);
                    expr2.appendChildNode(right);
                    notNode = new Node(NodeType.OPERATOR, "!");
                    notNode.appendChildNode(expr2);
                    this.stack.push(notNode);
                    continue;
                }
                Node expr4 = new Node(NodeType.OPERATOR, "!=");
                expr4.insertChildNode(right);
                expr4.insertChildNode(left);
                this.stack.push(expr4);
                continue;
            }
            if (this.p.parseStringIgnoreCase("NOT ")) {
                if (this.p.parseStringIgnoreCase("BETWEEN ")) {
                    inputNode = this.stack.pop();
                    this.processAdditiveExpression();
                    lowerNode = this.stack.pop();
                    if (this.p.parseStringIgnoreCase("AND ")) {
                        this.processAdditiveExpression();
                        Node upperNode = this.stack.pop();
                        leftNode = new Node(NodeType.OPERATOR, "<");
                        leftNode.appendChildNode(inputNode);
                        leftNode.appendChildNode(lowerNode);
                        rightNode = new Node(NodeType.OPERATOR, ">");
                        rightNode.appendChildNode(inputNode);
                        rightNode.appendChildNode(upperNode);
                        betweenNode = new Node(NodeType.OPERATOR, "||");
                        betweenNode.appendChildNode(leftNode);
                        betweenNode.appendChildNode(rightNode);
                        this.stack.push(betweenNode);
                        continue;
                    }
                    throw new NucleusUserException("Query has BETWEEN keyword with no AND clause");
                }
                if (this.p.parseStringIgnoreCase("LIKE ")) {
                    this.processLikeExpression();
                    Node notNode = new Node(NodeType.OPERATOR, "!");
                    notNode.insertChildNode(this.stack.pop());
                    this.stack.push(notNode);
                    continue;
                }
                if (this.p.parseStringIgnoreCase("IN")) {
                    this.processInExpression(true);
                    continue;
                }
                if (this.p.parseStringIgnoreCase("MEMBER ")) {
                    this.processMemberExpression(true);
                    continue;
                }
                throw new NucleusException("Unsupported query syntax NOT followed by unsupported keyword");
            }
            if (this.p.parseStringIgnoreCase("BETWEEN ")) {
                inputNode = this.stack.pop();
                this.processAdditiveExpression();
                lowerNode = this.stack.pop();
                if (this.p.parseStringIgnoreCase("AND ")) {
                    this.processAdditiveExpression();
                    Node upperNode = this.stack.pop();
                    leftNode = new Node(NodeType.OPERATOR, ">=");
                    leftNode.appendChildNode(inputNode);
                    leftNode.appendChildNode(lowerNode);
                    rightNode = new Node(NodeType.OPERATOR, "<=");
                    rightNode.appendChildNode(inputNode);
                    rightNode.appendChildNode(upperNode);
                    betweenNode = new Node(NodeType.OPERATOR, "&&");
                    betweenNode.appendChildNode(rightNode);
                    betweenNode.appendChildNode(leftNode);
                    this.stack.push(betweenNode);
                    continue;
                }
                throw new NucleusUserException("Query has BETWEEN keyword with no AND clause");
            }
            if (this.p.parseStringIgnoreCase("LIKE ")) {
                this.processLikeExpression();
                continue;
            }
            if (this.p.parseStringIgnoreCase("IN")) {
                this.processInExpression(false);
                continue;
            }
            if (this.p.parseStringIgnoreCase("MEMBER ")) {
                this.processMemberExpression(false);
                continue;
            }
            if (this.p.parseStringIgnoreCase("IS ")) {
                Node inputRootNode = inputNode = this.stack.pop();
                if (inputNode.getNodeType() == NodeType.IDENTIFIER) {
                    while (inputNode.getFirstChild() != null) {
                        inputNode = inputNode.getFirstChild();
                    }
                }
                boolean not = false;
                if (this.p.parseStringIgnoreCase("NOT ")) {
                    not = true;
                }
                if (this.p.parseStringIgnoreCase("NULL")) {
                    Node isNode = new Node(NodeType.OPERATOR, not ? "!=" : "==");
                    Node compareNode = new Node(NodeType.LITERAL, null);
                    isNode.insertChildNode(compareNode);
                    isNode.insertChildNode(inputRootNode);
                    this.stack.push(isNode);
                    continue;
                }
                if (this.p.parseStringIgnoreCase("EMPTY")) {
                    Node sizeNode = new Node(NodeType.INVOKE, "size");
                    inputNode.insertChildNode(sizeNode);
                    Node isEmptyNode = new Node(NodeType.OPERATOR, not ? "!=" : "==");
                    isEmptyNode.appendChildNode(inputNode);
                    Node zeroNode = new Node(NodeType.LITERAL, 0);
                    isEmptyNode.appendChildNode(zeroNode);
                    this.stack.push(isEmptyNode);
                    continue;
                }
                throw new NucleusException("Encountered IS " + (not ? "NOT " : " ") + " that should be followed by NULL | EMPTY but isnt");
            }
            if (this.p.parseString("<=")) {
                this.processAdditiveExpression();
                expr = new Node(NodeType.OPERATOR, "<=");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseString(">=")) {
                this.processAdditiveExpression();
                expr = new Node(NodeType.OPERATOR, ">=");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseChar('<')) {
                this.processAdditiveExpression();
                expr = new Node(NodeType.OPERATOR, "<");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseChar('>')) break;
            this.processAdditiveExpression();
            expr = new Node(NodeType.OPERATOR, ">");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processLikeExpression() {
        Node primaryNode;
        Node primaryRootNode = primaryNode = this.stack.pop();
        if (primaryNode.getNodeType() == NodeType.IDENTIFIER) {
            while (primaryNode.getFirstChild() != null) {
                primaryNode = primaryNode.getFirstChild();
            }
        }
        this.processAdditiveExpression();
        Node likeExprNode = this.stack.pop();
        if (this.p.parseStringIgnoreCase("ESCAPE")) {
            this.processAdditiveExpression();
            Node escapeNode = this.stack.pop();
            Node matchesNode = new Node(NodeType.INVOKE, "matches");
            matchesNode.addProperty(likeExprNode);
            matchesNode.addProperty(escapeNode);
            primaryNode.appendChildNode(matchesNode);
            this.stack.push(primaryRootNode);
        } else {
            Node matchesNode = new Node(NodeType.INVOKE, "matches");
            matchesNode.addProperty(likeExprNode);
            primaryNode.appendChildNode(matchesNode);
            this.stack.push(primaryRootNode);
        }
    }

    private void processInExpression(boolean not) {
        Node inputNode = this.stack.pop();
        if (!this.p.parseChar('(')) {
            Node inNode = new Node(NodeType.OPERATOR, not ? "NOT IN" : "IN");
            inNode.appendChildNode(inputNode);
            this.processExpression();
            Node subqueryNode = this.stack.pop();
            inNode.appendChildNode(subqueryNode);
            this.stack.push(inNode);
            return;
        }
        Node inNode = null;
        int numArgs = 0;
        do {
            Object paramValue;
            this.processPrimary();
            if (this.stack.peek() == null) {
                throw new QueryCompilerSyntaxException("Expected literal|parameter but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
            }
            Node valueNode = this.stack.pop();
            this.p.skipWS();
            if (++numArgs == 1 && !this.p.peekStringIgnoreCase(",") && valueNode.getNodeType() == NodeType.PARAMETER && this.parameterValues != null && this.parameterValues.containsKey(valueNode.getNodeValue()) && (paramValue = this.parameterValues.get(valueNode.getNodeValue())) instanceof Collection) {
                Node containsNode = new Node(NodeType.INVOKE, "contains");
                containsNode.addProperty(inputNode);
                valueNode.appendChildNode(containsNode);
                inNode = valueNode;
                break;
            }
            Node compareNode = new Node(NodeType.OPERATOR, not ? "!=" : "==");
            compareNode.appendChildNode(inputNode);
            compareNode.appendChildNode(valueNode);
            if (inNode == null) {
                inNode = compareNode;
                continue;
            }
            Node newInNode = new Node(NodeType.OPERATOR, not ? "&&" : "||");
            newInNode.appendChildNode(inNode);
            newInNode.appendChildNode(compareNode);
            inNode = newInNode;
        } while (this.p.parseChar(','));
        if (!this.p.parseChar(')')) {
            throw new QueryCompilerSyntaxException("Expected: ')' but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
        }
        this.stack.push(inNode);
    }

    private void processMemberExpression(boolean not) {
        Node inputNode = this.stack.pop();
        this.p.parseStringIgnoreCase("OF");
        this.processPrimary();
        Node containerNode = this.stack.peek();
        while (containerNode.getFirstChild() != null) {
            containerNode = containerNode.getFirstChild();
        }
        if (not) {
            Node notNode = new Node(NodeType.OPERATOR, "!");
            this.stack.pop();
            notNode.insertChildNode(containerNode);
            this.stack.push(notNode);
        }
        Node containsNode = new Node(NodeType.INVOKE, "contains");
        containsNode.addProperty(inputNode);
        containerNode.appendChildNode(containsNode);
    }

    private void processCaseExpression() {
        Node caseNode = new Node(NodeType.CASE);
        while (this.p.parseStringIgnoreCase("WHEN ")) {
            this.processExpression();
            Node whenNode = this.stack.pop();
            caseNode.appendChildNode(whenNode);
            boolean hasThen = this.p.parseStringIgnoreCase("THEN ");
            if (!hasThen) {
                throw new QueryCompilerSyntaxException("expected 'THEN' as part of CASE", this.p.getIndex(), this.p.getInput());
            }
            this.processExpression();
            Node actionNode = this.stack.pop();
            caseNode.appendChildNode(actionNode);
        }
        if (this.p.parseStringIgnoreCase("ELSE ")) {
            this.processExpression();
            Node elseNode = this.stack.pop();
            caseNode.appendChildNode(elseNode);
        }
        if (!this.p.parseStringIgnoreCase("END")) {
            throw new QueryCompilerSyntaxException("expected 'END' as part of CASE", this.p.getIndex(), this.p.getInput());
        }
        this.stack.push(caseNode);
    }

    protected void processAdditiveExpression() {
        this.processMultiplicativeExpression();
        while (true) {
            Node expr;
            if (this.p.parseChar('+')) {
                this.processMultiplicativeExpression();
                expr = new Node(NodeType.OPERATOR, "+");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseChar('-')) break;
            this.processMultiplicativeExpression();
            expr = new Node(NodeType.OPERATOR, "-");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void processMultiplicativeExpression() {
        this.processUnaryExpression();
        while (true) {
            Node expr;
            if (this.p.parseChar('*')) {
                this.processUnaryExpression();
                expr = new Node(NodeType.OPERATOR, "*");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseChar('/')) {
                this.processUnaryExpression();
                expr = new Node(NodeType.OPERATOR, "/");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseChar('%')) break;
            this.processUnaryExpression();
            expr = new Node(NodeType.OPERATOR, "%");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void processUnaryExpression() {
        if (this.p.parseString("++")) {
            throw new NucleusUserException("Unsupported operator '++'");
        }
        if (this.p.parseString("--")) {
            throw new NucleusUserException("Unsupported operator '--'");
        }
        if (this.p.parseChar('+')) {
            this.processUnaryExpression();
        } else if (this.p.parseChar('-')) {
            this.processUnaryExpression();
            Node expr = new Node(NodeType.OPERATOR, "-");
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        } else if (this.p.parseStringIgnoreCase("NOT ")) {
            this.processRelationalExpression();
            Node expr = new Node(NodeType.OPERATOR, "!");
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        } else {
            this.processPrimary();
        }
    }

    protected void processPrimary() {
        String subqueryKeyword = null;
        Node subqueryNode = null;
        if (this.p.parseStringIgnoreCase("SOME ")) {
            subqueryKeyword = "SOME";
            this.processExpression();
            subqueryNode = this.stack.pop();
        } else if (this.p.parseStringIgnoreCase("ALL ")) {
            subqueryKeyword = "ALL";
            this.processExpression();
            subqueryNode = this.stack.pop();
        } else if (this.p.parseStringIgnoreCase("ANY ")) {
            subqueryKeyword = "ANY";
            this.processExpression();
            subqueryNode = this.stack.pop();
        } else if (this.p.parseStringIgnoreCase("EXISTS ")) {
            subqueryKeyword = "EXISTS";
            this.processExpression();
            subqueryNode = this.stack.pop();
        }
        if (subqueryKeyword != null && subqueryNode != null) {
            Node subNode = new Node(NodeType.SUBQUERY, subqueryKeyword);
            subNode.appendChildNode(subqueryNode);
            this.stack.push(subNode);
            return;
        }
        if (this.p.parseStringIgnoreCase("CURRENT_DATE")) {
            Node node = new Node(NodeType.INVOKE, "CURRENT_DATE");
            this.stack.push(node);
            return;
        }
        if (this.p.parseStringIgnoreCase("CURRENT_TIMESTAMP")) {
            Node node = new Node(NodeType.INVOKE, "CURRENT_TIMESTAMP");
            this.stack.push(node);
            return;
        }
        if (this.p.parseStringIgnoreCase("CURRENT_TIME")) {
            Node node = new Node(NodeType.INVOKE, "CURRENT_TIME");
            this.stack.push(node);
            return;
        }
        if (this.p.parseStringIgnoreCase("CASE ")) {
            this.processCaseExpression();
            return;
        }
        if (this.p.parseStringIgnoreCase("DISTINCT ")) {
            Node distinctNode = new Node(NodeType.OPERATOR, "DISTINCT");
            this.processExpression();
            Node identifierNode = this.stack.pop();
            distinctNode.appendChildNode(identifierNode);
            this.stack.push(distinctNode);
            return;
        }
        if (this.processCreator() || this.processLiteral() || this.processMethod()) {
            return;
        }
        if (this.p.parseChar('(')) {
            this.processExpression();
            if (!this.p.parseChar(')')) {
                throw new QueryCompilerSyntaxException("expected ')'", this.p.getIndex(), this.p.getInput());
            }
            return;
        }
        if (!this.processIdentifier()) {
            throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
        }
        int size = this.stack.size();
        while (this.p.parseChar('.')) {
            if (this.processMethod() || this.processIdentifier()) continue;
            throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
        }
        while (this.stack.size() > size) {
            Node top = this.stack.pop();
            Node peek = this.stack.peek();
            peek.insertChildNode(top);
        }
    }

    private boolean processCreator() {
        if (this.p.parseStringIgnoreCase("NEW ")) {
            int size = this.stack.size();
            if (!this.processMethod()) {
                if (!this.processIdentifier()) {
                    throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
                }
                while (this.p.parseChar('.')) {
                    if (this.processMethod() || this.processIdentifier()) continue;
                    throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
                }
            }
            while (this.stack.size() - 1 > size) {
                Node top = this.stack.pop();
                Node peek = this.stack.peek();
                peek.insertChildNode(top);
            }
            Node node = this.stack.pop();
            Node newNode = new Node(NodeType.CREATOR);
            newNode.insertChildNode(node);
            this.stack.push(newNode);
            return true;
        }
        return false;
    }

    private boolean processMethod() {
        String method = this.p.parseMethod();
        if (method != null) {
            this.p.skipWS();
            this.p.parseChar('(');
            if (method.equalsIgnoreCase("COUNT")) {
                method = "COUNT";
            } else if (method.equalsIgnoreCase("AVG")) {
                method = "AVG";
            } else if (method.equalsIgnoreCase("MIN")) {
                method = "MIN";
            } else if (method.equalsIgnoreCase("MAX")) {
                method = "MAX";
            } else if (method.equalsIgnoreCase("SUM")) {
                method = "SUM";
            } else if (method.equalsIgnoreCase("ABS")) {
                method = "ABS";
            } else if (method.equalsIgnoreCase("INDEX")) {
                method = "INDEX";
            }
            if (method.equalsIgnoreCase("Object")) {
                this.processExpression();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
                return true;
            }
            if (method.equalsIgnoreCase("MOD")) {
                Node modNode = new Node(NodeType.OPERATOR, "%");
                this.processExpression();
                Node firstNode = this.stack.pop();
                if (!this.p.parseChar(',')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                this.processExpression();
                Node secondNode = this.stack.pop();
                modNode.appendChildNode(firstNode);
                modNode.appendChildNode(secondNode);
                this.stack.push(modNode);
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
                return true;
            }
            if (method.equalsIgnoreCase("TYPE")) {
                Node typeNode = new Node(NodeType.TYPE);
                this.processExpression();
                Node typePrimaryNode = this.stack.pop();
                typeNode.appendChildNode(typePrimaryNode);
                this.stack.push(typeNode);
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
                return true;
            }
            if (method.equalsIgnoreCase("SUBSTRING")) {
                Node invokeNode = new Node(NodeType.INVOKE, "substring");
                this.processExpression();
                Node primaryNode = this.stack.pop();
                if (!this.p.parseChar(',')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                this.processExpression();
                Node arg1 = this.stack.pop();
                Node oneNode = new Node(NodeType.LITERAL, 1);
                Node arg1Node = new Node(NodeType.OPERATOR, "-");
                arg1Node.insertChildNode(arg1);
                arg1Node.appendChildNode(oneNode);
                if (this.p.parseChar(',')) {
                    this.processExpression();
                    Node arg2 = this.stack.pop();
                    Node arg2Node = new Node(NodeType.OPERATOR, "+");
                    arg2Node.appendChildNode(arg2);
                    arg2Node.appendChildNode(arg1Node);
                    if (!this.p.parseChar(')')) {
                        throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                    }
                    primaryNode.appendChildNode(invokeNode);
                    invokeNode.addProperty(arg1Node);
                    invokeNode.addProperty(arg2Node);
                    this.stack.push(primaryNode);
                    return true;
                }
                if (this.p.parseChar(')')) {
                    primaryNode.appendChildNode(invokeNode);
                    invokeNode.addProperty(arg1Node);
                    this.stack.push(primaryNode);
                    return true;
                }
                throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
            }
            if (method.equalsIgnoreCase("UPPER")) {
                Node primaryNode;
                Node invokeNode = new Node(NodeType.INVOKE, "toUpperCase");
                this.processExpression();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                Node primaryRootNode = primaryNode = this.stack.pop();
                while (primaryNode.getFirstChild() != null) {
                    primaryNode = primaryNode.getFirstChild();
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryRootNode);
                return true;
            }
            if (method.equalsIgnoreCase("LOWER")) {
                Node primaryNode;
                Node invokeNode = new Node(NodeType.INVOKE, "toLowerCase");
                this.processExpression();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                Node primaryRootNode = primaryNode = this.stack.pop();
                while (primaryNode.getFirstChild() != null) {
                    primaryNode = primaryNode.getFirstChild();
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryRootNode);
                return true;
            }
            if (method.equalsIgnoreCase("LENGTH")) {
                Node primaryNode;
                Node invokeNode = new Node(NodeType.INVOKE, "length");
                this.processExpression();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                Node primaryRootNode = primaryNode = this.stack.pop();
                while (primaryNode.getFirstChild() != null) {
                    primaryNode = primaryNode.getFirstChild();
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryRootNode);
                return true;
            }
            if (method.equalsIgnoreCase("CONCAT")) {
                this.processExpression();
                Node prevNode = this.stack.pop();
                while (true) {
                    if (!this.p.parseChar(',')) {
                        throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                    }
                    this.processExpression();
                    Node thisNode = this.stack.pop();
                    Node currentNode = new Node(NodeType.OPERATOR, "+");
                    currentNode.appendChildNode(prevNode);
                    currentNode.appendChildNode(thisNode);
                    if (this.p.parseChar(')')) {
                        this.stack.push(currentNode);
                        return true;
                    }
                    prevNode = currentNode;
                    currentNode = null;
                }
            }
            if (method.equalsIgnoreCase("LOCATE")) {
                Node primaryNode;
                this.processExpression();
                Node searchNode = this.stack.pop();
                Node invokeNode = new Node(NodeType.INVOKE, "indexOf");
                invokeNode.addProperty(searchNode);
                if (!this.p.parseChar(',')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                this.processExpression();
                Node primaryRootNode = primaryNode = this.stack.pop();
                while (primaryNode.getFirstChild() != null) {
                    primaryNode = primaryNode.getFirstChild();
                }
                primaryNode.appendChildNode(invokeNode);
                Node oneNode = new Node(NodeType.LITERAL, 1);
                if (this.p.parseChar(',')) {
                    this.processExpression();
                    Node fromPosNode = this.stack.pop();
                    Node positionNode = new Node(NodeType.OPERATOR, "-");
                    positionNode.appendChildNode(fromPosNode);
                    positionNode.appendChildNode(oneNode);
                    invokeNode.addProperty(positionNode);
                }
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
                Node locateNode = new Node(NodeType.OPERATOR, "+");
                locateNode.appendChildNode(primaryRootNode);
                locateNode.appendChildNode(oneNode);
                this.stack.push(locateNode);
                return true;
            }
            if (method.equalsIgnoreCase("TRIM")) {
                String methodName = "trim";
                if (this.p.parseStringIgnoreCase("LEADING")) {
                    methodName = "trimLeft";
                } else if (this.p.parseStringIgnoreCase("TRAILING")) {
                    methodName = "trimRight";
                } else if (this.p.parseStringIgnoreCase("BOTH")) {
                    // empty if block
                }
                Node invokeNode = new Node(NodeType.INVOKE, methodName);
                Node trimCharNode = null;
                this.processExpression();
                Node next = this.stack.pop();
                if (this.p.parseChar(')')) {
                    next.appendChildNode(invokeNode);
                    this.stack.push(next);
                    return true;
                }
                if (next.getNodeType() == NodeType.LITERAL) {
                    trimCharNode = next;
                    if (this.p.parseStringIgnoreCase("FROM ")) {
                        // empty if block
                    }
                    this.processExpression();
                    next = this.stack.pop();
                } else if (next.getNodeType() == NodeType.IDENTIFIER) {
                    Object litValue = next.getNodeValue();
                    if (litValue instanceof String && ((String)litValue).equals("FROM")) {
                        this.processExpression();
                        next = this.stack.pop();
                    } else {
                        throw new QueryCompilerSyntaxException("Unexpected expression", this.p.getIndex(), this.p.getInput());
                    }
                }
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
                next.appendChildNode(invokeNode);
                if (trimCharNode != null) {
                    invokeNode.addProperty(trimCharNode);
                }
                this.stack.push(next);
                return true;
            }
            if (method.equalsIgnoreCase("SIZE")) {
                Node primaryNode;
                Node invokeNode = new Node(NodeType.INVOKE, "size");
                this.processExpression();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                Node primaryRootNode = primaryNode = this.stack.pop();
                while (primaryNode.getFirstChild() != null) {
                    primaryNode = primaryNode.getFirstChild();
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryRootNode);
                return true;
            }
            if (method.equalsIgnoreCase("KEY")) {
                Node primaryNode;
                Node invokeNode = new Node(NodeType.INVOKE, "mapKey");
                this.processExpression();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                Node primaryRootNode = primaryNode = this.stack.pop();
                while (primaryNode.getFirstChild() != null) {
                    primaryNode = primaryNode.getFirstChild();
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryRootNode);
                return true;
            }
            if (method.equalsIgnoreCase("VALUE")) {
                Node primaryNode;
                Node invokeNode = new Node(NodeType.INVOKE, "mapValue");
                this.processExpression();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                Node primaryRootNode = primaryNode = this.stack.pop();
                while (primaryNode.getFirstChild() != null) {
                    primaryNode = primaryNode.getFirstChild();
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryRootNode);
                return true;
            }
            if (method.equalsIgnoreCase("ENTRY")) {
                Node primaryNode;
                Node invokeNode = new Node(NodeType.INVOKE, "mapEntry");
                this.processExpression();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                Node primaryRootNode = primaryNode = this.stack.pop();
                while (primaryNode.getFirstChild() != null) {
                    primaryNode = primaryNode.getFirstChild();
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryRootNode);
                return true;
            }
            if (method.equalsIgnoreCase("YEAR")) {
                Node primaryNode;
                Node invokeNode = new Node(NodeType.INVOKE, "getYear");
                this.processExpression();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                Node primaryRootNode = primaryNode = this.stack.pop();
                while (primaryNode.getFirstChild() != null) {
                    primaryNode = primaryNode.getFirstChild();
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryRootNode);
                return true;
            }
            if (method.equalsIgnoreCase("MONTH")) {
                Node primaryNode;
                Node invokeNode = new Node(NodeType.INVOKE, "getMonth");
                this.processExpression();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                Node primaryRootNode = primaryNode = this.stack.pop();
                while (primaryNode.getFirstChild() != null) {
                    primaryNode = primaryNode.getFirstChild();
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryRootNode);
                return true;
            }
            if (method.equalsIgnoreCase("DAY")) {
                Node primaryNode;
                Node invokeNode = new Node(NodeType.INVOKE, "getDay");
                this.processExpression();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                Node primaryRootNode = primaryNode = this.stack.pop();
                while (primaryNode.getFirstChild() != null) {
                    primaryNode = primaryNode.getFirstChild();
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryRootNode);
                return true;
            }
            if (method.equalsIgnoreCase("HOUR")) {
                Node primaryNode;
                Node invokeNode = new Node(NodeType.INVOKE, "getHour");
                this.processExpression();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                Node primaryRootNode = primaryNode = this.stack.pop();
                while (primaryNode.getFirstChild() != null) {
                    primaryNode = primaryNode.getFirstChild();
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryRootNode);
                return true;
            }
            if (method.equalsIgnoreCase("MINUTE")) {
                Node primaryNode;
                Node invokeNode = new Node(NodeType.INVOKE, "getMinute");
                this.processExpression();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                Node primaryRootNode = primaryNode = this.stack.pop();
                while (primaryNode.getFirstChild() != null) {
                    primaryNode = primaryNode.getFirstChild();
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryRootNode);
                return true;
            }
            if (method.equalsIgnoreCase("SECOND")) {
                Node primaryNode;
                Node invokeNode = new Node(NodeType.INVOKE, "getSecond");
                this.processExpression();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                Node primaryRootNode = primaryNode = this.stack.pop();
                while (primaryNode.getFirstChild() != null) {
                    primaryNode = primaryNode.getFirstChild();
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryRootNode);
                return true;
            }
            Node node = new Node(NodeType.INVOKE, method);
            if (!this.p.parseChar(')')) {
                do {
                    this.processExpression();
                    node.addProperty(this.stack.pop());
                } while (this.p.parseChar(','));
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
            }
            this.stack.push(node);
            return true;
        }
        return false;
    }

    protected boolean processLiteral() {
        Object litValue = null;
        boolean single_quote_next = this.p.nextIsSingleQuote();
        String sLiteral = this.p.parseStringLiteral();
        if (sLiteral != null) {
            litValue = sLiteral.length() == 1 && single_quote_next ? Character.valueOf(sLiteral.charAt(0)) : sLiteral;
        } else {
            BigDecimal fLiteral = this.p.parseFloatingPointLiteral();
            if (fLiteral != null) {
                litValue = fLiteral;
            } else {
                BigInteger iLiteral = this.p.parseIntegerLiteral();
                if (iLiteral != null) {
                    litValue = iLiteral.longValue();
                } else {
                    Boolean bLiteral = this.p.parseBooleanLiteralIgnoreCase();
                    if (bLiteral != null) {
                        litValue = bLiteral;
                    } else if (this.p.parseNullLiteralIgnoreCase()) {
                        litValue = null;
                    } else {
                        return false;
                    }
                }
            }
        }
        this.stack.push(new Node(NodeType.LITERAL, litValue));
        return true;
    }

    private boolean processIdentifier() {
        String id = this.p.parseIdentifier();
        if (id == null || id.length() == 0) {
            return false;
        }
        char first = id.charAt(0);
        if (first == '?') {
            if (this.paramType == null) {
                this.paramType = ParameterType.NUMBERED;
            } else if (this.paramType == ParameterType.NAMED) {
                throw new QueryInvalidParametersException("Query is using named parameters yet also has \"" + id + "\"");
            }
            String paramName = id.substring(1);
            try {
                ParameterNode node = new ParameterNode(NodeType.PARAMETER, Integer.valueOf(paramName), this.parameterPosition);
                ++this.parameterPosition;
                this.stack.push(node);
                return true;
            }
            catch (NumberFormatException nfe) {
                throw new NucleusUserException("Numbered parameter syntax starting ? but isnt followed by numeric!");
            }
        }
        if (first == ':') {
            if (this.paramType == null) {
                this.paramType = ParameterType.NAMED;
            } else if (this.paramType == ParameterType.NUMBERED) {
                throw new QueryInvalidParametersException("Query is using numbered parameters yet also has \"" + id + "\"");
            }
            ParameterNode node = new ParameterNode(NodeType.PARAMETER, id.substring(1), this.parameterPosition);
            ++this.parameterPosition;
            this.stack.push(node);
            return true;
        }
        Node node = new Node(NodeType.IDENTIFIER, id);
        this.stack.push(node);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParameterType {
        NUMBERED,
        NAMED;

    }
}

