/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ClassConstants;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MultiMapping;
import org.datanucleus.util.Localiser;

public class CorrespondentColumnsMapper {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    private final Map columnMetaDataBySideBIdentifier = new HashMap();
    private final String columnsName;

    public CorrespondentColumnsMapper(ColumnMetaDataContainer columnContainer, ColumnMetaData[] colmds, JavaTypeMapping mappingSideB, boolean updateContainer) {
        if (columnContainer != null && colmds != null) {
            int i;
            int noOfUserColumns = colmds.length;
            StringBuffer str = new StringBuffer("Columns [");
            for (int i2 = 0; i2 < noOfUserColumns; ++i2) {
                str.append(colmds[i2].getName());
                if (i2 >= noOfUserColumns - 1) continue;
                str.append(", ");
            }
            str.append("]");
            this.columnsName = str.toString();
            if (noOfUserColumns > mappingSideB.getNumberOfDatastoreMappings()) {
                throw new NucleusUserException(LOCALISER.msg("020003", (Object)this.columnsName, (Object)("" + noOfUserColumns), (Object)("" + mappingSideB.getNumberOfDatastoreMappings()))).setFatal();
            }
            DatastoreIdentifier[] sideBidentifiers = new DatastoreIdentifier[mappingSideB.getNumberOfDatastoreMappings()];
            boolean[] sideButilised = new boolean[mappingSideB.getNumberOfDatastoreMappings()];
            for (int i3 = 0; i3 < mappingSideB.getNumberOfDatastoreMappings(); ++i3) {
                sideBidentifiers[i3] = mappingSideB.getDatastoreMapping(i3).getDatastoreField().getIdentifier();
                sideButilised[i3] = false;
            }
            JavaTypeMapping[] sideBidMappings = ((MultiMapping)mappingSideB).getJavaTypeMapping();
            for (i = 0; i < noOfUserColumns; ++i) {
                int j;
                String targetFieldName;
                String targetColumnName = colmds[i].getTarget();
                if (targetColumnName == null && (targetFieldName = colmds[i].getTargetMember()) != null) {
                    for (j = 0; j < sideBidMappings.length; ++j) {
                        if (!sideBidMappings[j].getMemberMetaData().getName().equals(targetFieldName)) continue;
                        targetColumnName = sideBidMappings[j].getDatastoreMapping(0).getDatastoreField().getIdentifier().getIdentifierName();
                        break;
                    }
                }
                if (targetColumnName == null) continue;
                boolean targetExists = false;
                for (j = 0; j < sideBidentifiers.length; ++j) {
                    if (!sideBidentifiers[j].getIdentifierName().equalsIgnoreCase(targetColumnName) || sideButilised[j]) continue;
                    this.putColumn(sideBidentifiers[j], colmds[i]);
                    sideButilised[j] = true;
                    targetExists = true;
                    break;
                }
                if (targetExists) continue;
                throw new NucleusUserException(LOCALISER.msg("020004", (Object)this.columnsName, (Object)colmds[i].getName(), (Object)targetColumnName)).setFatal();
            }
            block5: for (i = 0; i < colmds.length; ++i) {
                if (colmds[i].getTarget() != null) continue;
                for (int j = 0; j < sideBidentifiers.length; ++j) {
                    if (sideButilised[j]) continue;
                    this.putColumn(sideBidentifiers[j], colmds[i]);
                    sideButilised[j] = true;
                    continue block5;
                }
            }
            for (i = colmds.length; i < mappingSideB.getNumberOfDatastoreMappings(); ++i) {
                DatastoreIdentifier sideBidentifier = null;
                for (int j = 0; j < sideBidentifiers.length; ++j) {
                    if (sideButilised[j]) continue;
                    sideBidentifier = sideBidentifiers[j];
                    sideButilised[j] = true;
                    break;
                }
                if (sideBidentifier == null) {
                    throw new NucleusUserException(LOCALISER.msg("020005", (Object)this.columnsName, (Object)("" + i))).setFatal();
                }
                ColumnMetaData colmd = new ColumnMetaData();
                if (updateContainer) {
                    columnContainer.addColumn(colmd);
                }
                this.putColumn(sideBidentifier, colmd);
            }
        } else {
            this.columnsName = null;
            for (int i = 0; i < mappingSideB.getNumberOfDatastoreMappings(); ++i) {
                DatastoreIdentifier sideBidentifier = mappingSideB.getDatastoreMapping(i).getDatastoreField().getIdentifier();
                ColumnMetaData colmd = new ColumnMetaData();
                this.putColumn(sideBidentifier, colmd);
            }
        }
    }

    public CorrespondentColumnsMapper(ColumnMetaDataContainer columnContainer, JavaTypeMapping mappingSideB, boolean updateContainer) {
        if (columnContainer != null) {
            int i;
            int noOfUserColumns = columnContainer.getColumnMetaData().length;
            ColumnMetaData[] colmds = columnContainer.getColumnMetaData();
            StringBuffer str = new StringBuffer("Columns [");
            for (int i2 = 0; i2 < noOfUserColumns; ++i2) {
                str.append(colmds[i2].getName());
                if (i2 >= noOfUserColumns - 1) continue;
                str.append(", ");
            }
            str.append("]");
            this.columnsName = str.toString();
            if (noOfUserColumns > mappingSideB.getNumberOfDatastoreMappings()) {
                throw new NucleusUserException(LOCALISER.msg("020003", (Object)this.columnsName, (Object)("" + noOfUserColumns), (Object)("" + mappingSideB.getNumberOfDatastoreMappings()))).setFatal();
            }
            DatastoreIdentifier[] sideBidentifiers = new DatastoreIdentifier[mappingSideB.getNumberOfDatastoreMappings()];
            boolean[] sideButilised = new boolean[mappingSideB.getNumberOfDatastoreMappings()];
            for (int i3 = 0; i3 < mappingSideB.getNumberOfDatastoreMappings(); ++i3) {
                sideBidentifiers[i3] = mappingSideB.getDatastoreMapping(i3).getDatastoreField().getIdentifier();
                sideButilised[i3] = false;
            }
            JavaTypeMapping[] sideBidMappings = ((MultiMapping)mappingSideB).getJavaTypeMapping();
            for (i = 0; i < noOfUserColumns; ++i) {
                int j;
                String targetFieldName;
                String targetColumnName = colmds[i].getTarget();
                if (targetColumnName == null && (targetFieldName = colmds[i].getTargetMember()) != null) {
                    for (j = 0; j < sideBidMappings.length; ++j) {
                        if (!sideBidMappings[j].getMemberMetaData().getName().equals(targetFieldName)) continue;
                        targetColumnName = sideBidMappings[j].getDatastoreMapping(0).getDatastoreField().getIdentifier().getIdentifierName();
                        break;
                    }
                }
                if (targetColumnName == null) continue;
                boolean targetExists = false;
                for (j = 0; j < sideBidentifiers.length; ++j) {
                    if (!sideBidentifiers[j].getIdentifierName().equalsIgnoreCase(targetColumnName) || sideButilised[j]) continue;
                    this.putColumn(sideBidentifiers[j], colmds[i]);
                    sideButilised[j] = true;
                    targetExists = true;
                    break;
                }
                if (targetExists) continue;
                throw new NucleusUserException(LOCALISER.msg("020004", (Object)this.columnsName, (Object)colmds[i].getName(), (Object)targetColumnName)).setFatal();
            }
            block5: for (i = 0; i < colmds.length; ++i) {
                if (colmds[i].getTarget() != null) continue;
                for (int j = 0; j < sideBidentifiers.length; ++j) {
                    if (sideButilised[j]) continue;
                    this.putColumn(sideBidentifiers[j], colmds[i]);
                    sideButilised[j] = true;
                    continue block5;
                }
            }
            for (i = colmds.length; i < mappingSideB.getNumberOfDatastoreMappings(); ++i) {
                DatastoreIdentifier sideBidentifier = null;
                for (int j = 0; j < sideBidentifiers.length; ++j) {
                    if (sideButilised[j]) continue;
                    sideBidentifier = sideBidentifiers[j];
                    sideButilised[j] = true;
                    break;
                }
                if (sideBidentifier == null) {
                    throw new NucleusUserException(LOCALISER.msg("020005", (Object)this.columnsName, (Object)("" + i))).setFatal();
                }
                ColumnMetaData colmd = new ColumnMetaData();
                if (updateContainer) {
                    columnContainer.addColumn(colmd);
                }
                this.putColumn(sideBidentifier, colmd);
            }
        } else {
            this.columnsName = null;
            for (int i = 0; i < mappingSideB.getNumberOfDatastoreMappings(); ++i) {
                DatastoreIdentifier sideBidentifier = mappingSideB.getDatastoreMapping(i).getDatastoreField().getIdentifier();
                ColumnMetaData colmd = new ColumnMetaData();
                this.putColumn(sideBidentifier, colmd);
            }
        }
    }

    public ColumnMetaData getColumnMetaDataByIdentifier(DatastoreIdentifier name) {
        return (ColumnMetaData)this.columnMetaDataBySideBIdentifier.get(name);
    }

    private void putColumn(DatastoreIdentifier identifier, ColumnMetaData colmd) {
        if (this.columnMetaDataBySideBIdentifier.put(identifier, colmd) != null) {
            throw new NucleusUserException(LOCALISER.msg("020006", identifier, (Object)this.columnsName)).setFatal();
        }
    }
}

