/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.Credential;
import com.google.appengine.repackaged.com.google.api.client.extensions.appengine.http.UrlFetchTransport;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.appengine.repackaged.com.google.api.client.googleapis.compute.ComputeCredential;
import com.google.appengine.repackaged.com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.appengine.repackaged.com.google.api.client.http.HttpTransport;
import com.google.appengine.repackaged.com.google.api.client.json.jackson.JacksonFactory;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.apphosting.api.ApiProxy;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;

public class RemoteApiOptions {
    private static final ImmutableList<String> OAUTH_SCOPES = ImmutableList.of("https://www.googleapis.com/auth/appengine.apis", "https://www.googleapis.com/auth/userinfo.email");
    private static final String LOCAL_USER = "test@example.com";
    private static final String LOCAL_PASSWORD = "";
    private String hostname;
    private int port;
    private String userEmail;
    private String password;
    private String credentialsToReuse;
    private String remoteApiPath = "/remote_api";
    private int maxConcurrentRequests = 5;
    private int datastoreQueryFetchSize = 500;
    private int maxHttpResponseSize = 0x2100000;
    private Credential oauthCredential;
    private HttpTransport httpTransport;

    public RemoteApiOptions() {
    }

    RemoteApiOptions(RemoteApiOptions original) {
        this.hostname = original.hostname;
        this.port = original.port;
        this.userEmail = original.userEmail;
        this.password = original.password;
        this.credentialsToReuse = original.credentialsToReuse;
        this.remoteApiPath = original.remoteApiPath;
        this.maxConcurrentRequests = original.maxConcurrentRequests;
        this.datastoreQueryFetchSize = original.datastoreQueryFetchSize;
        this.maxHttpResponseSize = original.maxHttpResponseSize;
        this.oauthCredential = original.oauthCredential;
        this.httpTransport = original.httpTransport;
    }

    public RemoteApiOptions server(String newHostname, int newPort) {
        this.hostname = newHostname;
        this.port = newPort;
        return this;
    }

    @Deprecated
    public RemoteApiOptions credentials(String newUserEMail, String newPassword) {
        this.userEmail = newUserEMail;
        this.password = newPassword;
        this.credentialsToReuse = null;
        this.oauthCredential = null;
        return this;
    }

    public RemoteApiOptions reuseCredentials(String newUserEmail, String serializedCredentials) {
        this.userEmail = newUserEmail;
        this.password = null;
        this.credentialsToReuse = serializedCredentials;
        this.oauthCredential = null;
        return this;
    }

    @Deprecated
    public RemoteApiOptions useComputeEngineCredential() {
        try {
            HttpTransport transport = this.getOrCreateHttpTransportForOAuth();
            ComputeCredential credential = new ComputeCredential(transport, new JacksonFactory());
            credential.refreshToken();
            this.setOAuthCredential(credential);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Failed to acquire Google Compute Engine credential.", e);
        }
        return this;
    }

    public RemoteApiOptions useApplicationDefaultCredential() {
        try {
            this.getOrCreateHttpTransportForOAuth();
            GoogleCredential credential = GoogleCredential.getApplicationDefault();
            credential = credential.createScoped(OAUTH_SCOPES);
            credential.refreshToken();
            this.setOAuthCredential(credential);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Failed to acquire Google Application Default credential.", e);
        }
        return this;
    }

    public RemoteApiOptions useServiceAccountCredential(String serviceAccountId, String p12PrivateKeyFile) {
        try {
            GoogleCredential credential = this.getCredentialBuilder(serviceAccountId).setServiceAccountPrivateKeyFromP12File(new File(p12PrivateKeyFile)).build();
            this.setOAuthCredential(credential);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Failed to build service account credential.", e);
        }
        return this;
    }

    public RemoteApiOptions useServiceAccountCredential(String serviceAccountId, PrivateKey privateKey) {
        try {
            GoogleCredential credential = this.getCredentialBuilder(serviceAccountId).setServiceAccountPrivateKey(privateKey).build();
            this.setOAuthCredential(credential);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Failed to build service account credential.", e);
        }
        return this;
    }

    public RemoteApiOptions useDevelopmentServerCredential() {
        this.credentials(LOCAL_USER, LOCAL_PASSWORD);
        return this;
    }

    private GoogleCredential.Builder getCredentialBuilder(String serviceAccountId) throws GeneralSecurityException, IOException {
        HttpTransport transport = this.getOrCreateHttpTransportForOAuth();
        JacksonFactory jsonFactory = new JacksonFactory();
        return new GoogleCredential.Builder().setTransport(transport).setJsonFactory(jsonFactory).setServiceAccountId(serviceAccountId).setServiceAccountScopes(OAUTH_SCOPES);
    }

    RemoteApiOptions useGoogleCredentialStream(InputStream stream) {
        try {
            this.getOrCreateHttpTransportForOAuth();
            GoogleCredential credential = GoogleCredential.fromStream(stream);
            credential = credential.createScoped(OAUTH_SCOPES);
            credential.refreshToken();
            this.setOAuthCredential(credential);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Failed to acquire Google credential.", e);
        }
        return this;
    }

    RemoteApiOptions oauthCredential(Credential oauthCredential) {
        this.setOAuthCredential(oauthCredential);
        return this;
    }

    private void setOAuthCredential(Credential oauthCredential) {
        this.userEmail = null;
        this.password = null;
        this.credentialsToReuse = null;
        this.oauthCredential = oauthCredential;
    }

    RemoteApiOptions httpTransport(HttpTransport httpTransport) {
        this.httpTransport = httpTransport;
        return this;
    }

    public RemoteApiOptions remoteApiPath(String newPath) {
        this.remoteApiPath = newPath;
        return this;
    }

    public RemoteApiOptions maxConcurrentRequests(int newValue) {
        this.maxConcurrentRequests = newValue;
        return this;
    }

    public RemoteApiOptions datastoreQueryFetchSize(int newValue) {
        this.datastoreQueryFetchSize = newValue;
        return this;
    }

    public RemoteApiOptions maxHttpResponseSize(int newValue) {
        this.maxHttpResponseSize = newValue;
        return this;
    }

    public RemoteApiOptions copy() {
        return new RemoteApiOptions(this);
    }

    private HttpTransport getOrCreateHttpTransportForOAuth() throws IOException, GeneralSecurityException {
        if (this.httpTransport != null) {
            return this.httpTransport;
        }
        this.httpTransport = ApiProxy.getCurrentEnvironment() == null ? GoogleNetHttpTransport.newTrustedTransport() : new UrlFetchTransport();
        return this.httpTransport;
    }

    HttpTransport getHttpTransport() {
        return this.httpTransport;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCredentialsToReuse() {
        return this.credentialsToReuse;
    }

    Credential getOAuthCredential() {
        return this.oauthCredential;
    }

    public String getRemoteApiPath() {
        return this.remoteApiPath;
    }

    public int getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    public int getDatastoreQueryFetchSize() {
        return this.datastoreQueryFetchSize;
    }

    public int getMaxHttpResponseSize() {
        return this.maxHttpResponseSize;
    }
}

