/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeField;
import com.google.appengine.repackaged.org.joda.time.DateTimeFieldType;
import com.google.appengine.repackaged.org.joda.time.DateTimeUtils;
import com.google.appengine.repackaged.org.joda.time.DurationField;
import com.google.appengine.repackaged.org.joda.time.DurationFieldType;
import com.google.appengine.repackaged.org.joda.time.ReadableInstant;
import com.google.appengine.repackaged.org.joda.time.ReadablePartial;
import com.google.appengine.repackaged.org.joda.time.ReadablePeriod;
import com.google.appengine.repackaged.org.joda.time.base.AbstractPartial;
import com.google.appengine.repackaged.org.joda.time.field.AbstractPartialFieldProperty;
import com.google.appengine.repackaged.org.joda.time.field.FieldUtils;
import com.google.appengine.repackaged.org.joda.time.format.DateTimeFormat;
import com.google.appengine.repackaged.org.joda.time.format.DateTimeFormatter;
import com.google.appengine.repackaged.org.joda.time.format.ISODateTimeFormat;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public final class Partial
extends AbstractPartial
implements ReadablePartial,
Serializable {
    private static final long serialVersionUID = 12324121189002L;
    private final Chronology iChronology;
    private final DateTimeFieldType[] iTypes;
    private final int[] iValues;
    private transient DateTimeFormatter[] iFormatter;

    public Partial() {
        this((Chronology)null);
    }

    public Partial(Chronology chrono) {
        this.iChronology = DateTimeUtils.getChronology(chrono).withUTC();
        this.iTypes = new DateTimeFieldType[0];
        this.iValues = new int[0];
    }

    public Partial(DateTimeFieldType type, int value) {
        this(type, value, null);
    }

    public Partial(DateTimeFieldType type, int value, Chronology chronology) {
        this.iChronology = chronology = DateTimeUtils.getChronology(chronology).withUTC();
        if (type == null) {
            throw new IllegalArgumentException("The field type must not be null");
        }
        this.iTypes = new DateTimeFieldType[]{type};
        this.iValues = new int[]{value};
        chronology.validate(this, this.iValues);
    }

    public Partial(DateTimeFieldType[] types, int[] values) {
        this(types, values, null);
    }

    public Partial(DateTimeFieldType[] types, int[] values, Chronology chronology) {
        this.iChronology = chronology = DateTimeUtils.getChronology(chronology).withUTC();
        if (types == null) {
            throw new IllegalArgumentException("Types array must not be null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Values array must not be null");
        }
        if (values.length != types.length) {
            throw new IllegalArgumentException("Values array must be the same length as the types array");
        }
        if (types.length == 0) {
            this.iTypes = types;
            this.iValues = values;
            return;
        }
        for (int i = 0; i < types.length; ++i) {
            if (types[i] != null) continue;
            int n = i;
            throw new IllegalArgumentException(new StringBuilder(52).append("Types array must not contain null: index ").append(n).toString());
        }
        DurationField lastUnitField = null;
        for (int i = 0; i < types.length; ++i) {
            DateTimeFieldType loopType = types[i];
            DurationField loopUnitField = loopType.getDurationType().getField(this.iChronology);
            if (i > 0) {
                String string;
                String string2;
                int compare = lastUnitField.compareTo(loopUnitField);
                if (compare < 0 || compare != 0 && !loopUnitField.isSupported()) {
                    string2 = types[i - 1].getName();
                    string = loopType.getName();
                    throw new IllegalArgumentException(new StringBuilder(50 + String.valueOf(string2).length() + String.valueOf(string).length()).append("Types array must be in order largest-smallest: ").append(string2).append(" < ").append(string).toString());
                }
                if (compare == 0) {
                    if (types[i - 1].getRangeDurationType() == null) {
                        if (loopType.getRangeDurationType() == null) {
                            String string3 = String.valueOf(loopType.getName());
                            throw new IllegalArgumentException(string3.length() != 0 ? "Types array must not contain duplicate: ".concat(string3) : new String("Types array must not contain duplicate: "));
                        }
                    } else {
                        DurationField loopRangeField;
                        if (loopType.getRangeDurationType() == null) {
                            string2 = types[i - 1].getName();
                            string = loopType.getName();
                            throw new IllegalArgumentException(new StringBuilder(50 + String.valueOf(string2).length() + String.valueOf(string).length()).append("Types array must be in order largest-smallest: ").append(string2).append(" < ").append(string).toString());
                        }
                        DurationField lastRangeField = types[i - 1].getRangeDurationType().getField(this.iChronology);
                        if (lastRangeField.compareTo(loopRangeField = loopType.getRangeDurationType().getField(this.iChronology)) < 0) {
                            String string4 = types[i - 1].getName();
                            String string5 = loopType.getName();
                            throw new IllegalArgumentException(new StringBuilder(50 + String.valueOf(string4).length() + String.valueOf(string5).length()).append("Types array must be in order largest-smallest: ").append(string4).append(" < ").append(string5).toString());
                        }
                        if (lastRangeField.compareTo(loopRangeField) == 0) {
                            String string6 = String.valueOf(loopType.getName());
                            throw new IllegalArgumentException(string6.length() != 0 ? "Types array must not contain duplicate: ".concat(string6) : new String("Types array must not contain duplicate: "));
                        }
                    }
                }
            }
            lastUnitField = loopUnitField;
        }
        this.iTypes = (DateTimeFieldType[])types.clone();
        chronology.validate(this, values);
        this.iValues = (int[])values.clone();
    }

    public Partial(ReadablePartial partial) {
        if (partial == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        this.iChronology = DateTimeUtils.getChronology(partial.getChronology()).withUTC();
        this.iTypes = new DateTimeFieldType[partial.size()];
        this.iValues = new int[partial.size()];
        for (int i = 0; i < partial.size(); ++i) {
            this.iTypes[i] = partial.getFieldType(i);
            this.iValues[i] = partial.getValue(i);
        }
    }

    Partial(Partial partial, int[] values) {
        this.iChronology = partial.iChronology;
        this.iTypes = partial.iTypes;
        this.iValues = values;
    }

    Partial(Chronology chronology, DateTimeFieldType[] types, int[] values) {
        this.iChronology = chronology;
        this.iTypes = types;
        this.iValues = values;
    }

    @Override
    public int size() {
        return this.iTypes.length;
    }

    @Override
    public Chronology getChronology() {
        return this.iChronology;
    }

    @Override
    protected DateTimeField getField(int index, Chronology chrono) {
        return this.iTypes[index].getField(chrono);
    }

    @Override
    public DateTimeFieldType getFieldType(int index) {
        return this.iTypes[index];
    }

    @Override
    public DateTimeFieldType[] getFieldTypes() {
        return (DateTimeFieldType[])this.iTypes.clone();
    }

    @Override
    public int getValue(int index) {
        return this.iValues[index];
    }

    @Override
    public int[] getValues() {
        return (int[])this.iValues.clone();
    }

    public Partial withChronologyRetainFields(Chronology newChronology) {
        newChronology = DateTimeUtils.getChronology(newChronology);
        if ((newChronology = newChronology.withUTC()) == this.getChronology()) {
            return this;
        }
        Partial newPartial = new Partial(newChronology, this.iTypes, this.iValues);
        newChronology.validate(newPartial, this.iValues);
        return newPartial;
    }

    public Partial with(DateTimeFieldType fieldType, int value) {
        if (fieldType == null) {
            throw new IllegalArgumentException("The field type must not be null");
        }
        int index = this.indexOf(fieldType);
        if (index == -1) {
            int i;
            DateTimeFieldType[] newTypes = new DateTimeFieldType[this.iTypes.length + 1];
            int[] newValues = new int[newTypes.length];
            DurationField unitField = fieldType.getDurationType().getField(this.iChronology);
            if (unitField.isSupported()) {
                DurationField loopRangeField;
                DurationField rangeField;
                int compare;
                DateTimeFieldType loopType;
                DurationField loopUnitField;
                for (i = 0; !(i >= this.iTypes.length || (loopUnitField = (loopType = this.iTypes[i]).getDurationType().getField(this.iChronology)).isSupported() && ((compare = unitField.compareTo(loopUnitField)) > 0 || compare == 0 && (rangeField = fieldType.getRangeDurationType().getField(this.iChronology)).compareTo(loopRangeField = loopType.getRangeDurationType().getField(this.iChronology)) > 0)); ++i) {
                }
            }
            System.arraycopy(this.iTypes, 0, newTypes, 0, i);
            System.arraycopy(this.iValues, 0, newValues, 0, i);
            newTypes[i] = fieldType;
            newValues[i] = value;
            System.arraycopy(this.iTypes, i, newTypes, i + 1, newTypes.length - i - 1);
            System.arraycopy(this.iValues, i, newValues, i + 1, newValues.length - i - 1);
            Partial newPartial = new Partial(this.iChronology, newTypes, newValues);
            this.iChronology.validate(newPartial, newValues);
            return newPartial;
        }
        if (value == this.getValue(index)) {
            return this;
        }
        int[] newValues = this.getValues();
        newValues = this.getField(index).set(this, index, newValues, value);
        return new Partial(this, newValues);
    }

    public Partial without(DateTimeFieldType fieldType) {
        int index = this.indexOf(fieldType);
        if (index != -1) {
            DateTimeFieldType[] newTypes = new DateTimeFieldType[this.size() - 1];
            int[] newValues = new int[this.size() - 1];
            System.arraycopy(this.iTypes, 0, newTypes, 0, index);
            System.arraycopy(this.iTypes, index + 1, newTypes, index, newTypes.length - index);
            System.arraycopy(this.iValues, 0, newValues, 0, index);
            System.arraycopy(this.iValues, index + 1, newValues, index, newValues.length - index);
            Partial newPartial = new Partial(this.iChronology, newTypes, newValues);
            this.iChronology.validate(newPartial, newValues);
            return newPartial;
        }
        return this;
    }

    public Partial withField(DateTimeFieldType fieldType, int value) {
        int index = this.indexOfSupported(fieldType);
        if (value == this.getValue(index)) {
            return this;
        }
        int[] newValues = this.getValues();
        newValues = this.getField(index).set(this, index, newValues, value);
        return new Partial(this, newValues);
    }

    public Partial withFieldAdded(DurationFieldType fieldType, int amount) {
        int index = this.indexOfSupported(fieldType);
        if (amount == 0) {
            return this;
        }
        int[] newValues = this.getValues();
        newValues = this.getField(index).add(this, index, newValues, amount);
        return new Partial(this, newValues);
    }

    public Partial withFieldAddWrapped(DurationFieldType fieldType, int amount) {
        int index = this.indexOfSupported(fieldType);
        if (amount == 0) {
            return this;
        }
        int[] newValues = this.getValues();
        newValues = this.getField(index).addWrapPartial(this, index, newValues, amount);
        return new Partial(this, newValues);
    }

    public Partial withPeriodAdded(ReadablePeriod period, int scalar) {
        if (period == null || scalar == 0) {
            return this;
        }
        int[] newValues = this.getValues();
        for (int i = 0; i < period.size(); ++i) {
            DurationFieldType fieldType = period.getFieldType(i);
            int index = this.indexOf(fieldType);
            if (index < 0) continue;
            newValues = this.getField(index).add(this, index, newValues, FieldUtils.safeMultiply(period.getValue(i), scalar));
        }
        return new Partial(this, newValues);
    }

    public Partial plus(ReadablePeriod period) {
        return this.withPeriodAdded(period, 1);
    }

    public Partial minus(ReadablePeriod period) {
        return this.withPeriodAdded(period, -1);
    }

    public Property property(DateTimeFieldType type) {
        return new Property(this, this.indexOfSupported(type));
    }

    public boolean isMatch(ReadableInstant instant) {
        long millis = DateTimeUtils.getInstantMillis(instant);
        Chronology chrono = DateTimeUtils.getInstantChronology(instant);
        for (int i = 0; i < this.iTypes.length; ++i) {
            int value = this.iTypes[i].getField(chrono).get(millis);
            if (value == this.iValues[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isMatch(ReadablePartial partial) {
        if (partial == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        for (int i = 0; i < this.iTypes.length; ++i) {
            int value = partial.get(this.iTypes[i]);
            if (value == this.iValues[i]) continue;
            return false;
        }
        return true;
    }

    public DateTimeFormatter getFormatter() {
        DateTimeFormatter[] f = this.iFormatter;
        if (f == null) {
            if (this.size() == 0) {
                return null;
            }
            f = new DateTimeFormatter[2];
            try {
                ArrayList<DateTimeFieldType> list = new ArrayList<DateTimeFieldType>(Arrays.asList(this.iTypes));
                f[0] = ISODateTimeFormat.forFields(list, true, false);
                if (list.size() == 0) {
                    f[1] = f[0];
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.iFormatter = f;
        }
        return f[0];
    }

    @Override
    public String toString() {
        DateTimeFormatter f1;
        DateTimeFormatter[] f = this.iFormatter;
        if (f == null) {
            this.getFormatter();
            f = this.iFormatter;
            if (f == null) {
                return this.toStringList();
            }
        }
        if ((f1 = f[1]) == null) {
            return this.toStringList();
        }
        return f1.print(this);
    }

    public String toStringList() {
        int size = this.size();
        StringBuilder buf = new StringBuilder(20 * size);
        buf.append('[');
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                buf.append(',').append(' ');
            }
            buf.append(this.iTypes[i].getName());
            buf.append('=');
            buf.append(this.iValues[i]);
        }
        buf.append(']');
        return buf.toString();
    }

    public String toString(String pattern) {
        if (pattern == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(pattern).print(this);
    }

    public String toString(String pattern, Locale locale) {
        if (pattern == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(pattern).withLocale(locale).print(this);
    }

    public static class Property
    extends AbstractPartialFieldProperty
    implements Serializable {
        private static final long serialVersionUID = 53278362873888L;
        private final Partial iPartial;
        private final int iFieldIndex;

        Property(Partial partial, int fieldIndex) {
            this.iPartial = partial;
            this.iFieldIndex = fieldIndex;
        }

        @Override
        public DateTimeField getField() {
            return this.iPartial.getField(this.iFieldIndex);
        }

        @Override
        protected ReadablePartial getReadablePartial() {
            return this.iPartial;
        }

        public Partial getPartial() {
            return this.iPartial;
        }

        @Override
        public int get() {
            return this.iPartial.getValue(this.iFieldIndex);
        }

        public Partial addToCopy(int valueToAdd) {
            int[] newValues = this.iPartial.getValues();
            newValues = this.getField().add(this.iPartial, this.iFieldIndex, newValues, valueToAdd);
            return new Partial(this.iPartial, newValues);
        }

        public Partial addWrapFieldToCopy(int valueToAdd) {
            int[] newValues = this.iPartial.getValues();
            newValues = this.getField().addWrapField(this.iPartial, this.iFieldIndex, newValues, valueToAdd);
            return new Partial(this.iPartial, newValues);
        }

        public Partial setCopy(int value) {
            int[] newValues = this.iPartial.getValues();
            newValues = this.getField().set(this.iPartial, this.iFieldIndex, newValues, value);
            return new Partial(this.iPartial, newValues);
        }

        public Partial setCopy(String text, Locale locale) {
            int[] newValues = this.iPartial.getValues();
            newValues = this.getField().set(this.iPartial, this.iFieldIndex, newValues, text, locale);
            return new Partial(this.iPartial, newValues);
        }

        public Partial setCopy(String text) {
            return this.setCopy(text, null);
        }

        public Partial withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }

        public Partial withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }
    }
}

