/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.chrono;

import com.google.appengine.repackaged.org.joda.time.DateTimeFieldType;
import com.google.appengine.repackaged.org.joda.time.DurationField;
import com.google.appengine.repackaged.org.joda.time.chrono.BasicChronology;
import com.google.appengine.repackaged.org.joda.time.field.FieldUtils;
import com.google.appengine.repackaged.org.joda.time.field.ImpreciseDateTimeField;

final class BasicWeekyearDateTimeField
extends ImpreciseDateTimeField {
    private static final long serialVersionUID = 6215066916806820644L;
    private static final long WEEK_53 = 31449600000L;
    private final BasicChronology iChronology;

    BasicWeekyearDateTimeField(BasicChronology chronology) {
        super(DateTimeFieldType.weekyear(), chronology.getAverageMillisPerYear());
        this.iChronology = chronology;
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    @Override
    public int get(long instant) {
        return this.iChronology.getWeekyear(instant);
    }

    @Override
    public long add(long instant, int years) {
        if (years == 0) {
            return instant;
        }
        return this.set(instant, this.get(instant) + years);
    }

    @Override
    public long add(long instant, long value) {
        return this.add(instant, FieldUtils.safeToInt(value));
    }

    @Override
    public long addWrapField(long instant, int years) {
        return this.add(instant, years);
    }

    @Override
    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        if (minuendInstant < subtrahendInstant) {
            return -this.getDifference(subtrahendInstant, minuendInstant);
        }
        int minuendWeekyear = this.get(minuendInstant);
        int subtrahendWeekyear = this.get(subtrahendInstant);
        long minuendRem = this.remainder(minuendInstant);
        long subtrahendRem = this.remainder(subtrahendInstant);
        if (subtrahendRem >= 31449600000L && this.iChronology.getWeeksInYear(minuendWeekyear) <= 52) {
            subtrahendRem -= 604800000L;
        }
        int difference = minuendWeekyear - subtrahendWeekyear;
        if (minuendRem < subtrahendRem) {
            --difference;
        }
        return difference;
    }

    @Override
    public long set(long instant, int year) {
        FieldUtils.verifyValueBounds(this, Math.abs(year), this.iChronology.getMinYear(), this.iChronology.getMaxYear());
        int thisWeekyear = this.get(instant);
        if (thisWeekyear == year) {
            return instant;
        }
        int thisDow = this.iChronology.getDayOfWeek(instant);
        int weeksInFromYear = this.iChronology.getWeeksInYear(thisWeekyear);
        int weeksInToYear = this.iChronology.getWeeksInYear(year);
        int maxOutWeeks = weeksInToYear < weeksInFromYear ? weeksInToYear : weeksInFromYear;
        int setToWeek = this.iChronology.getWeekOfWeekyear(instant);
        if (setToWeek > maxOutWeeks) {
            setToWeek = maxOutWeeks;
        }
        long workInstant = instant;
        int workWoyYear = this.get(workInstant = this.iChronology.setYear(workInstant, year));
        if (workWoyYear < year) {
            workInstant += 604800000L;
        } else if (workWoyYear > year) {
            workInstant -= 604800000L;
        }
        int currentWoyWeek = this.iChronology.getWeekOfWeekyear(workInstant);
        workInstant += (long)(setToWeek - currentWoyWeek) * 604800000L;
        workInstant = this.iChronology.dayOfWeek().set(workInstant, thisDow);
        return workInstant;
    }

    @Override
    public DurationField getRangeDurationField() {
        return null;
    }

    @Override
    public boolean isLeap(long instant) {
        return this.iChronology.getWeeksInYear(this.iChronology.getWeekyear(instant)) > 52;
    }

    @Override
    public int getLeapAmount(long instant) {
        return this.iChronology.getWeeksInYear(this.iChronology.getWeekyear(instant)) - 52;
    }

    @Override
    public DurationField getLeapDurationField() {
        return this.iChronology.weeks();
    }

    @Override
    public int getMinimumValue() {
        return this.iChronology.getMinYear();
    }

    @Override
    public int getMaximumValue() {
        return this.iChronology.getMaxYear();
    }

    @Override
    public long roundFloor(long instant) {
        instant = this.iChronology.weekOfWeekyear().roundFloor(instant);
        int wow = this.iChronology.getWeekOfWeekyear(instant);
        if (wow > 1) {
            instant -= 604800000L * (long)(wow - 1);
        }
        return instant;
    }

    @Override
    public long remainder(long instant) {
        return instant - this.roundFloor(instant);
    }

    private Object readResolve() {
        return this.iChronology.weekyear();
    }
}

