/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal;

import com.google.cloud.sql.jdbc.internal.BoundValue;
import com.google.cloud.sql.jdbc.internal.Exceptions;
import com.google.protos.cloud.sql.Client;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public final class Util {
    private static final String EMPTY_STRING = "";

    private Util() {
    }

    public static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String makeSafe(String string) {
        return string == null ? EMPTY_STRING : string;
    }

    public static <E> ArrayList<E> newArrayListWithCapacity(int initialArraySize) {
        return new ArrayList(initialArraySize);
    }

    public static <E> ArrayList<E> newArrayList(Collection<? extends E> collection) {
        return new ArrayList<E>(collection);
    }

    public static <E> ArrayList<E> newArrayList(E ... es) {
        return new ArrayList<E>(Arrays.asList(es));
    }

    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <K extends Comparable<? super K>, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <E extends Comparable<?>> TreeSet<E> newTreeSet(Iterable<? extends E> elements) {
        TreeSet<Comparable> set = new TreeSet<Comparable>();
        if (elements instanceof Collection) {
            set.addAll((Collection)elements);
        } else {
            for (Comparable e : elements) {
                set.add(e);
            }
        }
        return set;
    }

    public static <E extends Comparable<?>> HashSet<E> newHashSet(E ... es) {
        return new HashSet<E>(Arrays.asList(es));
    }

    public static String join(String separator, Iterable<?> parts) {
        try {
            return Util.appendTo(new StringBuilder(), separator, parts).toString();
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    public static <T> T checkNotNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static void checkArgument(boolean expression, String fieldName, Object value) throws SQLException {
        if (!expression) {
            throw Exceptions.newInvalidParameterException(fieldName, value);
        }
    }

    public static void checkParameter(boolean expression, String message, Object ... arguments) throws SQLException {
        if (!expression) {
            throw Exceptions.newInvalidParameterException(MessageFormat.format(message, arguments));
        }
    }

    private static <A extends Appendable> A appendTo(A appendable, String separator, Iterable<?> parts) throws IOException {
        if (appendable == null) {
            throw new NullPointerException("appendable can not be null");
        }
        Iterator<?> iterator = parts.iterator();
        if (iterator.hasNext()) {
            appendable.append(String.valueOf(iterator.next()));
            while (iterator.hasNext()) {
                appendable.append(separator);
                appendable.append(String.valueOf(iterator.next()));
            }
        }
        return appendable;
    }

    public static String toIntegerList(int[] ints) {
        if (ints != null && ints.length > 0) {
            ArrayList<String> typeStringList = Util.newArrayList();
            for (int type : ints) {
                typeStringList.add(Integer.toString(type));
            }
            return Util.join(",", typeStringList);
        }
        return null;
    }

    public static int getIntSafe(Integer integer) {
        return integer == null ? 0 : integer;
    }

    public static List<Client.BindVariableProto> toBindVariableProtos(List<BoundValue> boundValues) throws SQLException {
        ArrayList<Client.BindVariableProto> protos = Util.newArrayListWithCapacity(boundValues.size());
        int position = 1;
        for (BoundValue b : boundValues) {
            protos.add(b.toBindVariableProtoBuilder().setPosition(position++).build());
        }
        return protos;
    }

    public static List<Client.BindVariableProto> toNamedBindVariableProtos(Map<String, BoundValue> boundValues) throws SQLException {
        ArrayList<Client.BindVariableProto> protos = Util.newArrayListWithCapacity(boundValues.size());
        for (Map.Entry<String, BoundValue> e : boundValues.entrySet()) {
            protos.add(e.getValue().toBindVariableProtoBuilder().setName(e.getKey()).build());
        }
        return protos;
    }

    public static List<Client.BindVariableProto> toIndexedBindVariableProtos(Map<Integer, BoundValue> boundValues) throws SQLException {
        ArrayList<Integer> keys = Util.newArrayList(boundValues.keySet());
        Collections.sort(keys);
        ArrayList<Client.BindVariableProto> protos = Util.newArrayListWithCapacity(boundValues.size());
        int current = 1;
        for (Integer key : keys) {
            Util.checkParameter(key == current, "Bind parameter #{0} out of order.", key);
            protos.add(boundValues.get(key).toBindVariableProtoBuilder().setPosition(current++).build());
        }
        return protos;
    }

    public static Time convertTime(Time time, Calendar source, Calendar destination) throws SQLException {
        if (time == null) {
            return null;
        }
        if (source == null || destination == null) {
            return time;
        }
        return new Time(Util.convertTime(time.getTime(), (Calendar)source.clone(), (Calendar)destination.clone()));
    }

    public static Date convertTime(Date date, Calendar source, Calendar destination) throws SQLException {
        if (date == null) {
            return null;
        }
        if (source == null || destination == null) {
            return date;
        }
        return new Date(Util.convertTime(date.getTime(), (Calendar)source.clone(), (Calendar)destination.clone()));
    }

    public static Timestamp convertTime(Timestamp timestamp, Calendar source, Calendar destination) throws SQLException {
        if (timestamp == null) {
            return null;
        }
        if (source == null || destination == null) {
            return timestamp;
        }
        return new Timestamp(Util.convertTime(timestamp.getTime(), (Calendar)source.clone(), (Calendar)destination.clone()));
    }

    private static long convertTime(long time, Calendar source, Calendar destination) throws SQLException {
        Util.checkParameter(source.getClass().isInstance(destination), "source and destination calendars must be the same.", new Object[0]);
        source.setTimeInMillis(time);
        destination.set(1, source.get(1));
        destination.set(2, source.get(2));
        destination.set(5, source.get(5));
        destination.set(11, source.get(11));
        destination.set(12, source.get(12));
        destination.set(13, source.get(13));
        destination.set(14, source.get(14));
        return destination.getTimeInMillis();
    }

    public static BigDecimal createBigDecimalWithScale(BigDecimal b, int scale) throws SQLException {
        try {
            return b.setScale(scale);
        }
        catch (ArithmeticException e) {
            try {
                return b.setScale(scale, 4);
            }
            catch (ArithmeticException scaledE) {
                throw Exceptions.newInvalidParameterException("scale", scale);
            }
        }
    }
}

