/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.mail;

import javax.annotation.Nullable;
import javax.mail.internet.MimeMessage;

public final class BounceNotification {
    private final MimeMessage rawMessage;
    private final Details original;
    private final Details notification;

    BounceNotification(@Nullable MimeMessage rawMessage, @Nullable Details original, @Nullable Details notification) {
        this.rawMessage = rawMessage;
        this.original = original;
        this.notification = notification;
    }

    @Nullable
    public final MimeMessage getRawMessage() {
        return this.rawMessage;
    }

    @Nullable
    public final Details getOriginal() {
        return this.original;
    }

    @Nullable
    public final Details getNotification() {
        return this.notification;
    }

    static class BounceNotificationBuilder {
        private MimeMessage rawMessage;
        private Details original;
        private Details notification;

        BounceNotificationBuilder() {
        }

        public BounceNotification build() {
            return new BounceNotification(this.rawMessage, this.original, this.notification);
        }

        public BounceNotificationBuilder withRawMessage(MimeMessage rawMessage) {
            this.rawMessage = rawMessage;
            return this;
        }

        public BounceNotificationBuilder withOriginal(Details original) {
            this.original = original;
            return this;
        }

        public BounceNotificationBuilder withNotification(Details notification) {
            this.notification = notification;
            return this;
        }
    }

    static class DetailsBuilder {
        private String from;
        private String to;
        private String cc;
        private String bcc;
        private String subject;
        private String text;

        DetailsBuilder() {
        }

        public Details build() {
            return new Details(this.from, this.to, this.cc, this.bcc, this.subject, this.text);
        }

        public DetailsBuilder withFrom(@Nullable String from) {
            this.from = from;
            return this;
        }

        public DetailsBuilder withTo(@Nullable String to) {
            this.to = to;
            return this;
        }

        public DetailsBuilder withCc(@Nullable String cc) {
            this.cc = cc;
            return this;
        }

        public DetailsBuilder withBcc(@Nullable String bcc) {
            this.bcc = bcc;
            return this;
        }

        public DetailsBuilder withSubject(@Nullable String subject) {
            this.subject = subject;
            return this;
        }

        public DetailsBuilder withText(@Nullable String text) {
            this.text = text;
            return this;
        }
    }

    public static final class Details {
        private final String from;
        private final String to;
        private final String cc;
        private final String bcc;
        private final String subject;
        private final String text;

        private Details(@Nullable String from, @Nullable String to, @Nullable String cc, @Nullable String bcc, @Nullable String subject, @Nullable String text) {
            this.from = from;
            this.to = to;
            this.cc = cc;
            this.bcc = bcc;
            this.subject = subject;
            this.text = text;
        }

        @Nullable
        public String getFrom() {
            return this.from;
        }

        @Nullable
        public String getTo() {
            return this.to;
        }

        @Nullable
        public String getCc() {
            return this.cc;
        }

        @Nullable
        public String getBcc() {
            return this.bcc;
        }

        @Nullable
        public String getSubject() {
            return this.subject;
        }

        @Nullable
        public String getText() {
            return this.text;
        }
    }
}

