/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.taskqueue;

import com.google.apphosting.api.ApiProxy;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DeferredTaskContext {
    public static final String RUNNABLE_TASK_CONTENT_TYPE = "application/x-binary-app-engine-java-runnable-task";
    public static final String DEFAULT_DEFERRED_URL = "/_ah/queue/__deferred__";
    static final String DEFERRED_TASK_SERVLET_KEY = String.valueOf(DeferredTaskContext.class.getName()).concat(".httpServlet");
    static final String DEFERRED_TASK_REQUEST_KEY = String.valueOf(DeferredTaskContext.class.getName()).concat(".httpServletRequest");
    static final String DEFERRED_TASK_RESPONSE_KEY = String.valueOf(DeferredTaskContext.class.getName()).concat(".httpServletResponse");
    static final String DEFERRED_DO_NOT_RETRY_KEY = String.valueOf(DeferredTaskContext.class.getName()).concat(".doNotRetry");
    static final String DEFERRED_MARK_RETRY_KEY = String.valueOf(DeferredTaskContext.class.getName()).concat(".markRetry");

    public static HttpServlet getCurrentServlet() {
        Map<String, Object> attributes = DeferredTaskContext.getCurrentEnvironmentOrThrow().getAttributes();
        return (HttpServlet)attributes.get(DEFERRED_TASK_SERVLET_KEY);
    }

    public static HttpServletRequest getCurrentRequest() {
        Map<String, Object> attributes = DeferredTaskContext.getCurrentEnvironmentOrThrow().getAttributes();
        return (HttpServletRequest)attributes.get(DEFERRED_TASK_REQUEST_KEY);
    }

    public static HttpServletResponse getCurrentResponse() {
        Map<String, Object> attributes = DeferredTaskContext.getCurrentEnvironmentOrThrow().getAttributes();
        return (HttpServletResponse)attributes.get(DEFERRED_TASK_RESPONSE_KEY);
    }

    public static void setDoNotRetry(boolean value) {
        Map<String, Object> attributes = DeferredTaskContext.getCurrentEnvironmentOrThrow().getAttributes();
        attributes.put(DEFERRED_DO_NOT_RETRY_KEY, value);
    }

    public static void markForRetry() {
        Map<String, Object> attributes = DeferredTaskContext.getCurrentEnvironmentOrThrow().getAttributes();
        attributes.put(DEFERRED_MARK_RETRY_KEY, true);
    }

    private static ApiProxy.Environment getCurrentEnvironmentOrThrow() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment == null) {
            throw new IllegalStateException("Operation not allowed in a thread that is neither the original request thread nor a thread created by ThreadManager");
        }
        return environment;
    }

    private DeferredTaskContext() {
    }
}

