/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.html;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.escape.CharEscaperBuilder;
import com.google.appengine.repackaged.com.google.common.escape.Escaper;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;

@GoogleInternal
@GwtIncompatible
public final class HtmlEscaper {
    private final boolean convertDoubleNewlineToParagraphTag;
    private final Escaper singleCharEscaper;

    private HtmlEscaper(Builder builder) {
        this.convertDoubleNewlineToParagraphTag = builder.convertDoubleLineBreaksToTags;
        CharEscaperBuilder escaperBuilder = new CharEscaperBuilder();
        if (builder.convertSingleLineBreaksToTags) {
            escaperBuilder.addEscape('\n', "<br>");
        }
        if (builder.escapeReservedHtmlChars) {
            escaperBuilder.addEscape('\'', "&#39;").addEscape('\"', "&quot;").addEscape('&', "&amp;").addEscape('<', "&lt;").addEscape('>', "&gt;");
        }
        if (builder.convertMsExtensionsToEntities) {
            escaperBuilder.addEscape('\u0082', "&lsquor;").addEscape('\u0083', "&fnof;").addEscape('\u0084', "&ldquor;").addEscape('\u0085', "&hellip;").addEscape('\u0086', "&dagger;").addEscape('\u0087', "&Dagger;").addEscape('\u0089', "&permil;").addEscape('\u008a', "&Scaron;").addEscape('\u008b', "&lsqauo;").addEscape('\u008c', "&OElig;").addEscape('\u0091', "&lsquo;").addEscape('\u0092', "&rsquo;").addEscape('\u0093', "&ldquo;").addEscape('\u0094', "&rdquo;").addEscape('\u0095', "&bull;").addEscape('\u0096', "&ndash;").addEscape('\u0097', "&mdash;").addEscape('\u0098', "&tilde;").addEscape('\u0099', "&trade;").addEscape('\u009a', "&scaron;").addEscape('\u009b', "&rsaquo;").addEscape('\u009c', "&oelig;").addEscape('\u009f', "&Yuml;");
        }
        if (builder.convertLatin1ToEntities) {
            for (char ch = '\u00a0'; ch <= '\u00ff'; ch = (char)(ch + '\u0001')) {
                String string = Integer.toString(ch);
                escaperBuilder.addEscape(ch, new StringBuilder(3 + String.valueOf(string).length()).append("&#").append(string).append(";").toString());
            }
        }
        this.singleCharEscaper = escaperBuilder.toEscaper();
    }

    public String escape(String plainText) {
        StringBuilder out = new StringBuilder();
        this.escapeTo(plainText, out);
        return out.toString();
    }

    public void escapeTo(String plainText, StringBuilder out) {
        int pos = 0;
        if (this.convertDoubleNewlineToParagraphTag) {
            int doubleNewlinePos;
            while ((doubleNewlinePos = plainText.indexOf("\n\n", pos)) >= 0) {
                this.escapeSingleChars(plainText.substring(pos, doubleNewlinePos), out);
                out.append("<p>");
                pos = doubleNewlinePos + 2;
            }
        }
        this.escapeSingleChars(plainText.substring(pos, plainText.length()), out);
    }

    private void escapeSingleChars(String text, StringBuilder out) {
        out.append(this.singleCharEscaper.escape(text));
    }

    public static class Builder {
        private boolean escapeReservedHtmlChars = true;
        private boolean convertSingleLineBreaksToTags = false;
        private boolean convertDoubleLineBreaksToTags = false;
        private boolean convertLatin1ToEntities = false;
        private boolean convertMsExtensionsToEntities = false;

        @CanIgnoreReturnValue
        public Builder escapeReservedHtmlChars(boolean escape) {
            this.escapeReservedHtmlChars = escape;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder convertSingleLineBreaksToTags(boolean convert) {
            this.convertSingleLineBreaksToTags = convert;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder convertDoubleLineBreaksToTags(boolean convert) {
            this.convertDoubleLineBreaksToTags = convert;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder convertLineBreaksToTags(boolean convert) {
            this.convertSingleLineBreaksToTags = convert;
            this.convertDoubleLineBreaksToTags = convert;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder convertLatin1ToEntities(boolean convert) {
            this.convertLatin1ToEntities = convert;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder convertMsExtensionsToEntities(boolean convert) {
            this.convertMsExtensionsToEntities = convert;
            return this;
        }

        public HtmlEscaper create() {
            return new HtmlEscaper(this);
        }
    }
}

