/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal;

import com.google.cloud.sql.jdbc.internal.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class SqlState {
    static final int PUBLIC_ERROR_CODE_START = 1000;
    private static final Map<Integer, String> CODE_TO_SQLSTATE_MAP = Collections.unmodifiableMap(SqlState.newCodeToSqlStateMap());

    private static Map<Integer, String> newCodeToSqlStateMap() {
        HashMap<Integer, String> result = Util.newHashMap();
        result.put(1001, "22000");
        result.put(1003, "28000");
        result.put(1004, "08004");
        result.put(1005, "22023");
        result.put(1006, "HY000");
        result.put(1007, "08006");
        result.put(1008, "24000");
        result.put(1009, "42000");
        result.put(1010, "42000");
        result.put(1020, "42000");
        result.put(1030, "0A100");
        result.put(1031, "0A000");
        result.put(1036, "08002");
        return result;
    }

    private SqlState() {
    }

    public static String forOpenConnectionError(int errorCode) {
        if (errorCode == 1003) {
            return CODE_TO_SQLSTATE_MAP.get(errorCode);
        }
        return "08006";
    }

    public static String forError(int errorCode) {
        if (errorCode <= 1000) {
            return "";
        }
        String sqlState = CODE_TO_SQLSTATE_MAP.get(errorCode);
        if (sqlState != null) {
            return sqlState;
        }
        return String.format("R%04X", errorCode);
    }
}

