/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.images;

import com.google.appengine.api.images.ImagesServicePb;
import com.google.appengine.api.images.Transform;

final class Resize
extends Transform {
    private static final long serialVersionUID = -889209644904728094L;
    private final int width;
    private final int height;
    private final boolean cropToFit;
    private final float cropOffsetX;
    private final float cropOffsetY;
    private final boolean allowStretch;

    Resize(int width, int height, boolean allowStretch) {
        this(width, height, false, 0.0f, 0.0f, allowStretch);
    }

    Resize(int width, int height, boolean cropToFit, float cropOffsetX, float cropOffsetY) {
        this(width, height, cropToFit, cropOffsetX, cropOffsetY, false);
    }

    Resize(int width, int height, boolean cropToFit, float cropOffsetX, float cropOffsetY, boolean allowStretch) {
        if (width > 4000 || height > 4000) {
            throw new IllegalArgumentException("width and height must be <= 4000");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("width and height must be >= 0");
        }
        if (width == 0 && height == 0) {
            throw new IllegalArgumentException("width and height must not both be == 0");
        }
        if (cropToFit) {
            if (width == 0 || height == 0) {
                throw new IllegalArgumentException("neither of width and height can be == 0 with crop to fit enabled");
            }
            this.checkCropArgument(cropOffsetX);
            this.checkCropArgument(cropOffsetY);
        }
        if (allowStretch && (width == 0 || height == 0)) {
            throw new IllegalArgumentException("Resize requests with allowStretch as true require that both width and hight are non zero");
        }
        this.width = width;
        this.height = height;
        this.cropToFit = cropToFit;
        this.cropOffsetX = cropOffsetX;
        this.cropOffsetY = cropOffsetY;
        this.allowStretch = allowStretch;
    }

    @Override
    void apply(ImagesServicePb.ImagesTransformRequest.Builder request) {
        request.addTransform(ImagesServicePb.Transform.newBuilder().setWidth(this.width).setHeight(this.height).setCropToFit(this.cropToFit).setCropOffsetX(this.cropOffsetX).setCropOffsetY(this.cropOffsetY).setAllowStretch(this.allowStretch));
    }

    private void checkCropArgument(float arg) {
        if ((double)arg < 0.0) {
            throw new IllegalArgumentException("Crop offsets must be >= 0");
        }
        if ((double)arg > 1.0) {
            throw new IllegalArgumentException("Crop offsets must be <= 1");
        }
    }
}

