/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.trace;

import com.google.appengine.api.labs.trace.Span;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.CloudTrace;
import com.google.apphosting.api.CloudTraceContext;
import javax.annotation.Nullable;

class SpanImpl
extends Span {
    private final CloudTraceContext parentContext;
    private final CloudTraceContext context;

    SpanImpl(@Nullable CloudTraceContext parent, String name) {
        this.parentContext = parent;
        this.context = this.parentContext == null || !this.parentContext.isTraceEnabled() ? null : CloudTrace.startChildSpan((ApiProxy.Environment)ApiProxy.getCurrentEnvironment(), (CloudTraceContext)this.parentContext, (String)name);
    }

    SpanImpl(String name) {
        this(CloudTrace.getCurrentContext((ApiProxy.Environment)ApiProxy.getCurrentEnvironment()), name);
    }

    @Override
    public Span startChildSpan(String name) {
        return new SpanImpl(this.context, name);
    }

    @Override
    public Span setLabel(String key, String value) {
        if (this.context == null || !this.context.isTraceEnabled()) {
            return this;
        }
        CloudTrace.setLabel((ApiProxy.Environment)ApiProxy.getCurrentEnvironment(), (CloudTraceContext)this.context, (String)key, (String)value);
        return this;
    }

    @Override
    public void endSpan() {
        if (this.context == null || !this.context.isTraceEnabled()) {
            return;
        }
        CloudTrace.endSpan((ApiProxy.Environment)ApiProxy.getCurrentEnvironment(), (CloudTraceContext)this.context, (CloudTraceContext)this.parentContext);
    }

    @Override
    public void close() {
        this.endSpan();
    }

    @Override
    @Nullable
    public CloudTraceContext getParentContext() {
        return this.parentContext;
    }

    @Override
    @Nullable
    public CloudTraceContext getContext() {
        return this.context;
    }
}

