/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus.query;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultIterable;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.google.appengine.api.datastore.QueryResultList;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.api.datastore.ShortBlob;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.datanucleus.BigDecimals;
import com.google.appengine.datanucleus.DatastoreExceptionTranslator;
import com.google.appengine.datanucleus.DatastoreManager;
import com.google.appengine.datanucleus.DatastoreServiceFactoryInternal;
import com.google.appengine.datanucleus.DatastoreTransaction;
import com.google.appengine.datanucleus.EntityUtils;
import com.google.appengine.datanucleus.FetchFieldManager;
import com.google.appengine.datanucleus.MetaDataUtils;
import com.google.appengine.datanucleus.PrimitiveArrays;
import com.google.appengine.datanucleus.Utils;
import com.google.appengine.datanucleus.mapping.DatastoreTable;
import com.google.appengine.datanucleus.query.JoinHelper;
import com.google.appengine.datanucleus.query.QueryData;
import com.google.appengine.datanucleus.query.QueryEntityPKFetchFieldManager;
import com.google.appengine.datanucleus.query.RuntimeExceptionWrappingIterable;
import com.google.appengine.datanucleus.query.RuntimeExceptionWrappingQueryResultIterator;
import com.google.appengine.datanucleus.query.StreamingQueryResult;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusFatalUserException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.Relation;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.JoinExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.mapping.EmbeddedMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class DatastoreQuery
implements Serializable {
    static final Expression.Operator GROUP_BY_OP = new Expression.Operator("GROUP BY", Integer.MAX_VALUE);
    static final Expression.Operator HAVING_OP = new Expression.Operator("HAVING", Integer.MAX_VALUE);
    static final Expression.Operator JOIN_OP = new Expression.Operator("JOIN", Integer.MAX_VALUE);
    static final Set<Expression.Operator> UNSUPPORTED_OPERATORS = Utils.newHashSet(Expression.OP_ADD, Expression.OP_COM, Expression.OP_CONCAT, Expression.OP_DIV, Expression.OP_IS, Expression.OP_ISNOT, Expression.OP_LIKE, Expression.OP_MOD, Expression.OP_NEG, Expression.OP_MUL, Expression.OP_NOT, Expression.OP_SUB);
    private static final Map<Expression.Operator, Query.FilterOperator> DATANUCLEUS_OP_TO_APPENGINE_OP = DatastoreQuery.buildNewOpMap();
    boolean inmemoryWhenUnsupported = true;
    final AbstractJavaQuery query;
    boolean filterComplete = true;
    boolean orderComplete = true;
    public static NowProvider NOW_PROVIDER = new NowProvider(){

        @Override
        public Date now() {
            return new Date();
        }
    };
    private transient com.google.appengine.api.datastore.Query latestDatastoreQuery;

    private static Map<Expression.Operator, Query.FilterOperator> buildNewOpMap() {
        HashMap<Expression.Operator, Query.FilterOperator> map = new HashMap<Expression.Operator, Query.FilterOperator>();
        map.put((Expression.Operator)Expression.OP_EQ, Query.FilterOperator.EQUAL);
        map.put((Expression.Operator)Expression.OP_GT, Query.FilterOperator.GREATER_THAN);
        map.put((Expression.Operator)Expression.OP_GTEQ, Query.FilterOperator.GREATER_THAN_OR_EQUAL);
        map.put((Expression.Operator)Expression.OP_LT, Query.FilterOperator.LESS_THAN);
        map.put((Expression.Operator)Expression.OP_LTEQ, Query.FilterOperator.LESS_THAN_OR_EQUAL);
        map.put((Expression.Operator)Expression.OP_NOTEQ, Query.FilterOperator.NOT_EQUAL);
        return map;
    }

    public DatastoreQuery(AbstractJavaQuery query) {
        this.query = query;
    }

    public boolean isFilterComplete() {
        return this.filterComplete;
    }

    public boolean isOrderComplete() {
        return this.orderComplete;
    }

    public QueryData compile(QueryCompilation compilation, Map<String, ?> parameters, boolean inmemoryWhenUnsupported) {
        this.inmemoryWhenUnsupported = inmemoryWhenUnsupported;
        if (this.query.getCandidateClass() == null) {
            throw new NucleusFatalUserException("Candidate class could not be found: " + this.query.getSingleStringQuery());
        }
        final ClassLoaderResolver clr = this.getClassLoaderResolver();
        final AbstractClassMetaData acmd = this.getMetaDataManager().getMetaDataForClass(this.query.getCandidateClass(), clr);
        if (acmd == null) {
            throw new NucleusFatalUserException("No meta data for " + this.query.getCandidateClass().getName() + ".  Perhaps you need to run the enhancer on this class?");
        }
        this.getStoreManager().validateMetaDataForClass(acmd);
        if (compilation.getSubqueryAliases() != null && compilation.getSubqueryAliases().length > 0) {
            throw new NucleusUserException("Subqueries not supported by datastore. Try evaluating them in-memory");
        }
        ResultType resultType = this.validateResultExpression(compilation, acmd);
        Utils.Function<Entity, Object> resultTransformer = resultType == ResultType.KEYS_ONLY ? new Utils.Function<Entity, Object>(){

            @Override
            public Object apply(Entity from) {
                return DatastoreQuery.entityToPojoPrimaryKey(from, acmd, clr, DatastoreQuery.this.getExecutionContext());
            }
        } : new Utils.Function<Entity, Object>(){

            @Override
            public Object apply(Entity from) {
                FetchPlan fp = DatastoreQuery.this.query.getFetchPlan();
                return EntityUtils.entityToPojo(from, acmd, clr, DatastoreQuery.this.getExecutionContext(), DatastoreQuery.this.query.getIgnoreCache(), fp);
            }
        };
        DatastoreTable table = this.getStoreManager().getDatastoreClass(acmd.getFullClassName(), clr);
        String kind = table.getIdentifier().getIdentifierName();
        QueryData qd = new QueryData(parameters, acmd, table, compilation, new com.google.appengine.api.datastore.Query(kind), resultType, resultTransformer);
        if (compilation.getExprFrom() != null) {
            for (Expression fromExpr : compilation.getExprFrom()) {
                this.processFromExpression(qd, fromExpr);
            }
        }
        this.addDiscriminator(qd, clr);
        this.addMultitenancyDiscriminator(qd);
        this.addFilters(qd);
        this.addSorts(qd);
        if (qd.batchGetKeys != null && qd.primaryDatastoreQuery.getFilterPredicates().size() == 1 && qd.primaryDatastoreQuery.getSortPredicates().isEmpty()) {
            qd.type = QueryData.QueryType.BATCH_GET;
        } else if (qd.joinQuery != null) {
            qd.type = QueryData.QueryType.JOIN;
        } else {
            qd.type = QueryData.QueryType.NORMAL;
            if (qd.resultType == ResultType.KEYS_ONLY || this.isBulkDelete()) {
                qd.primaryDatastoreQuery.setKeysOnly();
            }
        }
        return qd;
    }

    public Object performExecute(QueryData qd) {
        QueryResultIterable entityIterable;
        Map extensions;
        DatastoreServiceConfig config = this.getStoreManager().getDefaultDatastoreServiceConfigForReads();
        if (this.query.getDatastoreReadTimeoutMillis() > 0) {
            config.deadline((double)(this.query.getDatastoreReadTimeoutMillis() / 1000));
        }
        if ((extensions = this.query.getExtensions()) != null && extensions.get("datanucleus.appengine.datastoreReadConsistency") != null) {
            config.readPolicy(new ReadPolicy(ReadPolicy.Consistency.valueOf((String)((String)extensions.get("datanucleus.appengine.datastoreReadConsistency")))));
        }
        DatastoreService ds = DatastoreServiceFactoryInternal.getDatastoreService(config);
        if (qd.type == QueryData.QueryType.BATCH_GET) {
            return this.executeBatchGetQuery(ds, qd);
        }
        if (qd.type == QueryData.QueryType.JOIN) {
            FetchOptions opts = this.buildFetchOptions(this.query.getRangeFromIncl(), this.query.getRangeToExcl());
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)("Executing join query in datastore for " + this.query.toString()));
            }
            if (this.getExecutionContext().getStatistics() != null) {
                this.getExecutionContext().getStatistics().incrementNumReads();
            }
            Iterable<Entity> entityIterable2 = new JoinHelper().executeJoinQuery(qd, this, ds, opts);
            return this.wrapEntityQueryResult(entityIterable2, qd.resultTransformer, ds, null);
        }
        this.latestDatastoreQuery = qd.primaryDatastoreQuery;
        Transaction txn = null;
        if (extensions == null || !extensions.containsKey("gae.exclude-query-from-txn") || !((Boolean)extensions.get("gae.exclude-query-from-txn")).booleanValue()) {
            txn = qd.primaryDatastoreQuery.getAncestor() != null ? ds.getCurrentTransaction(null) : null;
        }
        PreparedQuery preparedQuery = ds.prepare(txn, qd.primaryDatastoreQuery);
        FetchOptions opts = this.buildFetchOptions(this.query.getRangeFromIncl(), this.query.getRangeToExcl());
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Executing query in datastore for " + this.query.toString()));
        }
        if (this.getExecutionContext().getStatistics() != null) {
            this.getExecutionContext().getStatistics().incrementNumReads();
        }
        Cursor endCursor = null;
        if (opts != null) {
            if (opts.getLimit() != null) {
                QueryResultList entities = preparedQuery.asQueryResultList(opts);
                endCursor = entities.getCursor();
                entityIterable = entities;
            } else {
                entityIterable = preparedQuery.asQueryResultIterable(opts);
            }
        } else {
            entityIterable = preparedQuery.asQueryResultIterable();
        }
        return this.wrapEntityQueryResult((Iterable<Entity>)entityIterable, qd.resultTransformer, ds, endCursor);
    }

    private Object executeBatchGetQuery(DatastoreService ds, QueryData qd) {
        Transaction innerTxn;
        DatastoreTransaction txn = this.getStoreManager().getDatastoreTransaction(this.getExecutionContext());
        Transaction transaction = innerTxn = txn == null ? null : txn.getInnerTxn();
        if (this.isBulkDelete()) {
            Set<Object> keysToDelete = qd.batchGetKeys;
            Map extensions = this.query.getExtensions();
            if (extensions != null && extensions.containsKey("gae.slow-but-more-accurate-jpql-delete-query") && ((Boolean)extensions.get("gae.slow-but-more-accurate-jpql-delete-query")).booleanValue()) {
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("Performing batch get for keys " + StringUtils.collectionToString(qd.batchGetKeys)));
                }
                if (this.getExecutionContext().getStatistics() != null) {
                    this.getExecutionContext().getStatistics().incrementNumReads();
                }
                Map getResult = ds.get(innerTxn, qd.batchGetKeys);
                keysToDelete = getResult.keySet();
            }
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)("Deleting entities with keys " + StringUtils.collectionToString(keysToDelete)));
            }
            if (this.getExecutionContext().getStatistics() != null) {
                this.getExecutionContext().getStatistics().incrementNumWrites();
            }
            ds.delete(innerTxn, keysToDelete);
            return (long)keysToDelete.size();
        }
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Performing batch get for keys " + StringUtils.collectionToString(qd.batchGetKeys)));
        }
        if (this.getExecutionContext().getStatistics() != null) {
            this.getExecutionContext().getStatistics().incrementNumReads();
        }
        Map entityMap = ds.get(innerTxn, qd.batchGetKeys);
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Key key : qd.batchGetKeys) {
            Entity entity = (Entity)entityMap.get(key);
            if (entity == null) continue;
            entities.add(entity);
        }
        return DatastoreQuery.newStreamingQueryResultForEntities(entities, qd.resultTransformer, null, this.query);
    }

    private Object wrapEntityQueryResult(Iterable<Entity> entities, Utils.Function<Entity, Object> resultTransformer, DatastoreService ds, Cursor endCursor) {
        if (this.isBulkDelete()) {
            ArrayList<Object> keysToDelete = Utils.newArrayList(new Object[0]);
            for (Entity e : entities) {
                keysToDelete.add(e.getKey());
            }
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)("Deleting entities with keys " + StringUtils.collectionToString(keysToDelete)));
            }
            if (this.getExecutionContext().getStatistics() != null) {
                this.getExecutionContext().getStatistics().incrementNumWrites();
            }
            ds.delete(ds.getCurrentTransaction(null), keysToDelete);
            return (long)keysToDelete.size();
        }
        return DatastoreQuery.newStreamingQueryResultForEntities(entities, resultTransformer, endCursor, this.query);
    }

    public static List<?> newStreamingQueryResultForEntities(Iterable<Entity> entities, Utils.Function<Entity, Object> resultTransformer, Cursor endCursor, AbstractJavaQuery query) {
        final ApiAdapter api = query.getExecutionContext().getApiAdapter();
        RuntimeExceptionWrappingIterable iterable = entities instanceof QueryResultIterable ? new RuntimeExceptionWrappingIterable(api, (Iterable)((QueryResultIterable)entities)){

            @Override
            Iterator<Entity> newIterator(Iterator<Entity> innerIter) {
                return new RuntimeExceptionWrappingQueryResultIterator(api, this, (QueryResultIterator<Entity>)((QueryResultIterator)innerIter));
            }
        } : new RuntimeExceptionWrappingIterable(api, entities);
        return new StreamingQueryResult((Query)query, iterable, resultTransformer, endCursor);
    }

    FetchOptions buildFetchOptions(long fromInclNo, long toExclNo) {
        FetchPlan fetchPlan;
        Integer fetchSize;
        FetchOptions opts = null;
        Integer offset = null;
        if (fromInclNo != 0L && fromInclNo != Long.MAX_VALUE) {
            offset = (int)Math.min(Integer.MAX_VALUE, fromInclNo);
            opts = FetchOptions.Builder.withOffset((int)offset);
        }
        if (toExclNo != Long.MAX_VALUE) {
            int intExclNo = (int)Math.min(Integer.MAX_VALUE, toExclNo);
            if (opts == null) {
                opts = FetchOptions.Builder.withLimit((int)intExclNo);
            } else {
                opts.limit(intExclNo - offset);
            }
        }
        Cursor cursor = null;
        Object obj = this.query.getExtension("gae.query.cursor");
        if (obj != null) {
            cursor = obj instanceof Cursor ? (Cursor)obj : Cursor.fromWebSafeString((String)((String)obj));
        }
        if (cursor != null) {
            if (opts == null) {
                opts = FetchOptions.Builder.withStartCursor((Cursor)cursor);
            } else {
                opts.startCursor(cursor);
            }
        }
        if ((fetchSize = Integer.valueOf((fetchPlan = this.query.getFetchPlan()).getFetchSize())) != 0) {
            if (fetchSize == -1) {
                fetchSize = Integer.MAX_VALUE;
            }
        } else {
            fetchSize = null;
        }
        if (fetchSize != null) {
            if (opts == null) {
                opts = FetchOptions.Builder.withChunkSize((int)fetchSize);
            } else {
                opts.chunkSize(fetchSize.intValue());
            }
        }
        return opts;
    }

    private static Object entityToPojoPrimaryKey(final Entity entity, final AbstractClassMetaData acmd, ClassLoaderResolver clr, ExecutionContext ec) {
        FieldValues fv = new FieldValues(){

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(acmd.getPKMemberPositions(), (FieldManager)new FetchFieldManager(op, entity));
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        };
        Object id = null;
        Class cls = clr.classForName(acmd.getFullClassName());
        if (acmd.getIdentityType() == IdentityType.APPLICATION) {
            QueryEntityPKFetchFieldManager fm = new QueryEntityPKFetchFieldManager(acmd, entity);
            id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)acmd, (Class)cls, (boolean)true, (FieldManager)fm);
        } else if (acmd.getIdentityType() == IdentityType.DATASTORE) {
            Key key = entity.getKey();
            id = key.getName() != null ? OIDFactory.getInstance((NucleusContext)ec.getNucleusContext(), (String)key.getName()) : OIDFactory.getInstance((NucleusContext)ec.getNucleusContext(), (long)key.getId());
        }
        return ec.findObject(id, fv, cls, false, false);
    }

    private ResultType validateResultExpression(QueryCompilation compilation, AbstractClassMetaData acmd) {
        if (compilation.getExprResult() == null) {
            return ResultType.ENTITY;
        }
        boolean keysOnly = true;
        for (Expression resultExpr : compilation.getExprResult()) {
            if (resultExpr instanceof InvokeExpression) {
                InvokeExpression invokeExpr = (InvokeExpression)resultExpr;
                if (invokeExpr.getOperation().toLowerCase().equals("count")) continue;
                keysOnly = false;
                continue;
            }
            if (resultExpr instanceof PrimaryExpression) {
                PrimaryExpression primaryExpr = (PrimaryExpression)resultExpr;
                if (primaryExpr.getId().equals(compilation.getCandidateAlias())) continue;
                AbstractMemberMetaData ammd = this.getMemberMetaDataForTuples(acmd, this.getTuples(primaryExpr, compilation.getCandidateAlias()));
                if (ammd == null) {
                    throw this.noMetaDataException(primaryExpr.getId(), acmd.getFullClassName());
                }
                if (ammd.isPrimaryKey()) continue;
                keysOnly = false;
                continue;
            }
            keysOnly = false;
        }
        if (keysOnly) {
            NucleusLogger.GENERAL.info((Object)">> query is keysonly");
        }
        return keysOnly ? ResultType.KEYS_ONLY : ResultType.ENTITY;
    }

    private void processFromExpression(QueryData qd, Expression expr) {
        if (expr instanceof JoinExpression) {
            JoinExpression joinExpr = (JoinExpression)expr;
            if (joinExpr.getType() != JoinExpression.JoinType.JOIN_INNER && joinExpr.getType() != JoinExpression.JoinType.JOIN_INNER_FETCH) {
                throw new UnsupportedDatastoreFeatureException("Cannot fulfill outer join queries.");
            }
            qd.joinOrderExpression = this.createJoinOrderExpression(joinExpr.getPrimaryExpression());
        }
        if (expr.getLeft() != null) {
            this.processFromExpression(qd, expr.getLeft());
        }
        if (expr.getRight() != null) {
            this.processFromExpression(qd, expr.getRight());
        }
    }

    private void addSorts(QueryData qd) {
        Expression[] orderBys = qd.compilation.getExprOrdering();
        if (orderBys == null) {
            return;
        }
        try {
            for (Expression expr : orderBys) {
                OrderExpression orderExpr = (OrderExpression)expr;
                Query.SortDirection dir = DatastoreQuery.getSortDirection(orderExpr);
                String sortProp = this.getSortProperty(qd, orderExpr);
                qd.primaryDatastoreQuery.addSort(sortProp, dir);
            }
        }
        catch (NucleusException ne) {
            if (this.inmemoryWhenUnsupported) {
                this.orderComplete = false;
            }
            throw ne;
        }
    }

    private static Query.SortDirection getSortDirection(OrderExpression oe) {
        return oe.getSortOrder() == null || oe.getSortOrder().equals("ascending") ? Query.SortDirection.ASCENDING : Query.SortDirection.DESCENDING;
    }

    String getSortProperty(QueryData qd, OrderExpression orderExpr) {
        AbstractMemberMetaData ammd;
        PrimaryExpression left = (PrimaryExpression)orderExpr.getLeft();
        AbstractClassMetaData acmd = qd.acmd;
        List<String> tuples = this.getTuples(left, qd.compilation.getCandidateAlias());
        if (this.isJoin(left.getLeft(), tuples)) {
            acmd = this.getJoinClassMetaData(left.getLeft(), tuples, qd);
        }
        if ((ammd = this.getMemberMetaDataForTuples(acmd, tuples)) == null) {
            throw this.noMetaDataException(left.getId(), acmd.getFullClassName());
        }
        if (MetaDataUtils.isParentPKField(ammd)) {
            throw new UnsupportedDatastoreFeatureException("Cannot sort by parent.");
        }
        String sortProp = ammd.isPrimaryKey() ? "__key__" : this.determinePropertyName(ammd);
        return sortProp;
    }

    private boolean isJoin(Expression expr, List<String> tuples) {
        return expr instanceof VariableExpression || tuples.size() > 1 && this.getSymbolTable().hasSymbol(tuples.get(0));
    }

    private void addDiscriminator(QueryData qd, ClassLoaderResolver clr) {
        if (qd.acmd.hasDiscriminatorStrategy()) {
            String className = qd.acmd.getFullClassName();
            boolean includeSubclasses = this.query.isSubclasses();
            DatastoreManager storeMgr = this.getStoreManager();
            String discriminatorPropertyName = EntityUtils.getDiscriminatorPropertyName(storeMgr.getIdentifierFactory(), qd.acmd.getDiscriminatorMetaDataRoot());
            ArrayList<Object> discriminatorValues = new ArrayList<Object>();
            discriminatorValues.add(qd.acmd.getDiscriminatorValue());
            if (includeSubclasses) {
                for (String subClassName : storeMgr.getSubClassesForClass(className, true, clr)) {
                    AbstractClassMetaData subCmd = storeMgr.getMetaDataManager().getMetaDataForClass(subClassName, clr);
                    discriminatorValues.add(subCmd.getDiscriminatorValue());
                }
            }
            qd.primaryDatastoreQuery.addFilter(discriminatorPropertyName, Query.FilterOperator.IN, discriminatorValues);
        }
    }

    private void addMultitenancyDiscriminator(QueryData qd) {
        if (this.getStoreManager().getStringProperty("datanucleus.TenantID") != null && !"true".equalsIgnoreCase(qd.acmd.getValueForExtension("multitenancy-disable"))) {
            String multitenantPropName = this.getStoreManager().getNamingFactory().getColumnName(qd.acmd, ColumnType.MULTITENANCY_COLUMN);
            qd.primaryDatastoreQuery.addFilter(multitenantPropName, Query.FilterOperator.EQUAL, (Object)this.getStoreManager().getStringProperty("datanucleus.TenantID"));
        }
    }

    private void addFilters(QueryData qd) {
        try {
            this.addExpression(qd.compilation.getExprFilter(), qd);
            if (!qd.inFilters.isEmpty()) {
                boolean onlyKeyFilters = true;
                LinkedHashSet<Object> batchGetKeys = Utils.newLinkedHashSet(new Object[0]);
                for (Map.Entry<String, List<Object>> entry : qd.inFilters.entrySet()) {
                    if (!entry.getKey().equals("__key__")) {
                        onlyKeyFilters = false;
                    } else {
                        for (Object obj : entry.getValue()) {
                            batchGetKeys.add(this.internalPkToKey(qd.acmd, obj));
                        }
                    }
                    qd.primaryDatastoreQuery.addFilter(entry.getKey(), Query.FilterOperator.IN, entry.getValue());
                }
                if (onlyKeyFilters) {
                    if (qd.batchGetKeys == null) {
                        qd.batchGetKeys = batchGetKeys;
                    } else {
                        qd.batchGetKeys.addAll(batchGetKeys);
                    }
                }
            }
        }
        catch (NucleusException ne) {
            if (!this.inmemoryWhenUnsupported || qd.isOrExpression) {
                throw ne;
            }
            if (qd.isOrExpression) {
                // empty if block
            }
            this.filterComplete = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addExpression(Expression expr, QueryData qd) {
        if (expr == null) {
            return;
        }
        if (UNSUPPORTED_OPERATORS.contains(expr.getOperator())) {
            throw new UnsupportedDatastoreOperatorException(this.query.getSingleStringQuery(), expr.getOperator());
        }
        if (qd.isOrExpression && expr.getOperator() != null && !expr.getOperator().equals(Expression.OP_EQ) && !expr.getOperator().equals(Expression.OP_OR)) {
            throw new UnsupportedDatastoreFeatureException("'or' filters can only check equality");
        }
        if (expr instanceof DyadicExpression) {
            if (expr.getOperator().equals(Expression.OP_AND)) {
                this.addExpression(expr.getLeft(), qd);
                this.addExpression(expr.getRight(), qd);
                return;
            } else if (expr.getOperator().equals(Expression.OP_OR)) {
                boolean reset = !qd.isOrExpression;
                qd.isOrExpression = true;
                this.addExpression(expr.getLeft(), qd);
                this.addExpression(expr.getRight(), qd);
                if (!reset) return;
                qd.isOrExpression = false;
                qd.currentOrProperty = null;
                return;
            } else {
                if (DATANUCLEUS_OP_TO_APPENGINE_OP.get(expr.getOperator()) == null) {
                    throw new UnsupportedDatastoreOperatorException(this.query.getSingleStringQuery(), expr.getOperator());
                }
                if (expr.getLeft() instanceof PrimaryExpression) {
                    this.addLeftPrimaryExpression((PrimaryExpression)expr.getLeft(), expr.getOperator(), expr.getRight(), qd);
                    return;
                } else {
                    this.addExpression(expr.getLeft(), qd);
                    this.addExpression(expr.getRight(), qd);
                }
            }
            return;
        } else if (expr instanceof PrimaryExpression) {
            this.addExpression(expr.getLeft(), qd);
            this.addExpression(expr.getRight(), qd);
            return;
        } else if (expr instanceof InvokeExpression) {
            InvokeExpression invokeExpr = (InvokeExpression)expr;
            if (invokeExpr.getOperation().equals("contains") && invokeExpr.getArguments().size() == 1) {
                this.handleContainsOperation(invokeExpr, qd);
                return;
            } else if (invokeExpr.getOperation().equals("startsWith") && invokeExpr.getArguments().size() == 1) {
                this.handleStartsWithOperation(invokeExpr, qd);
                return;
            } else {
                if (!invokeExpr.getOperation().equals("matches")) throw this.newUnsupportedQueryMethodException(invokeExpr);
                this.handleMatchesOperation(invokeExpr, qd);
            }
            return;
        } else {
            if (!(expr instanceof VariableExpression)) throw new UnsupportedDatastoreFeatureException("Unexpected expression type while parsing query: " + expr.getClass().getName());
            VariableExpression varExpr = (VariableExpression)expr;
            throw new NucleusFatalUserException("Unexpected expression type while parsing query. Variables not supported by GAE (" + varExpr.getId() + ")");
        }
    }

    private void handleMatchesOperation(InvokeExpression invokeExpr, QueryData qd) {
        Expression param = (Expression)invokeExpr.getArguments().get(0);
        Expression escapeParam = null;
        if (invokeExpr.getArguments().size() == 2) {
            escapeParam = (Expression)invokeExpr.getArguments().get(1);
            throw new UnsupportedDatastoreFeatureException("GAE doesn't currently support ESCAPE syntax (" + escapeParam + ")");
        }
        if (invokeExpr.getLeft() instanceof PrimaryExpression) {
            AbstractMemberMetaData mmd;
            PrimaryExpression leftExpr = (PrimaryExpression)invokeExpr.getLeft();
            List<String> tuples = this.getTuples(leftExpr, qd.compilation.getCandidateAlias());
            if (tuples.size() == 1 && (mmd = qd.acmd.getMetaDataForMember(tuples.get(0))) != null && !String.class.isAssignableFrom(mmd.getType())) {
                throw new UnsupportedDatastoreFeatureException("The 'matches' method is only for use with a String expression");
            }
            if (param instanceof Literal) {
                String matchesExpr = this.getPrefixFromMatchesExpression(((Literal)param).getLiteral());
                this.addPrefix(leftExpr, (Expression)new Literal((Object)matchesExpr), matchesExpr, qd);
                return;
            }
            if (param instanceof ParameterExpression) {
                ParameterExpression parameterExpression = (ParameterExpression)param;
                Object parameterValue = DatastoreQuery.getParameterValue(qd.parameters, parameterExpression);
                String matchesExpr = this.getPrefixFromMatchesExpression(parameterValue);
                this.addPrefix(leftExpr, (Expression)new Literal((Object)matchesExpr), matchesExpr, qd);
                return;
            }
        }
        throw this.newUnsupportedQueryMethodException(invokeExpr);
    }

    private String getPrefixFromMatchesExpression(Object matchesExprObj) {
        if (matchesExprObj instanceof Character) {
            matchesExprObj = matchesExprObj.toString();
        }
        if (!(matchesExprObj instanceof String)) {
            throw new NucleusFatalUserException("Prefix matching only supported on strings (received a " + matchesExprObj.getClass().getName() + ").");
        }
        String matchesExpr = (String)matchesExprObj;
        String wildcardExpr = this.getStoreManager().getApiAdapter().getName().equalsIgnoreCase("JPA") ? "%" : ".*";
        int wildcardIndex = matchesExpr.indexOf(wildcardExpr);
        if (wildcardIndex == -1 || wildcardIndex != matchesExpr.length() - wildcardExpr.length()) {
            throw new UnsupportedDatastoreFeatureException("Wildcard must appear at the end of the expression string (only prefix matches are supported)");
        }
        return matchesExpr.substring(0, wildcardIndex);
    }

    private void addPrefix(PrimaryExpression left, Expression right, String prefix, QueryData qd) {
        this.addLeftPrimaryExpression(left, (Expression.Operator)Expression.OP_GTEQ, right, qd);
        Literal param = this.getUpperLimitForStartsWithStr(prefix);
        this.addLeftPrimaryExpression(left, (Expression.Operator)Expression.OP_LT, (Expression)param, qd);
    }

    private void handleStartsWithOperation(InvokeExpression invokeExpr, QueryData qd) {
        Expression param = (Expression)invokeExpr.getArguments().get(0);
        param.bind(this.getSymbolTable());
        if (invokeExpr.getLeft() instanceof PrimaryExpression) {
            AbstractMemberMetaData mmd;
            PrimaryExpression left = (PrimaryExpression)invokeExpr.getLeft();
            List<String> tuples = this.getTuples(left, qd.compilation.getCandidateAlias());
            if (tuples.size() == 1 && (mmd = qd.acmd.getMetaDataForMember(tuples.get(0))) != null && !String.class.isAssignableFrom(mmd.getType())) {
                throw new UnsupportedDatastoreFeatureException("The 'startsWith' method is only for use with a String expression");
            }
            if (param instanceof Literal) {
                this.addPrefix(left, param, (String)((Literal)param).getLiteral(), qd);
                return;
            }
            if (param instanceof ParameterExpression) {
                Object parameterValue = DatastoreQuery.getParameterValue(qd.parameters, (ParameterExpression)param);
                this.addPrefix(left, param, (String)parameterValue, qd);
                return;
            }
        }
        throw this.newUnsupportedQueryMethodException(invokeExpr);
    }

    private void handleContainsOperation(InvokeExpression invokeExpr, QueryData qd) {
        Expression param = (Expression)invokeExpr.getArguments().get(0);
        param.bind(this.getSymbolTable());
        if (invokeExpr.getLeft() instanceof PrimaryExpression) {
            AbstractMemberMetaData mmd;
            PrimaryExpression left = (PrimaryExpression)invokeExpr.getLeft();
            List<String> tuples = this.getTuples(left, qd.compilation.getCandidateAlias());
            if (tuples.size() == 1 && (mmd = qd.acmd.getMetaDataForMember(tuples.get(0))) != null && !Collection.class.isAssignableFrom(mmd.getType())) {
                throw new UnsupportedDatastoreFeatureException("The 'contains' method is only for use with a Collection expression");
            }
            this.addLeftPrimaryExpression(left, (Expression.Operator)Expression.OP_EQ, param, qd);
        } else if (invokeExpr.getLeft() instanceof ParameterExpression && param instanceof PrimaryExpression) {
            ParameterExpression pe = (ParameterExpression)invokeExpr.getLeft();
            this.addLeftPrimaryExpression((PrimaryExpression)param, (Expression.Operator)Expression.OP_EQ, (Expression)pe, qd);
        } else {
            throw this.newUnsupportedQueryMethodException(invokeExpr);
        }
    }

    private Literal getUpperLimitForStartsWithStr(String val) {
        byte[] bytes = val.getBytes();
        int i = bytes.length - 1;
        while (i >= 0) {
            byte[] endKey = new byte[i + 1];
            System.arraycopy(bytes, 0, endKey, 0, i + 1);
            int n = i--;
            endKey[n] = (byte)(endKey[n] + 1);
            if (endKey[n] == 0) continue;
            return new Literal((Object)new String(endKey));
        }
        return null;
    }

    private UnsupportedDatastoreFeatureException newUnsupportedQueryMethodException(InvokeExpression invocation) {
        throw new UnsupportedDatastoreFeatureException("Unsupported method <" + invocation.getOperation() + "> while parsing expression: " + invocation);
    }

    private static Object getParameterValue(Map paramValues, ParameterExpression pe) {
        Object key = null;
        if (paramValues.containsKey(pe.getId())) {
            key = pe.getId();
        } else {
            try {
                Integer intVal = Integer.valueOf(pe.getId());
                if (paramValues.containsKey(intVal)) {
                    key = intVal;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (key == null) {
                key = pe.getPosition();
            }
        }
        return paramValues.get(key);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addLeftPrimaryExpression(PrimaryExpression left, Expression.Operator operator, Expression right, QueryData qd) {
        void var6_15;
        String datastorePropName;
        void var6_11;
        AbstractMemberMetaData ammd;
        Query.FilterOperator op = DATANUCLEUS_OP_TO_APPENGINE_OP.get(operator);
        if (op == null) {
            throw new UnsupportedDatastoreFeatureException("Operator " + operator + " does not have a " + "corresponding operator in the datastore api.");
        }
        if (right instanceof PrimaryExpression) {
            Object v = qd.parameters.get(((PrimaryExpression)right).getId());
        } else if (right instanceof Literal) {
            Object object = ((Literal)right).getLiteral();
        } else if (right instanceof ParameterExpression) {
            Object object = DatastoreQuery.getParameterValue(qd.parameters, (ParameterExpression)right);
        } else if (right instanceof DyadicExpression) {
            Object object = this.getValueFromDyadicExpression(right);
        } else if (right instanceof InvokeExpression) {
            InvokeExpression invoke = (InvokeExpression)right;
            if (!invoke.getOperation().equals("CURRENT_TIMESTAMP") && !invoke.getOperation().equals("CURRENT_DATE")) throw this.newUnsupportedQueryMethodException((InvokeExpression)right);
            Date date = NOW_PROVIDER.now();
        } else {
            if (!(right instanceof VariableExpression)) throw new UnsupportedDatastoreFeatureException("Right side of expression is of unexpected type: " + right.getClass().getName());
            if (!op.equals((Object)Query.FilterOperator.EQUAL)) {
                throw new UnsupportedDatastoreFeatureException("Operator " + operator + " cannot be " + "used as part of the join condition.  Use 'contains' if joining on a Collection field " + "and equality if joining on a single-value field.");
            }
            qd.joinVariableExpression = (VariableExpression)right;
            qd.joinOrderExpression = this.createJoinOrderExpression(left);
            return;
        }
        List<String> tuples = this.getTuples(left, qd.compilation.getCandidateAlias());
        AbstractClassMetaData acmd = qd.acmd;
        com.google.appengine.api.datastore.Query datastoreQuery = qd.primaryDatastoreQuery;
        if (this.isJoin(left.getLeft(), tuples)) {
            acmd = this.getJoinClassMetaData(left.getLeft(), tuples, qd);
            datastoreQuery = qd.joinQuery;
            if (datastoreQuery == null) {
                String kind = EntityUtils.determineKind(acmd, this.getExecutionContext());
                datastoreQuery = new com.google.appengine.api.datastore.Query(kind);
                datastoreQuery.setKeysOnly();
                qd.joinQuery = datastoreQuery;
            }
        }
        if ((ammd = this.getMemberMetaDataForTuples(acmd, tuples)) == null) {
            throw this.noMetaDataException(left.getId(), acmd.getFullClassName());
        }
        int relationType = ammd.getRelationType(this.getClassLoaderResolver());
        if (Relation.isRelationSingleValued((int)relationType)) {
            this.processPersistableMember(qd, op, ammd, var6_11);
            return;
        }
        if (MetaDataUtils.isParentPKField(ammd)) {
            this.addParentFilter(op, this.internalPkToKey(acmd, var6_11), qd.primaryDatastoreQuery);
            return;
        }
        if (ammd.isPrimaryKey()) {
            if (var6_11 instanceof Collection) {
                this.processPotentialBatchGet(qd, (Collection)var6_11, acmd, op);
                ArrayList<Object> keys = Utils.newArrayList(new Object[0]);
                for (Object obj : (Collection)var6_11) {
                    keys.add(this.internalPkToKey(acmd, obj));
                }
                ArrayList<Object> arrayList = keys;
            } else {
                Key key = this.internalPkToKey(acmd, var6_11);
            }
            datastorePropName = "__key__";
        } else {
            datastorePropName = this.determinePropertyName(ammd);
        }
        Object object = this.pojoParamToDatastoreParam(var6_15, ammd.getType());
        if (qd.isOrExpression) {
            this.addLeftPrimaryOrExpression(qd, datastorePropName, object);
            return;
        }
        if (object instanceof Collection) {
            if (op != Query.FilterOperator.EQUAL) throw new UnsupportedDatastoreFeatureException("Collection parameters are only supported for equality filters.");
            op = Query.FilterOperator.IN;
        }
        try {
            void var6_18;
            if (!ammd.hasContainer()) {
                Object object2 = this.getStoreManager().getTypeConversionUtils().pojoValueToDatastoreValue(this.getExecutionContext().getNucleusContext().getTypeManager(), this.getClassLoaderResolver(), object, ammd);
            }
            datastoreQuery.addFilter(datastorePropName, op, (Object)var6_18);
            return;
        }
        catch (IllegalArgumentException iae) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(iae);
        }
    }

    private void addLeftPrimaryOrExpression(QueryData qd, String datastorePropName, Object value) {
        if (qd.currentOrProperty == null) {
            qd.currentOrProperty = datastorePropName;
        } else if (!qd.currentOrProperty.equals(datastorePropName)) {
            throw new UnsupportedDatastoreFeatureException("Or filters cannot be applied to multiple properties (found both " + qd.currentOrProperty + " and " + datastorePropName + ").");
        }
        List<Object> valueList = qd.inFilters.get(datastorePropName);
        if (valueList == null) {
            valueList = Utils.newArrayList(new Object[0]);
            qd.inFilters.put(datastorePropName, valueList);
        }
        if (value instanceof Iterable) {
            for (Object v : (Iterable)value) {
                valueList.add(v);
            }
        } else {
            valueList.add(value);
        }
    }

    private AbstractClassMetaData getJoinClassMetaData(Expression expr, List<String> tuples, QueryData qd) {
        if (expr instanceof VariableExpression) {
            if (qd.joinVariableExpression == null) {
                throw new NucleusFatalUserException(this.query.getSingleStringQuery() + ": Encountered a variable expression that isn't part of a join.  Maybe you're " + "referencing a non-existent field of an embedded class.");
            }
            if (!((VariableExpression)expr).getId().equals(qd.joinVariableExpression.getId())) {
                throw new NucleusFatalUserException(this.query.getSingleStringQuery() + ": Encountered a variable (" + ((VariableExpression)expr).getId() + ") that doesn't match the join variable (" + qd.joinVariableExpression.getId() + ")");
            }
            Class joinedClass = this.getSymbolTable().getSymbol(qd.joinVariableExpression.getId()).getValueType();
            return this.getMetaDataManager().getMetaDataForClass(joinedClass, this.getClassLoaderResolver());
        }
        Symbol sym = this.getSymbolTable().getSymbol(tuples.get(0));
        tuples.remove(0);
        return this.getMetaDataManager().getMetaDataForClass(sym.getValueType(), this.getClassLoaderResolver());
    }

    private OrderExpression createJoinOrderExpression(PrimaryExpression expression) {
        PrimaryExpression primaryOrderExpr = new PrimaryExpression(expression.getTuples());
        return new OrderExpression((Expression)primaryOrderExpr);
    }

    private void processPotentialBatchGet(QueryData qd, Collection value, AbstractClassMetaData acmd, Query.FilterOperator op) {
        if (!op.equals((Object)Query.FilterOperator.EQUAL)) {
            throw new NucleusFatalUserException("Batch lookup by primary key is only supported with the equality operator.");
        }
        qd.batchGetKeys = Utils.newLinkedHashSet(new Object[0]);
        for (Object obj : value) {
            qd.batchGetKeys.add(this.internalPkToKey(acmd, obj));
        }
    }

    private Object getValueFromDyadicExpression(Expression expr) {
        DyadicExpression dyadic = (DyadicExpression)expr;
        if (dyadic.getLeft() instanceof Literal && ((Literal)dyadic.getLeft()).getLiteral() instanceof Number && dyadic.getRight() == null && Expression.OP_NEG.equals(dyadic.getOperator())) {
            Number negateMe = (Number)((Literal)dyadic.getLeft()).getLiteral();
            return this.negateNumber(negateMe);
        }
        throw new UnsupportedDatastoreFeatureException("Right side of expression is composed of unsupported components.  Left: " + dyadic.getLeft().getClass().getName() + ", Op: " + dyadic.getOperator() + ", Right: " + dyadic.getRight());
    }

    private List<String> getTuples(PrimaryExpression expr, String alias) {
        ArrayList<Object> tuples = Utils.newArrayList(new Object[0]);
        tuples.addAll(expr.getTuples());
        return DatastoreQuery.getTuples(tuples, alias);
    }

    static List<String> getTuples(List<String> tuples, String alias) {
        if (alias != null && tuples.size() > 1 && alias.equals(tuples.get(0))) {
            tuples = tuples.subList(1, tuples.size());
        }
        return tuples;
    }

    private Object pojoParamToDatastoreParam(Object param, Class type) {
        if (param instanceof Enum) {
            param = ((Enum)param).name();
        } else if (param instanceof byte[]) {
            param = new ShortBlob((byte[])param);
        } else if (param instanceof Byte[]) {
            param = new ShortBlob(PrimitiveArrays.toByteArray(Arrays.asList((Byte[])param)));
        } else if (param instanceof BigDecimal) {
            if (type.equals(Double.class) || type.equals(Double.TYPE) || type.equals(Float.class) || type.equals(Float.TYPE)) {
                param = ((BigDecimal)param).doubleValue();
            }
        } else if (param instanceof Character) {
            param = param.toString();
        }
        return param;
    }

    private NucleusException noMetaDataException(String member, String fullClassName) {
        return new NucleusFatalUserException("No meta-data for member named " + member + " on class " + fullClassName + ".  Are you sure you provided the correct member name in your query?");
    }

    private Object negateNumber(Number negateMe) {
        if (negateMe instanceof BigDecimal) {
            return BigDecimals.toSortableString(((BigDecimal)negateMe).negate());
        }
        if (negateMe instanceof Float) {
            return Float.valueOf(-((Float)negateMe).floatValue());
        }
        if (negateMe instanceof Double) {
            return -((Double)negateMe).doubleValue();
        }
        return -negateMe.longValue();
    }

    private AbstractMemberMetaData getMemberMetaDataForTuples(AbstractClassMetaData acmd, List<String> tuples) {
        AbstractMemberMetaData ammd = acmd.getMetaDataForMember(tuples.get(0));
        if (ammd == null || tuples.size() == 1) {
            return ammd;
        }
        String parentFullClassName = acmd.getFullClassName();
        for (String tuple : tuples.subList(1, tuples.size())) {
            EmbeddedMetaData emd = ammd.getEmbeddedMetaData();
            if (emd == null) {
                throw new NucleusFatalUserException(this.query.getSingleStringQuery() + ": Can only reference properties of a sub-object if " + "the sub-object is embedded.");
            }
            DatastoreTable parentTable = this.getStoreManager().getDatastoreClass(parentFullClassName, this.getClassLoaderResolver());
            parentFullClassName = ammd.getTypeName();
            AbstractMemberMetaData parentField = (AbstractMemberMetaData)emd.getParent();
            EmbeddedMapping embeddedMapping = (EmbeddedMapping)parentTable.getMappingForFullFieldName(parentField.getFullFieldName());
            ammd = this.findMemberMetaDataWithName(tuple, embeddedMapping);
            if (ammd != null) continue;
            break;
        }
        return ammd;
    }

    private AbstractMemberMetaData findMemberMetaDataWithName(String name, EmbeddedMapping embeddedMapping) {
        int numMappings = embeddedMapping.getNumberOfJavaTypeMappings();
        for (int i = 0; i < numMappings; ++i) {
            JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
            if (!fieldMapping.getMemberMetaData().getName().equals(name)) continue;
            return fieldMapping.getMemberMetaData();
        }
        return null;
    }

    private void processPersistableMember(QueryData qd, Query.FilterOperator op, AbstractMemberMetaData ammd, Object value) {
        Object jdoPrimaryKey;
        ClassLoaderResolver clr = this.getClassLoaderResolver();
        AbstractClassMetaData acmd = this.getMetaDataManager().getMetaDataForClass(ammd.getType(), clr);
        if (value instanceof Key || value instanceof String) {
            jdoPrimaryKey = value;
        } else if (value instanceof Long || value instanceof Integer) {
            String kind = EntityUtils.determineKind(acmd, this.getExecutionContext());
            jdoPrimaryKey = KeyFactory.createKey((String)kind, (long)((Number)value).longValue());
        } else if (value == null) {
            jdoPrimaryKey = null;
        } else {
            ApiAdapter apiAdapter = this.getExecutionContext().getApiAdapter();
            jdoPrimaryKey = apiAdapter.getTargetKeyForSingleFieldIdentity(apiAdapter.getIdForObject(value));
            if (jdoPrimaryKey == null) {
                Object jdoID = apiAdapter.getNewApplicationIdentityObjectId(value, acmd);
                jdoPrimaryKey = apiAdapter.getTargetKeyForSingleFieldIdentity(jdoID);
            }
            if (jdoPrimaryKey == null) {
                throw new NucleusFatalUserException(this.query.getSingleStringQuery() + ": Parameter value " + value + " does not have an id.");
            }
        }
        Key valueKey = null;
        if (jdoPrimaryKey != null) {
            valueKey = this.internalPkToKey(acmd, jdoPrimaryKey);
            this.verifyRelatedKeyIsOfProperType(ammd, valueKey, acmd);
        }
        if (!MetaDataUtils.isOwnedRelation(ammd, this.getStoreManager())) {
            qd.primaryDatastoreQuery.addFilter(this.determinePropertyName(ammd), Query.FilterOperator.EQUAL, (Object)valueKey);
            return;
        }
        if (!qd.table.isParentKeyProvider(ammd)) {
            if (op != Query.FilterOperator.EQUAL) {
                throw new UnsupportedDatastoreFeatureException("Only the equals operator is supported on conditions involving the owning side of a one-to-one.");
            }
            if (valueKey == null) {
                throw new NucleusFatalUserException(this.query.getSingleStringQuery() + ": Cannot query for parents with null children.");
            }
            if (valueKey.getParent() == null) {
                throw new NucleusFatalUserException(this.query.getSingleStringQuery() + ": Key of parameter value does not have a parent.");
            }
            qd.primaryDatastoreQuery.addFilter("__key__", Query.FilterOperator.EQUAL, (Object)valueKey.getParent());
        } else {
            if (valueKey == null) {
                throw new NucleusFatalUserException(this.query.getSingleStringQuery() + ": The datastore does not support querying for objects with null parents.");
            }
            this.addParentFilter(op, valueKey, qd.primaryDatastoreQuery);
        }
    }

    private void verifyRelatedKeyIsOfProperType(AbstractMemberMetaData ammd, Key key, AbstractClassMetaData acmd) {
        String fieldKind;
        String keyKind = key.getKind();
        if (!keyKind.equals(fieldKind = this.getIdentifierFactory().newDatastoreContainerIdentifier(acmd).getIdentifierName())) {
            throw new NucleusFatalUserException(this.query.getSingleStringQuery() + ": Field " + ammd.getFullFieldName() + " maps to kind " + fieldKind + " but" + " parameter value contains Key of kind " + keyKind);
        }
    }

    private String determinePropertyName(AbstractMemberMetaData ammd) {
        if (ammd.hasExtension("gae.pk-id") || ammd.hasExtension("gae.pk-name")) {
            throw new NucleusFatalUserException(this.query.getSingleStringQuery() + ": Field " + ammd.getFullFieldName() + " is a sub-component of the primary key.  The " + "datastore does not support filtering or sorting by primary key components, only the " + "entire primary key.");
        }
        if (ammd.getColumn() != null) {
            return ammd.getColumn();
        }
        if (ammd.getColumnMetaData() != null && ammd.getColumnMetaData().length != 0) {
            return ammd.getColumnMetaData()[0].getName();
        }
        if (ammd.getElementMetaData() != null && ammd.getElementMetaData().getColumnMetaData() != null && ammd.getElementMetaData().getColumnMetaData().length != 0) {
            return ammd.getElementMetaData().getColumnMetaData()[0].getName();
        }
        return this.getIdentifierFactory().newDatastoreFieldIdentifier(ammd.getName()).getIdentifierName();
    }

    private Key internalPkToKey(AbstractClassMetaData acmd, Object internalPk) {
        Key key;
        if (internalPk instanceof String) {
            try {
                key = KeyFactory.stringToKey((String)((String)internalPk));
            }
            catch (IllegalArgumentException iae) {
                String kind = this.getIdentifierFactory().newDatastoreContainerIdentifier(acmd).getIdentifierName();
                key = KeyFactory.createKey((String)kind, (String)((String)internalPk));
            }
        } else if (internalPk instanceof Long) {
            String kind = this.getIdentifierFactory().newDatastoreContainerIdentifier(acmd).getIdentifierName();
            key = KeyFactory.createKey((String)kind, (long)((Long)internalPk));
        } else {
            key = (Key)internalPk;
        }
        return key;
    }

    private void addParentFilter(Query.FilterOperator op, Key key, com.google.appengine.api.datastore.Query datastoreQuery) {
        if (op != Query.FilterOperator.EQUAL) {
            throw new UnsupportedDatastoreFeatureException("Operator is of type " + op + " but the " + "datastore only supports parent queries using the equality operator.");
        }
        if (key == null) {
            throw new UnsupportedDatastoreFeatureException("Received a null parent parameter.  The datastore does not support querying for null parents.");
        }
        datastoreQuery.setAncestor(key);
    }

    private boolean isBulkDelete() {
        return this.query.getType() == 2;
    }

    com.google.appengine.api.datastore.Query getLatestDatastoreQuery() {
        return this.latestDatastoreQuery;
    }

    private ExecutionContext getExecutionContext() {
        return this.query.getExecutionContext();
    }

    private MetaDataManager getMetaDataManager() {
        return this.getExecutionContext().getMetaDataManager();
    }

    private ClassLoaderResolver getClassLoaderResolver() {
        return this.getExecutionContext().getClassLoaderResolver();
    }

    private IdentifierFactory getIdentifierFactory() {
        return this.getStoreManager().getIdentifierFactory();
    }

    private DatastoreManager getStoreManager() {
        return (DatastoreManager)this.query.getStoreManager();
    }

    private SymbolTable getSymbolTable() {
        return this.query.getCompilation().getSymbolTable();
    }

    public static interface NowProvider {
        public Date now();
    }

    class UnsupportedDatastoreFeatureException
    extends NucleusUserException {
        UnsupportedDatastoreFeatureException(String msg) {
            super("Problem with query <" + DatastoreQuery.this.query.getSingleStringQuery() + ">: " + msg);
        }
    }

    static class UnsupportedDatastoreOperatorException
    extends NucleusUserException {
        private final String queryString;
        private final Expression.Operator operator;
        private final String msg;

        UnsupportedDatastoreOperatorException(String queryString, Expression.Operator operator) {
            this(queryString, operator, null);
        }

        UnsupportedDatastoreOperatorException(String queryString, Expression.Operator operator, String msg) {
            super(queryString);
            this.queryString = queryString;
            this.operator = operator;
            this.msg = msg;
        }

        public String getMessage() {
            return "Problem with query <" + this.queryString + ">: App Engine datastore does not support operator " + this.operator + ".  " + (this.msg == null ? "" : this.msg);
        }

        public Expression.Operator getOperation() {
            return this.operator;
        }
    }

    static enum ResultType {
        ENTITY,
        KEYS_ONLY;

    }
}

