/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.index;

import com.google.appengine.repackaged.org.apache.lucene.document.Document;
import com.google.appengine.repackaged.org.apache.lucene.document.FieldSelector;
import com.google.appengine.repackaged.org.apache.lucene.index.CorruptIndexException;
import com.google.appengine.repackaged.org.apache.lucene.index.DirectoryReader;
import com.google.appengine.repackaged.org.apache.lucene.index.IndexReader;
import com.google.appengine.repackaged.org.apache.lucene.index.SegmentReader;
import com.google.appengine.repackaged.org.apache.lucene.index.Term;
import com.google.appengine.repackaged.org.apache.lucene.index.TermDocs;
import com.google.appengine.repackaged.org.apache.lucene.index.TermEnum;
import com.google.appengine.repackaged.org.apache.lucene.index.TermFreqVector;
import com.google.appengine.repackaged.org.apache.lucene.index.TermPositions;
import com.google.appengine.repackaged.org.apache.lucene.index.TermVectorMapper;
import com.google.appengine.repackaged.org.apache.lucene.search.DefaultSimilarity;
import com.google.appengine.repackaged.org.apache.lucene.search.FieldCache;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MultiReader
extends IndexReader
implements Cloneable {
    protected IndexReader[] subReaders;
    private int[] starts;
    private boolean[] decrefOnClose;
    private Map normsCache = new HashMap();
    private int maxDoc = 0;
    private int numDocs = -1;
    private boolean hasDeletions = false;
    private byte[] ones;

    public MultiReader(IndexReader[] subReaders) {
        this.initialize(subReaders, true);
    }

    public MultiReader(IndexReader[] subReaders, boolean closeSubReaders) {
        this.initialize(subReaders, closeSubReaders);
    }

    private void initialize(IndexReader[] subReaders, boolean closeSubReaders) {
        this.subReaders = (IndexReader[])subReaders.clone();
        this.starts = new int[subReaders.length + 1];
        this.decrefOnClose = new boolean[subReaders.length];
        for (int i = 0; i < subReaders.length; ++i) {
            this.starts[i] = this.maxDoc;
            this.maxDoc += subReaders[i].maxDoc();
            if (!closeSubReaders) {
                subReaders[i].incRef();
                this.decrefOnClose[i] = true;
            } else {
                this.decrefOnClose[i] = false;
            }
            if (!subReaders[i].hasDeletions()) continue;
            this.hasDeletions = true;
        }
        this.starts[subReaders.length] = this.maxDoc;
    }

    public synchronized IndexReader reopen() throws CorruptIndexException, IOException {
        return this.doReopen(false);
    }

    public synchronized Object clone() {
        try {
            return this.doReopen(true);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected IndexReader doReopen(boolean doClone) throws CorruptIndexException, IOException {
        this.ensureOpen();
        reopened = false;
        newSubReaders = new IndexReader[this.subReaders.length];
        success = false;
        try {
            for (i = 0; i < this.subReaders.length; ++i) {
                newSubReaders[i] = doClone != false ? (IndexReader)this.subReaders[i].clone() : this.subReaders[i].reopen();
                if (newSubReaders[i] == this.subReaders[i]) continue;
                reopened = true;
            }
            success = true;
            var7_7 = null;
            ** if (success || !reopened) goto lbl-1000
        }
        catch (Throwable var6_13) {
            var7_8 = null;
            if (!success && reopened) {
                for (i = 0; i < newSubReaders.length; ++i) {
                    if (newSubReaders[i] == this.subReaders[i]) continue;
                    try {
                        newSubReaders[i].close();
                        continue;
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
            }
            throw var6_13;
        }
lbl-1000:
        // 4 sources

        {
            for (i = 0; i < newSubReaders.length; ++i) {
                if (newSubReaders[i] == this.subReaders[i]) continue;
                try {
                    newSubReaders[i].close();
                    continue;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        if (reopened) {
            newDecrefOnClose = new boolean[this.subReaders.length];
            for (i = 0; i < this.subReaders.length; ++i) {
                if (newSubReaders[i] != this.subReaders[i]) continue;
                newSubReaders[i].incRef();
                newDecrefOnClose[i] = true;
            }
            mr = new MultiReader(newSubReaders);
            mr.decrefOnClose = newDecrefOnClose;
            mr.setDisableFakeNorms(this.getDisableFakeNorms());
            return mr;
        }
        return this;
    }

    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(n);
        return this.subReaders[i].getTermFreqVectors(n - this.starts[i]);
    }

    public TermFreqVector getTermFreqVector(int n, String field) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(n);
        return this.subReaders[i].getTermFreqVector(n - this.starts[i], field);
    }

    public void getTermFreqVector(int docNumber, String field, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(docNumber);
        this.subReaders[i].getTermFreqVector(docNumber - this.starts[i], field, mapper);
    }

    public void getTermFreqVector(int docNumber, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(docNumber);
        this.subReaders[i].getTermFreqVector(docNumber - this.starts[i], mapper);
    }

    public boolean isOptimized() {
        return false;
    }

    public int numDocs() {
        if (this.numDocs == -1) {
            int n = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                n += this.subReaders[i].numDocs();
            }
            this.numDocs = n;
        }
        return this.numDocs;
    }

    public int maxDoc() {
        return this.maxDoc;
    }

    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        int i = this.readerIndex(n);
        return this.subReaders[i].document(n - this.starts[i], fieldSelector);
    }

    public boolean isDeleted(int n) {
        int i = this.readerIndex(n);
        return this.subReaders[i].isDeleted(n - this.starts[i]);
    }

    public boolean hasDeletions() {
        return this.hasDeletions;
    }

    protected void doDelete(int n) throws CorruptIndexException, IOException {
        this.numDocs = -1;
        int i = this.readerIndex(n);
        this.subReaders[i].deleteDocument(n - this.starts[i]);
        this.hasDeletions = true;
    }

    protected void doUndeleteAll() throws CorruptIndexException, IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].undeleteAll();
        }
        this.hasDeletions = false;
        this.numDocs = -1;
    }

    private int readerIndex(int n) {
        return DirectoryReader.readerIndex(n, this.starts, this.subReaders.length);
    }

    public boolean hasNorms(String field) throws IOException {
        this.ensureOpen();
        for (int i = 0; i < this.subReaders.length; ++i) {
            if (!this.subReaders[i].hasNorms(field)) continue;
            return true;
        }
        return false;
    }

    private byte[] fakeNorms() {
        if (this.ones == null) {
            this.ones = SegmentReader.createFakeNorms(this.maxDoc());
        }
        return this.ones;
    }

    public synchronized byte[] norms(String field) throws IOException {
        this.ensureOpen();
        byte[] bytes = (byte[])this.normsCache.get(field);
        if (bytes != null) {
            return bytes;
        }
        if (!this.hasNorms(field)) {
            return this.getDisableFakeNorms() ? null : this.fakeNorms();
        }
        bytes = new byte[this.maxDoc()];
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(field, bytes, this.starts[i]);
        }
        this.normsCache.put(field, bytes);
        return bytes;
    }

    public synchronized void norms(String field, byte[] result, int offset) throws IOException {
        int i;
        this.ensureOpen();
        byte[] bytes = (byte[])this.normsCache.get(field);
        for (i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(field, result, offset + this.starts[i]);
        }
        if (bytes == null && !this.hasNorms(field)) {
            Arrays.fill(result, offset, result.length, DefaultSimilarity.encodeNorm(1.0f));
        } else if (bytes != null) {
            System.arraycopy(bytes, 0, result, offset, this.maxDoc());
        } else {
            for (i = 0; i < this.subReaders.length; ++i) {
                this.subReaders[i].norms(field, result, offset + this.starts[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetNorm(int n, String field, byte value) throws CorruptIndexException, IOException {
        Map map = this.normsCache;
        synchronized (map) {
            this.normsCache.remove(field);
        }
        int i = this.readerIndex(n);
        this.subReaders[i].setNorm(n - this.starts[i], field, value);
    }

    public TermEnum terms() throws IOException {
        this.ensureOpen();
        return new DirectoryReader.MultiTermEnum(this, this.subReaders, this.starts, null);
    }

    public TermEnum terms(Term term) throws IOException {
        this.ensureOpen();
        return new DirectoryReader.MultiTermEnum(this, this.subReaders, this.starts, term);
    }

    public int docFreq(Term t) throws IOException {
        this.ensureOpen();
        int total = 0;
        for (int i = 0; i < this.subReaders.length; ++i) {
            total += this.subReaders[i].docFreq(t);
        }
        return total;
    }

    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        return new DirectoryReader.MultiTermDocs(this, this.subReaders, this.starts);
    }

    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        return new DirectoryReader.MultiTermPositions(this, this.subReaders, this.starts);
    }

    protected void doCommit() throws IOException {
        this.doCommit(null);
    }

    protected void doCommit(Map commitUserData) throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].commit(commitUserData);
        }
    }

    protected synchronized void doClose() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            if (this.decrefOnClose[i]) {
                this.subReaders[i].decRef();
                continue;
            }
            this.subReaders[i].close();
        }
        FieldCache.DEFAULT.purge(this);
    }

    public Collection getFieldNames(IndexReader.FieldOption fieldNames) {
        this.ensureOpen();
        return DirectoryReader.getFieldNames(fieldNames, this.subReaders);
    }

    public boolean isCurrent() throws CorruptIndexException, IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            if (this.subReaders[i].isCurrent()) continue;
            return false;
        }
        return true;
    }

    public long getVersion() {
        throw new UnsupportedOperationException("MultiReader does not support this method.");
    }

    public IndexReader[] getSequentialSubReaders() {
        return this.subReaders;
    }
}

