/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.internal;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.extractor.Extractor;
import com.google.cloud.datastore.internal.Transaction;

public class Transactions {
    public static final Extractor<Long> NO_TRANSACTIONS_EXTRACTOR = new Extractor<Long>(){};

    public static long getTransactionHandle(ByteString transactionBytes) throws InvalidConversionException {
        InvalidConversionException.checkConversion(!transactionBytes.isEmpty(), "Invalid transaction.", new Object[0]);
        try {
            return ((Transaction)Transaction.parser().parseFrom(transactionBytes)).getHandle();
        }
        catch (InvalidProtocolBufferException e) {
            throw new InvalidConversionException("Invalid transaction.", e);
        }
    }

    @Deprecated
    public static long getTransactionHandleLegacy(ByteString transactionBytes) throws InvalidConversionException {
        InvalidConversionException.checkConversion(!transactionBytes.isEmpty(), "transaction required", new Object[0]);
        try {
            return ((Transaction)Transaction.parser().parseFrom(transactionBytes)).getHandle();
        }
        catch (InvalidProtocolBufferException e) {
            throw new InvalidConversionException("Invalid transaction.", e);
        }
    }

    private Transactions() {
    }
}

