/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_TransactionOptions;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@AutoValue
public abstract class TransactionOptions {
    public static final TransactionOptions SINGLE_USE_WRITE = TransactionOptions.builder().mode(Mode.READ_WRITE).singleUse(true).build();

    public static Builder builder() {
        return new AutoValue_TransactionOptions.Builder().allowMultipleEg(true).mode(Mode.UNSPECIFIED).concurrencyMode(ConcurrencyMode.DEFAULT).singleUse(false);
    }

    public abstract Builder toBuilder();

    public abstract boolean allowMultipleEg();

    public abstract boolean singleUse();

    public abstract Mode mode();

    public abstract ConcurrencyMode concurrencyMode();

    @CheckReturnValue
    @Nullable
    public abstract Long previousTransactionHandle();

    @Nullable
    public abstract Long snapshotVersion();

    @Nullable
    public abstract Long readTimestampMicros();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder allowMultipleEg(boolean var1);

        public abstract Builder singleUse(boolean var1);

        public abstract Builder mode(Mode var1);

        public abstract Builder previousTransactionHandle(@Nullable Long var1);

        public abstract Builder snapshotVersion(@Nullable Long var1);

        public abstract Builder readTimestampMicros(@Nullable Long var1);

        public abstract Builder concurrencyMode(ConcurrencyMode var1);

        abstract TransactionOptions autoBuild();

        public TransactionOptions build() {
            TransactionOptions options = this.autoBuild();
            if (options.mode() != Mode.READ_ONLY) {
                Preconditions.checkState((options.snapshotVersion() == null && options.readTimestampMicros() == null ? 1 : 0) != 0);
            }
            Preconditions.checkState((options.snapshotVersion() == null || options.snapshotVersion() > 0L ? 1 : 0) != 0);
            Preconditions.checkState((options.readTimestampMicros() == null || options.readTimestampMicros() > 0L ? 1 : 0) != 0);
            Preconditions.checkState((options.snapshotVersion() == null || options.readTimestampMicros() == null ? 1 : 0) != 0);
            return options;
        }
    }

    public static enum ConcurrencyMode {
        DEFAULT,
        PESSIMISTIC;

    }

    public static enum Mode {
        UNSPECIFIED(true),
        READ_ONLY(false),
        READ_WRITE(true),
        WRITE_ONLY(true);

        private final boolean writeAllowed;

        private Mode(boolean writeAllowed) {
            this.writeAllowed = writeAllowed;
        }

        public boolean isWriteAllowed() {
            return this.writeAllowed;
        }
    }
}

