/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.validator;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.rep.EntitySize;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.validator.ValidationConstraint;
import java.util.Collection;

public class PropertyPathValidator {
    private final int maxIndexedValueBytes;
    private final int maxEntityValueDepth;
    private final boolean rejectLegacyWhitelistedIndexReservedPropertyNames;

    public PropertyPathValidator(Config.DatastoreConfig config) {
        Preconditions.checkNotNull((Object)config);
        this.maxIndexedValueBytes = config.getMaxIndexedValueBytes();
        this.maxEntityValueDepth = config.getMaxEntityValueDepth();
        this.rejectLegacyWhitelistedIndexReservedPropertyNames = config.getRejectLegacyWhitelistedIndexReservedPropertyNames();
    }

    public PropertyPathValidator(int maxIndexedValueBytes, int maxEntityValueDepth, boolean rejectLegacyWhitelistedIndexReservedPropertyNames) {
        this.maxIndexedValueBytes = maxIndexedValueBytes;
        this.maxEntityValueDepth = maxEntityValueDepth;
        this.rejectLegacyWhitelistedIndexReservedPropertyNames = rejectLegacyWhitelistedIndexReservedPropertyNames;
    }

    public void validatePropertyPathsInMask(Collection<PropertyPath> propertyPaths, ValidationConstraint constraint) throws InvalidConversionException {
        constraint = constraint.withContext(ValidationConstraint.Context.IN_PROPERTY_MASK);
        try {
            for (PropertyPath propertyPath : propertyPaths) {
                this.validatePropertyPath(propertyPath, constraint);
            }
        }
        catch (ValidationException exception) {
            throw new InvalidConversionException(exception.getMessage(), exception);
        }
    }

    public void validatePropertyPath(PropertyPath propertyPath, ValidationConstraint constraint) throws ValidationException {
        ValidationException.validateAssertion(propertyPath.next() == null || constraint.allowMultisegmentPath(), "only single segment property path allowed", new Object[0]);
        ValidationException.validateAssertion(EntitySize.propertyPathSize(propertyPath) <= this.maxIndexedValueBytes, "property path is longer than %d bytes.", this.maxIndexedValueBytes);
        int segmentCount = 0;
        while (propertyPath != null) {
            ++segmentCount;
            if (propertyPath.segment() instanceof PropertyPathSegment.Member) {
                PropertyPathSegment.Member memberSegment = (PropertyPathSegment.Member)propertyPath.segment();
                propertyPath = propertyPath.next();
                boolean firstSegment = segmentCount == 1;
                boolean lastSegment = propertyPath == null;
                this.validatePropertyNameInPath(memberSegment.name(), firstSegment, lastSegment, constraint);
                continue;
            }
            if (propertyPath.segment() instanceof PropertyPathSegment.AllArrayElements) {
                ValidationException.validateAssertion(constraint.allowAllArrayElements(), "accessing array elements is not allowed", new Object[0]);
                propertyPath = propertyPath.next();
                ValidationException.validateAssertion(propertyPath == null, "accessing elements within an array is not allowed", new Object[0]);
                continue;
            }
            ValidationException.validateAssertion(false, "Invalid property path", new Object[0]);
        }
        ValidationException.validateAssertion(segmentCount <= this.maxEntityValueDepth, "paths must have at most %d elements", this.maxEntityValueDepth);
    }

    public void validatePropertyNameInPath(PropertyName name, boolean firstSegment, boolean lastSegment, ValidationConstraint constraint) throws ValidationException {
        ValidationException.validateAssertion(!name.string().isEmpty(), "a property path segment cannot be empty", new Object[0]);
        if (name.isReserved()) {
            ValidationException.validateAssertion(constraint.allowReservedName(this.rejectLegacyWhitelistedIndexReservedPropertyNames, name, firstSegment, lastSegment), "the name %s is reserved", name.string());
        }
    }
}

