/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.AbstractBackendServers;
import com.google.appengine.tools.development.Modules;
import com.google.appengine.tools.development.ModulesFilterHelper;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DelegatingModulesFilterHelper
implements ModulesFilterHelper {
    private final AbstractBackendServers backendServers;
    private final Modules modules;

    public DelegatingModulesFilterHelper(AbstractBackendServers backendServers, Modules modules) {
        this.backendServers = backendServers;
        this.modules = modules;
    }

    @Override
    public boolean acquireServingPermit(String moduleOrBackendName, int instanceNumber, boolean allowQueueOnBackends) {
        if (this.isBackend(moduleOrBackendName)) {
            return this.backendServers.acquireServingPermit(moduleOrBackendName, instanceNumber, allowQueueOnBackends);
        }
        return this.modules.acquireServingPermit(moduleOrBackendName, instanceNumber, allowQueueOnBackends);
    }

    @Override
    public int getAndReserveFreeInstance(String moduleOrBackendName) {
        if (this.isBackend(moduleOrBackendName)) {
            return this.backendServers.getAndReserveFreeInstance(moduleOrBackendName);
        }
        return this.modules.getAndReserveFreeInstance(moduleOrBackendName);
    }

    @Override
    public void returnServingPermit(String moduleOrBackendName, int instance) {
        if (this.isBackend(moduleOrBackendName)) {
            this.backendServers.returnServingPermit(moduleOrBackendName, instance);
        } else {
            this.modules.returnServingPermit(moduleOrBackendName, instance);
        }
    }

    @Override
    public boolean checkInstanceExists(String moduleOrBackendName, int instance) {
        if (this.isBackend(moduleOrBackendName)) {
            return this.backendServers.checkInstanceExists(moduleOrBackendName, instance);
        }
        return this.modules.checkInstanceExists(moduleOrBackendName, instance);
    }

    @Override
    public boolean checkModuleExists(String moduleOrBackendName) {
        if (this.isBackend(moduleOrBackendName)) {
            return this.backendServers.checkServerExists(moduleOrBackendName);
        }
        return this.modules.checkModuleExists(moduleOrBackendName);
    }

    @Override
    public boolean checkModuleStopped(String moduleOrBackendName) {
        if (this.isBackend(moduleOrBackendName)) {
            return this.backendServers.checkServerStopped(moduleOrBackendName);
        }
        return this.modules.checkModuleStopped(moduleOrBackendName);
    }

    @Override
    public boolean checkInstanceStopped(String moduleOrBackendName, int instance) {
        if (this.isBackend(moduleOrBackendName)) {
            return this.backendServers.checkInstanceStopped(moduleOrBackendName, instance);
        }
        return this.modules.checkInstanceStopped(moduleOrBackendName, instance);
    }

    @Override
    public void forwardToInstance(String moduleOrBackendName, int instance, HttpServletRequest hrequest, HttpServletResponse response) throws IOException, ServletException {
        if (this.isBackend(moduleOrBackendName)) {
            this.backendServers.forwardToServer(moduleOrBackendName, instance, hrequest, response);
        } else {
            this.modules.forwardToInstance(moduleOrBackendName, instance, hrequest, response);
        }
    }

    @Override
    public boolean isLoadBalancingInstance(String moduleOrBackendName, int instance) {
        if (this.isBackend(moduleOrBackendName)) {
            return false;
        }
        return this.modules.isLoadBalancingInstance(moduleOrBackendName, instance);
    }

    private boolean isBackend(String moduleOrBackendName) {
        return this.backendServers.checkServerExists(moduleOrBackendName);
    }

    @Override
    public boolean expectsGeneratedStartRequests(String moduleOrBackendName, int instance) {
        if (this.isBackend(moduleOrBackendName)) {
            return instance >= 0;
        }
        return this.modules.expectsGeneratedStartRequests(moduleOrBackendName, instance);
    }

    @Override
    public int getPort(String moduleOrBackendName, int instance) {
        if (this.isBackend(moduleOrBackendName)) {
            return this.backendServers.getPort(moduleOrBackendName, instance);
        }
        return this.modules.getPort(moduleOrBackendName, instance);
    }
}

