/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.AbstractInstanceHolder;
import com.google.appengine.tools.development.ApplicationConfigurationManager;
import com.google.appengine.tools.development.ContainerService;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.DevAppServerPortPropertyHelper;
import com.google.appengine.tools.development.InstanceHelper;
import com.google.appengine.tools.development.InstanceStateHolder;
import com.google.appengine.tools.development.LocalServerEnvironment;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

class ManualInstanceHolder
extends AbstractInstanceHolder {
    private static final int MAX_START_QUEUE_TIME_MS = 30000;
    private static final Logger LOGGER = Logger.getLogger(ManualInstanceHolder.class.getName());
    private final String moduleName;
    private final InstanceStateHolder stateHolder;
    private final InstanceHelper instanceHelper;
    private volatile CountDownLatch startRequestLatch;
    private ApplicationConfigurationManager.ModuleConfigurationHandle moduleConfigurationHandle;
    private String serverInfo;
    private File externalResourceDir;
    private String address;
    private Map<String, Object> containerConfigProperties;
    private DevAppServer devAppServer;
    Integer port;

    ManualInstanceHolder(String moduleName, ContainerService containerService, int instance, InstanceStateHolder stateHolder, InstanceHelper instanceHelper) {
        super(containerService, instance);
        this.moduleName = moduleName;
        this.stateHolder = stateHolder;
        this.instanceHelper = instanceHelper;
        this.startRequestLatch = new CountDownLatch(1);
    }

    @Override
    public boolean isLoadBalancingInstance() {
        return this.isMainInstance();
    }

    @Override
    public boolean expectsGeneratedStartRequest() {
        return !this.isMainInstance();
    }

    public String toString() {
        String string = String.valueOf(this.getContainerService());
        int n = this.getInstance();
        return new StringBuilder(66 + String.valueOf(string).length()).append("ManualServerInstanceHolder: containerservice=").append(string).append(" instance=").append(n).toString();
    }

    @Override
    public void startUp() throws Exception {
        this.stateHolder.testAndSet(InstanceStateHolder.InstanceState.INITIALIZING, InstanceStateHolder.InstanceState.SHUTDOWN);
        this.getContainerService().startup();
        this.stateHolder.testAndSet(InstanceStateHolder.InstanceState.STOPPED, InstanceStateHolder.InstanceState.INITIALIZING);
        this.startServing();
    }

    @Override
    public void createConnection() throws Exception {
        super.createConnection();
        if (this.port != null && this.port.intValue() != this.getContainerService().getPort()) {
            String string = this.moduleName;
            int n = this.getInstance();
            String string2 = String.valueOf(this.port);
            int n2 = this.getContainerService().getPort();
            throw new IllegalStateException(new StringBuilder(95 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Port has been reassigned for module=").append(string).append(" instance=").append(n).append(" original port = ").append(string2).append(" new port=").append(n2).toString());
        }
        this.port = this.getContainerService().getPort();
    }

    void setConfiguration(ApplicationConfigurationManager.ModuleConfigurationHandle moduleConfigurationHandle, String serverInfo, File externalResourceDir, String address, Map<String, Object> containerConfigProperties, DevAppServer devAppServer) {
        this.moduleConfigurationHandle = moduleConfigurationHandle;
        this.serverInfo = serverInfo;
        this.externalResourceDir = externalResourceDir;
        this.address = address;
        this.containerConfigProperties = containerConfigProperties;
        this.devAppServer = devAppServer;
    }

    LocalServerEnvironment doConfigure() {
        ContainerService containerService = this.getContainerService();
        LocalServerEnvironment result = containerService.configure(this.serverInfo, this.address, this.getPortForDoConfigure(), this.moduleConfigurationHandle, this.externalResourceDir, this.containerConfigProperties, this.getInstance(), this.devAppServer);
        return result;
    }

    private int getPortForDoConfigure() {
        if (this.port == null) {
            return DevAppServerPortPropertyHelper.getPort(this.moduleName, this.getInstance(), this.devAppServer.getServiceProperties());
        }
        return this.port;
    }

    void stopServing() throws Exception {
        if (this.isMainInstance()) {
            this.stateHolder.testAndSet(InstanceStateHolder.InstanceState.STOPPED, InstanceStateHolder.InstanceState.RUNNING);
        } else {
            this.instanceHelper.shutdown();
            this.stateHolder.testAndSet(InstanceStateHolder.InstanceState.INITIALIZING, InstanceStateHolder.InstanceState.SHUTDOWN);
            this.startRequestLatch = new CountDownLatch(1);
            this.doConfigure();
            this.createConnection();
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ManualInstanceHolder.this.getContainerService().startup();
                    return null;
                }
            });
            this.stateHolder.testAndSet(InstanceStateHolder.InstanceState.STOPPED, InstanceStateHolder.InstanceState.INITIALIZING);
        }
    }

    void startServing() throws Exception {
        if (!this.stateHolder.test(InstanceStateHolder.InstanceState.STOPPED)) {
            String string = String.valueOf(this.stateHolder);
            String string2 = this.moduleName;
            throw new IllegalStateException(new StringBuilder(26 + String.valueOf(string).length() + String.valueOf(string2).length()).append("stopServing state=").append(string).append(" module=").append(string2).toString());
        }
        if (this.isMainInstance()) {
            this.stateHolder.testAndSet(InstanceStateHolder.InstanceState.RUNNING, InstanceStateHolder.InstanceState.STOPPED);
        } else {
            this.stateHolder.testAndSet(InstanceStateHolder.InstanceState.SLEEPING, InstanceStateHolder.InstanceState.STOPPED);
            this.sendStartRequest();
        }
    }

    void requireState(String operation, InstanceStateHolder.InstanceState requiredState) {
        this.stateHolder.requireState(operation, requiredState);
    }

    private void sendStartRequest() {
        this.instanceHelper.sendStartRequest(new Runnable(){

            @Override
            public void run() {
                ManualInstanceHolder.this.startRequestLatch.countDown();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquireServingPermit() {
        LOGGER.logp(Level.FINEST, "com.google.appengine.tools.development.ManualInstanceHolder", "acquireServingPermit", String.format("trying to get serving permit for %d.%s", this.getInstance(), this.moduleName));
        int maxWaitTime = 0;
        InstanceStateHolder instanceStateHolder = this.stateHolder;
        synchronized (instanceStateHolder) {
            if (!this.stateHolder.acceptsConnections()) {
                LOGGER.logp(Level.FINEST, "com.google.appengine.tools.development.ManualInstanceHolder", "acquireServingPermit", String.valueOf(this.moduleName).concat(": got request but instance is not in a serving state"));
                return false;
            }
            if (this.stateHolder.test(InstanceStateHolder.InstanceState.SLEEPING)) {
                LOGGER.logp(Level.FINEST, "com.google.appengine.tools.development.ManualInstanceHolder", "acquireServingPermit", String.valueOf(this.moduleName).concat(": waking up sleeping instance"));
                this.sendStartRequest();
            }
            if (this.stateHolder.test(InstanceStateHolder.InstanceState.RUNNING_START_REQUEST)) {
                maxWaitTime = 30000;
            }
        }
        try {
            boolean gotPermit = this.startRequestLatch.await(maxWaitTime, TimeUnit.MILLISECONDS);
            int n = this.getInstance();
            String string = this.moduleName;
            int n2 = maxWaitTime;
            LOGGER.logp(Level.FINEST, "com.google.appengine.tools.development.ManualInstanceHolder", "acquireServingPermit", new StringBuilder(76 + String.valueOf(string).length()).append(n).append(".").append(string).append(": tried to get serving permit, timeout=").append(n2).append(" success=").append(gotPermit).toString());
            return gotPermit;
        }
        catch (InterruptedException e) {
            int n = this.getInstance();
            String string = this.moduleName;
            LOGGER.logp(Level.FINEST, "com.google.appengine.tools.development.ManualInstanceHolder", "acquireServingPermit", new StringBuilder(62 + String.valueOf(string).length()).append(n).append(".").append(string).append(": got interrupted while waiting for serving permit").toString());
            return false;
        }
    }

    @Override
    public boolean isStopped() {
        return this.stateHolder.test(InstanceStateHolder.InstanceState.STOPPED);
    }
}

