// Copyright 2010 Google Inc. All Rights Reserved.

package com.google.appengine.api.blobstore;

/**
 * {@code UnsupportedRangeFormatException} is an unchecked exception that is thrown
 * when an valid but unsupported Range header format is provided.
 *
 */
public class UnsupportedRangeFormatException extends RangeFormatException {
  private static final long serialVersionUID = -2678138419307671864L;

  public UnsupportedRangeFormatException(String message) {
    super(message);
  }

  public UnsupportedRangeFormatException(String message, Throwable cause) {
    super(message, cause);
  }
}
