/**********************************************************************
Copyright (c) 2007 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.enhancer.asm;

import java.io.Serializable;

import org.datanucleus.enhancer.AbstractImplementationCreator;
import org.datanucleus.enhancer.AbstractImplementationGenerator;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.InterfaceMetaData;

/**
 * Creator of persistable objects using the ASM bytecode manipulation library.
 * 
 * @version $Revision: 1.2 $
 */
public class ASMImplementationCreator extends AbstractImplementationCreator implements Serializable
{
    /**
     * Method to return the generator for the implementation.
     * @param acmd MetaData for the interface or abstract class
     * @param implClassName Name of the implementation class to create
     * @return The implementation generator
     */
    protected AbstractImplementationGenerator getGenerator(AbstractClassMetaData acmd, String implClassName)
    {
        if (acmd instanceof InterfaceMetaData)
        {
            // Implementation of an interface
            return new ASMImplementationGenerator((InterfaceMetaData)acmd, implClassName);
        }
        else if (acmd instanceof ClassMetaData)
        {
            // Implementation of an abstract class
            return new ASMImplementationGenerator((ClassMetaData)acmd, implClassName);
        }
        return null;
    }
}