/**********************************************************************
Copyright (c) 2005 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;

import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

/**
 * Interface representation of the querying capabilities of a backing store for an array.
 * This is part of the JDOQL "expression" design that will be refactored out when the 
 * new query engine replaces it.
 **/
public interface ArrayStoreQueryable
{
    /**
     * Create a subquery for the given query that joins a SetStore
     * element table to the owner table. This subquery can subsequently be used
     * in an EXISTS expression to determine whether a Collection is empty. 
     * @param stmt The Query Statement.
     * @param ownerMapping the mapping for the owner. 
     * @param ownerTe Table Expression for the owner
     * @param collRangeVar   The range variable for the "Collection" table. 
     * @return  A subquery for the given query that joins a SetStore
     *          element table to the owner table. 
     */ 
    QueryExpression getExistsSubquery(QueryExpression stmt,
                            JavaTypeMapping ownerMapping,
                            LogicSetExpression ownerTe,
                            DatastoreIdentifier collRangeVar);

    /**
     * Create a subquery for the size of the collection.
     * @param stmt The Query Statement
     * @param ownerMapping Mapping for the owner
     * @param ownerTe Table Expression for the owner
     * @param collRangeVar Range variable for the owner
     * @return The subquery
     */
    QueryExpression getSizeSubquery(QueryExpression stmt,
                            JavaTypeMapping ownerMapping,
                            LogicSetExpression ownerTe,
                            DatastoreIdentifier collRangeVar);

    /**
     * Method used in queries when contains() has been invoked.
     * @param stmt The Query Statement
     * @param parentStmt the parent Query Statement. If there is no parent, <code>parentStmt</code> must be equals to <code>stmt</code> 
     * @param ownerMapping the mapping for the owner. 
     * @param ownerTe Table Expression for the owner
     * @param collRangeVar   The range variable for the "Collection" table. 
     * @param filteredElementType The Class Type for the filtered element
     * @param elmExpr The Expression for the element
     * @param elementRangeVar The SQL alias, or "range variable", to assign to the
     *                      expression or to the element table.
     * @return expression to the join
     **/
    ScalarExpression joinElementsTo(QueryExpression stmt,
                            QueryExpression parentStmt,
                            JavaTypeMapping ownerMapping,
                            LogicSetExpression ownerTe,
                            DatastoreIdentifier collRangeVar,
                            Class filteredElementType,
                            ScalarExpression elmExpr,
                            DatastoreIdentifier elementRangeVar);
}