/**********************************************************************
Copyright (c) 20026 Erik Bengtson and others. All rights reserved. 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ObjectManager;
import org.datanucleus.api.ApiAdapter;

/**
 * Maps to identity objects of PersistenceCapable values.
 * 
 * Used only from within JDOQL queries on JDOHelper.getObjectId expressions
 *
 * @version $Revision: 1.4 $ 
 **/
public class ObjectIdClassMapping extends PersistenceCapableMapping
{
    
    /**
     * Constructor used to generate a PCMapping representing only the identity of the object.
     * This is typically used where the user has selected the id in a JDOQL query as a result field.
     * @param pcMapping The mapping to base it on
     */
    public ObjectIdClassMapping(PersistenceCapableMapping pcMapping)
    {
        super();
        initialize(pcMapping.dba, pcMapping.type);
        datastoreContainer = pcMapping.datastoreContainer;

        // Add the same field mappings to the identity
        javaTypeMappings = new JavaTypeMapping[pcMapping.javaTypeMappings.length]; 
        System.arraycopy(pcMapping.javaTypeMappings, 0, javaTypeMappings, 0, javaTypeMappings.length);
    }

    /**
     * Returns a instance of a PersistenceCapable class.
     * Processes a FK field and converts the id stored firstly into an OID/AID
     * and then into the object that the FK id relates to.
     * @param om The ObjectManager
     * @param rs The ResultSet
     * @param param Array of parameter ids in the ResultSet to retrieve
     * @return The Persistence Capable object
     */
    public Object getObject(ObjectManager om, final Object rs, int[] param)
    {
        Object value = super.getObject(om, rs, param);
        if (value != null)
        {
            ApiAdapter api = om.getApiAdapter();
            return api.getIdForObject(value);
        }
        return null;
    }
}