/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import jnr.constants.platform.Signal;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubySignal;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.SignalException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"SignalException"}, parent="Exception")
public class RubySignalException
extends RubyException {
    private static final ObjectAllocator SIGNAL_EXCEPTION_ALLOCATOR = (runtime2, klass) -> new RubySignalException(runtime2, klass);
    private IRubyObject signo;

    protected RubySignalException(Ruby runtime2, RubyClass exceptionClass) {
        super(runtime2, exceptionClass);
    }

    @Override
    protected RaiseException constructThrowable(String message2) {
        return new SignalException(message2, this);
    }

    static RubyClass define(Ruby runtime2, RubyClass exceptionClass) {
        RubyClass signalExceptionClass = runtime2.defineClass("SignalException", exceptionClass, SIGNAL_EXCEPTION_ALLOCATOR);
        signalExceptionClass.defineAnnotatedMethods(RubySignalException.class);
        return signalExceptionClass;
    }

    @JRubyMethod(optional=2, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        long _signo;
        Ruby runtime2 = context.runtime;
        int argnum = 1;
        IRubyObject sig = context.nil;
        int argc = args2.length;
        if (argc > 0) {
            sig = TypeConverter.checkIntegerType(runtime2, args2[0], "to_int");
            if (sig.isNil()) {
                sig = args2[0];
            } else {
                argnum = 2;
            }
        }
        Arity.checkArgumentCount(runtime2, args2, 1, argnum);
        if (argnum == 2) {
            _signo = sig.convertToInteger().getLongValue();
            if (_signo < 0L || _signo > Signal.NSIG.longValue()) {
                throw runtime2.newArgumentError("invalid signal number (" + _signo + ")");
            }
            sig = argc > 1 ? args2[1] : runtime2.newString(RubySignal.signmWithPrefix(RubySignal.signo2signm(_signo)));
        } else {
            String signm = sig.toString();
            _signo = RubySignal.signm2signo(RubySignal.signmWithoutPrefix(signm));
            if (_signo == 0L) {
                throw runtime2.newArgumentError("unsupported name " + sig);
            }
            sig = runtime2.newString(RubySignal.signmWithPrefix(signm));
        }
        super.initialize(new IRubyObject[]{sig}, block);
        this.signo = runtime2.newFixnum(_signo);
        return this;
    }

    @JRubyMethod
    public IRubyObject signo(ThreadContext context) {
        assert (this.signo != null);
        if (this.signo == RubyBasicObject.UNDEF) {
            return context.nil;
        }
        return this.signo;
    }

    @Override
    @JRubyMethod(name={"message", "signm"})
    public IRubyObject message(ThreadContext context) {
        return super.message(context);
    }
}

