/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import java.util.Objects;
import org.jruby.Ruby;
import org.jruby.ast.LiteralValue;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NumericNode;
import org.jruby.ast.SideEffectFree;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.runtime.builtin.IRubyObject;

public class FixnumNode
extends NumericNode
implements ILiteralNode,
LiteralValue,
SideEffectFree {
    private long value;

    public FixnumNode(int line, long value2) {
        super(line);
        this.value = value2;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitFixnumNode(this);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.FIXNUMNODE;
    }

    @Override
    public NumericNode negate() {
        return new FixnumNode(this.getLine(), -this.value);
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value2) {
        this.value = value2;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public String toStringExtraInfo() {
        return "long: " + this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixnumNode that = (FixnumNode)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public IRubyObject literalValue(Ruby runtime2) {
        return runtime2.newFixnum(this.value);
    }
}

