/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.similarity;

import org.basex.util.Token;
import org.basex.util.list.IntList;

public final class ColognePhonetic {
    private static final byte[] AHKLOQRUX = Token.token("ahkloqrux");
    private static final byte[] AEIJOUY = Token.token("aeijouy");
    private static final byte[] AHOUKQX = Token.token("ahoukqx");
    private static final byte[] WFPV = Token.token("wfpv");
    private static final byte[] CKQ = Token.token("ckq");
    private static final byte[] GKQ = Token.token("gkq");
    private static final byte[] SCZ = Token.token("scz");
    private static final byte[] TDX = Token.token("tdx");

    private ColognePhonetic() {
    }

    public static int[] encode(int[] cps) {
        IntList tmp = new IntList(cps.length);
        for (int cp : cps) {
            int c = Token.lc(cp);
            if (c == 228) {
                c = 97;
            } else if (c == 246) {
                c = 111;
            } else if (c == 252) {
                c = 117;
            } else if (c == 223) {
                c = 115;
            }
            tmp.add(c);
        }
        IntList out = new IntList();
        int[] in = tmp.finish();
        int il = in.length;
        int lastCp = 45;
        int lastCode = 47;
        int ip = il;
        while (ip > 0) {
            int code;
            int nextCp;
            int cp = in[il - ip--];
            int n = nextCp = ip > 0 ? in[il - ip] : 45;
            if (Token.contains(AEIJOUY, cp)) {
                code = 48;
            } else if (cp == 104 || cp < 97 || cp > 122) {
                if (lastCode == 47) continue;
                code = 45;
            } else if (cp == 98 || cp == 112 && nextCp != 104) {
                code = 49;
            } else if (!(cp != 100 && cp != 116 || Token.contains(SCZ, nextCp))) {
                code = 50;
            } else if (Token.contains(WFPV, cp)) {
                code = 51;
            } else if (Token.contains(GKQ, cp)) {
                code = 52;
            } else if (cp == 120 && !Token.contains(CKQ, lastCp)) {
                code = 52;
                in[il - ++ip] = 115;
            } else {
                code = cp == 115 || cp == 122 ? 56 : (cp == 99 ? (lastCode == 47 ? (Token.contains(AHKLOQRUX, nextCp) ? 52 : 56) : (lastCp == 115 || lastCp == 122 || !Token.contains(AHOUKQX, nextCp) ? 56 : 52)) : (Token.contains(TDX, cp) ? 56 : (cp == 114 ? 55 : (cp == 108 ? 53 : (cp == 109 || cp == 110 ? 54 : cp)))));
            }
            if (code != 45 && (lastCode != code && (code != 48 || lastCode == 47) || code > 56)) {
                out.add(code);
            }
            lastCp = cp;
            lastCode = code;
        }
        return out.finish();
    }
}

