/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.index.resource.ResourceType;
import org.basex.index.resource.Resources;
import org.basex.io.IOFile;
import org.basex.query.up.atomic.AtomicUpdateCache;
import org.basex.util.list.IntList;

public final class Delete
extends ACreate {
    public Delete(String target) {
        super(Perm.WRITE, true, target);
    }

    @Override
    protected boolean run() {
        Data data = this.context.data();
        String path = MetaData.normPath(this.args[0]);
        if (path == null) {
            return this.error(Text.PATH_INVALID_X, this.args[0]);
        }
        IntList docs = data.resources.docs(path);
        return this.update(data, () -> {
            AtomicUpdateCache auc = new AtomicUpdateCache(data);
            for (int pre : docs.toArray()) {
                auc.addDelete(pre);
            }
            auc.execute(false);
            int size = docs.size();
            for (ResourceType type : Resources.BINARIES) {
                size += Delete.binaries(data, path, type);
            }
            return this.info(Text.RES_DELETED_X_X, size, this.jc().performance);
        });
    }

    static int binaries(Data data, String path, ResourceType type) {
        int size = 0;
        IOFile bin = data.meta.file(path, type);
        if (bin != null && bin.exists()) {
            size += bin.isDir() ? bin.descendants().size() : 1;
            bin.delete();
        }
        return size;
    }
}

