/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.Component;
import java.io.IOException;
import org.basex.build.html.HtmlOptions;
import org.basex.build.html.HtmlParser;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.dialog.DialogParser;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.ColumnLayout;
import org.basex.gui.layout.RowLayout;
import org.basex.util.Util;
import org.basex.util.options.Option;

final class DialogHtmlParser
extends DialogParser {
    private final HtmlOptions hopts;
    private final BaseXTextField options;
    private final BaseXLabel info;

    DialogHtmlParser(BaseXDialog dialog, MainOptions opts) {
        this.hopts = new HtmlOptions(opts.get(MainOptions.HTMLPARSER));
        HtmlParser.Parser parser = HtmlParser.Parser.of(this.hopts);
        boolean available = parser != null && parser.available(this.hopts);
        this.options = new BaseXTextField(dialog, this.hopts.toString());
        this.options.setToolTipText(DialogHtmlParser.tooltip(this.hopts));
        this.info = new BaseXLabel(" ").border(12, 0, 6, 0);
        BaseXBack pp = new BaseXBack(new RowLayout(8));
        pp.add(new BaseXLabel(available ? Util.info(Text.H_HTML_PARSER_X, new Object[]{parser}) : Text.H_NO_HTML_PARSER));
        if (available) {
            BaseXBack p = new BaseXBack(new ColumnLayout(8));
            p.add(new BaseXLabel(Text.PARAMETERS + ":", true, true));
            p.add(this.options);
            pp.add(p);
        }
        pp.add(this.info);
        this.add((Component)pp, "West");
    }

    @Override
    boolean action(boolean active) {
        try {
            this.hopts.assign(this.options.getText());
            this.info.setText(null, null);
            return true;
        }
        catch (IOException ex) {
            this.info.setText(ex.getMessage(), GUIConstants.Msg.ERROR);
            return false;
        }
    }

    @Override
    void update() {
    }

    @Override
    void setOptions(GUI gui) {
        gui.set(MainOptions.HTMLPARSER, this.hopts);
    }

    private static String tooltip(HtmlOptions opts) {
        StringBuilder sb = new StringBuilder("<html><b>").append(Text.PARAMETERS).append(":</b><br>");
        for (Option<?> so : opts) {
            sb.append("\u2022 ").append(so).append("<br/>");
        }
        return sb.append("</html>").toString();
    }
}

