/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.json;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.build.json.JsonOptions;
import org.basex.build.json.JsonSerialOptions;
import org.basex.io.out.PrintOutput;
import org.basex.io.parse.json.JsonConstants;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.StandardSerializer;
import org.basex.io.serial.json.JsonBasicSerializer;
import org.basex.io.serial.json.JsonMLSerializer;
import org.basex.io.serial.json.JsonNodeSerializer;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryText;
import org.basex.query.value.Value;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;
import org.basex.util.options.Options;

public abstract class JsonSerializer
extends StandardSerializer {
    private static final QNm FN_NULL = new QNm(JsonConstants.NULL, QueryText.FN_URI);
    final JsonSerialOptions jopts;
    final boolean escape;
    final boolean escapeSolidus;
    final boolean lines;
    final boolean nodups;
    private final PrintOutput.Fallback fallback = cp -> {
        if (Character.isBmpCodePoint(cp)) {
            this.out.print(92);
            this.out.print(117);
            this.out.print(Token.hex(cp, 4));
        } else {
            this.out.print(92);
            this.out.print(117);
            this.out.print(Token.hex(Character.highSurrogate(cp), 4));
            this.out.print(92);
            this.out.print(117);
            this.out.print(Token.hex(Character.lowSurrogate(cp), 4));
        }
    };

    public static Serializer get(OutputStream os, SerializerOptions so) throws IOException {
        return switch (so.get(SerializerOptions.JSON).get(JsonOptions.FORMAT)) {
            case JsonOptions.JsonFormat.JSONML -> new JsonMLSerializer(os, so);
            case JsonOptions.JsonFormat.W3_XML, JsonOptions.JsonFormat.BASIC -> new JsonBasicSerializer(os, so);
            default -> new JsonNodeSerializer(os, so);
        };
    }

    JsonSerializer(OutputStream os, SerializerOptions sopts) throws IOException {
        super(os, sopts);
        this.jopts = sopts.get(SerializerOptions.JSON);
        this.escape = this.jopts.get(JsonSerialOptions.ESCAPE);
        this.escapeSolidus = this.escape && this.jopts.get(JsonSerialOptions.ESCAPE_SOLIDUS) != false && sopts.get(SerializerOptions.ESCAPE_SOLIDUS) == Options.YesNo.YES;
        this.nodups = sopts.get(SerializerOptions.ALLOW_DUPLICATE_NAMES) == Options.YesNo.NO;
        this.lines = sopts.get(SerializerOptions.JSON_LINES) == Options.YesNo.YES;
        Boolean ji = this.jopts.get(JsonSerialOptions.INDENT);
        if (ji != null) {
            this.indent = ji;
        }
    }

    @Override
    public void serialize(Item item) throws IOException {
        QNm qnm;
        if (this.sep) {
            if (!this.lines) {
                throw QueryError.SERJSON.getIO(new Object[0]);
            }
            this.out.print(10);
        }
        if (item == null || item instanceof QNm && (qnm = (QNm)item).eq(FN_NULL)) {
            this.out.print(JsonConstants.NULL);
        } else {
            super.serialize(item);
        }
        this.sep = true;
    }

    private void serialize(Value value) throws IOException {
        if (value.size() > 1L) {
            throw QueryError.SERJSONSEQ.getIO(new Object[0]);
        }
        this.sep = false;
        this.serialize(value.isEmpty() ? null : (Item)value);
    }

    @Override
    public void function(FItem item) throws IOException {
        block11: {
            try {
                if (item instanceof XQMap) {
                    XQMap map = (XQMap)item;
                    ++this.level;
                    this.out.print(123);
                    boolean s = false;
                    TokenSet set = this.nodups ? new TokenSet() : null;
                    for (Item key : map.keys()) {
                        byte[] name = key.string(null);
                        if (this.nodups) {
                            if (set.contains(name)) {
                                throw QueryError.SERDUPL_X.getIO(new Object[]{name});
                            }
                            set.put(name);
                        }
                        if (s) {
                            this.out.print(44);
                        }
                        this.indent();
                        this.string(name);
                        this.out.print(58);
                        if (this.indent) {
                            this.out.print(32);
                        }
                        this.serialize(map.get(key));
                        s = true;
                    }
                    --this.level;
                    this.indent();
                    this.out.print(125);
                    break block11;
                }
                if (item instanceof XQArray) {
                    XQArray array = (XQArray)item;
                    ++this.level;
                    this.out.print(91);
                    boolean s = false;
                    for (Value value : array.iterable()) {
                        if (s) {
                            this.out.print(44);
                        }
                        this.indent();
                        this.serialize(value);
                        s = true;
                    }
                    --this.level;
                    this.indent();
                    this.out.print(93);
                    break block11;
                }
                throw QueryError.SERJSONFUNC_X.getIO(item.type);
            }
            catch (QueryException ex) {
                throw new QueryIOException(ex);
            }
        }
        this.sep = true;
    }

    @Override
    protected void atomic(Item item) throws IOException {
        try {
            Type type = item.type;
            if (type.oneOf(AtomType.DOUBLE, AtomType.FLOAT)) {
                double d = item.dbl(null);
                if (!Double.isFinite(d)) {
                    throw QueryError.SERNUMBER_X.getIO(d);
                }
                this.out.print(Dbl.string(d));
            } else if (type == AtomType.BOOLEAN || type.isNumber()) {
                this.out.print(item.string(null));
            } else {
                this.string(item.string(null));
            }
        }
        catch (QueryException ex) {
            throw new QueryIOException(ex);
        }
    }

    @Override
    protected void indent() throws IOException {
        if (!this.lines) {
            super.indent();
        } else if (this.indent) {
            this.out.print(32);
        }
    }

    @Override
    protected boolean separate() {
        return false;
    }

    protected final void string(byte[] string) throws IOException {
        this.out.print(34);
        byte[] norm = Token.normalize(string, this.form);
        int nl = norm.length;
        for (int n = 0; n < nl; n += Token.cl(norm, n)) {
            this.printChar(Token.cp(norm, n));
        }
        this.out.print(34);
    }

    @Override
    protected final void print(int cp) throws IOException {
        if (this.escape) {
            switch (cp) {
                case 8: {
                    this.out.print(92);
                    this.out.print(98);
                    break;
                }
                case 12: {
                    this.out.print(92);
                    this.out.print(102);
                    break;
                }
                case 10: {
                    this.out.print(92);
                    this.out.print(110);
                    break;
                }
                case 13: {
                    this.out.print(92);
                    this.out.print(114);
                    break;
                }
                case 9: {
                    this.out.print(92);
                    this.out.print(116);
                    break;
                }
                case 34: {
                    this.out.print(92);
                    this.out.print(34);
                    break;
                }
                case 47: {
                    if (this.escapeSolidus) {
                        this.out.print(92);
                    }
                    this.out.print(47);
                    break;
                }
                case 92: {
                    this.out.print(92);
                    this.out.print(92);
                    break;
                }
                default: {
                    this.out.print(cp, this.fallback);
                    break;
                }
            }
        } else {
            this.out.print(cp, this.fallback);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.sep && !this.lines) {
            this.out.print(JsonConstants.NULL);
        }
        super.close();
    }
}

