/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.collation;

import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.VersionInfo;
import java.util.HashMap;
import java.util.Locale;
import org.basex.core.BaseXException;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.collation.CollationOptions;
import org.basex.query.util.collation.UCACollation;
import org.basex.util.Strings;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.options.EnumOption;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

public final class UCAOptions
extends CollationOptions {
    public static final EnumOption<Options.YesNo> FALLBACK = new EnumOption<Options.YesNo>("fallback", Options.YesNo.YES);
    public static final StringOption LANG = new StringOption("lang");
    public static final StringOption VERSION = new StringOption("version");
    public static final StringOption STRENGTH = new StringOption("strength");
    public static final StringOption ALTERNATE = new StringOption("alternate");
    public static final StringOption BACKWARDS = new StringOption("backwards");
    public static final StringOption NORMALIZATION = new StringOption("normalization");
    public static final StringOption CASELEVEL = new StringOption("caseLevel");
    public static final StringOption CASEFIRST = new StringOption("caseFirst");
    public static final StringOption MAXVARIABLE = new StringOption("maxVariable", "punct");
    public static final StringOption NUMERIC = new StringOption("numeric");
    public static final StringOption REORDER = new StringOption("reorder");

    public UCAOptions(boolean fallback) {
        super(fallback);
    }

    @Override
    Collation get(HashMap<String, String> args) throws BaseXException {
        Boolean n;
        Boolean c;
        Boolean n2;
        Boolean b;
        RuleBasedCollator rbc;
        block85: {
            Collator coll;
            this.assign(args);
            Locale locale = Locale.US;
            if (this.contains(LANG)) {
                Locale l = CollationOptions.Locales.MAP.get(this.get(LANG));
                if (l != null) {
                    locale = l;
                } else if (!this.fallback) {
                    throw this.error(LANG);
                }
            }
            if (!(coll = Collator.getInstance((Locale)locale)).getClass().equals(RuleBasedCollator.class)) {
                throw new BaseXException("Invalid collator: %.", coll.getClass().getName());
            }
            rbc = (RuleBasedCollator)coll;
            if (this.contains(VERSION)) {
                String v = this.get(VERSION);
                try {
                    VersionInfo vi = VersionInfo.getInstance((String)v);
                    VersionInfo vic = rbc.getUCAVersion();
                    if (!(vi != null && vic != null && vi.compareTo(vic) <= 0 || this.fallback)) {
                        throw this.error(VERSION);
                    }
                }
                catch (IllegalArgumentException ex) {
                    Util.debug(ex);
                    if (this.fallback) break block85;
                    throw new BaseXException("Version not supported: %.", v);
                }
            }
        }
        if (this.contains(STRENGTH)) {
            int s;
            switch (this.get(STRENGTH)) {
                case "primary": 
                case "1": {
                    int n3 = 0;
                    break;
                }
                case "secondary": 
                case "2": {
                    int n3 = 1;
                    break;
                }
                case "tertiary": 
                case "3": {
                    int n3 = 2;
                    break;
                }
                case "quaternary": 
                case "4": {
                    int n3 = 3;
                    break;
                }
                case "identical": 
                case "5": {
                    int n3 = 15;
                    break;
                }
                default: {
                    int n3 = s = -1;
                }
            }
            if (s >= 0) {
                rbc.setStrength(s);
            } else if (!this.fallback) {
                throw this.error(STRENGTH);
            }
        }
        if (this.contains(ALTERNATE)) {
            String v = this.get(ALTERNATE);
            Boolean b2 = Strings.eq(v, "non-ignorable") ? Boolean.FALSE : (Strings.eq(v, "shifted", "blanked") ? Boolean.TRUE : null);
            if (b2 != null) {
                rbc.setAlternateHandlingShifted(b2.booleanValue());
                if (Strings.eq(v, "blanked") && rbc.getStrength() == 3) {
                    rbc.setStrength(2);
                }
            } else if (!this.fallback) {
                throw this.error(ALTERNATE);
            }
        }
        if (this.contains(BACKWARDS) && (b = this.yesNo(BACKWARDS)) != null) {
            rbc.setFrenchCollation(b.booleanValue());
        }
        if (this.contains(NORMALIZATION) && (n2 = this.yesNo(NORMALIZATION)) != null) {
            rbc.setDecomposition(n2 != false ? 17 : 16);
        }
        if (this.contains(CASELEVEL) && (c = this.yesNo(CASELEVEL)) != null) {
            rbc.setCaseLevel(c.booleanValue());
        }
        if (this.contains(CASEFIRST)) {
            switch (this.get(CASEFIRST)) {
                case "upper": {
                    rbc.setUpperCaseFirst(true);
                    break;
                }
                case "lower": {
                    rbc.setLowerCaseFirst(true);
                    break;
                }
                default: {
                    if (this.fallback) break;
                    throw this.error(CASEFIRST);
                }
            }
        }
        if (this.contains(MAXVARIABLE)) {
            int m;
            switch (this.get(MAXVARIABLE)) {
                case "space": {
                    int n4 = 4096;
                    break;
                }
                case "punct": {
                    int n4 = 4097;
                    break;
                }
                case "symbol": {
                    int n4 = 4098;
                    break;
                }
                case "currency": {
                    int n4 = 4099;
                    break;
                }
                default: {
                    int n4 = m = -1;
                }
            }
            if (m >= 0) {
                rbc.setMaxVariable(m);
            } else if (!this.fallback) {
                throw this.error(MAXVARIABLE);
            }
        }
        if (this.contains(NUMERIC) && (n = this.yesNo(NUMERIC)) != null) {
            rbc.setNumericCollation(n.booleanValue());
        }
        if (this.contains(REORDER)) {
            IntList list = new IntList();
            String[] stringArray = Strings.split(this.get(REORDER), ',');
            int n5 = stringArray.length;
            for (int i = 0; i < n5; ++i) {
                String code;
                int c2 = switch (code = stringArray[i]) {
                    case "space" -> 4096;
                    case "punct" -> 4097;
                    case "symbol" -> 4098;
                    case "currency" -> 4099;
                    case "digit" -> 4100;
                    default -> {
                        int[] tmp;
                        int[] v3 = tmp = code.length() == 4 ? UScript.getCode((String)code) : null;
                        if (tmp != null) {
                            yield tmp[0];
                        }
                        yield -1;
                    }
                };
                if (c2 > 0) {
                    list.add(c2);
                    continue;
                }
                if (this.fallback) continue;
                throw this.error(REORDER);
            }
            if (!list.isEmpty()) {
                rbc.setReorderCodes(list.finish());
            }
        }
        return new UCACollation(rbc);
    }

    private Boolean yesNo(StringOption option) throws BaseXException {
        String v = this.get(option);
        if (v.equals("yes")) {
            return Boolean.TRUE;
        }
        if (v.equals("no")) {
            return Boolean.FALSE;
        }
        if (!this.fallback) {
            throw this.error(option);
        }
        return null;
    }
}

